/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"cardNumber", "expiryDate", "issuerCountry", "issuerState", "nationalIdExempt", "number", "type"})
public class IdentificationData {
    public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
    private String cardNumber;
    private boolean isSetCardNumber = false;
    public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
    private String expiryDate;
    private boolean isSetExpiryDate = false;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    @Deprecated
    private String issuerCountry;
    private boolean isSetIssuerCountry = false;
    public static final String JSON_PROPERTY_ISSUER_STATE = "issuerState";
    private String issuerState;
    private boolean isSetIssuerState = false;
    public static final String JSON_PROPERTY_NATIONAL_ID_EXEMPT = "nationalIdExempt";
    private Boolean nationalIdExempt;
    private boolean isSetNationalIdExempt = false;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    private boolean isSetNumber = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public IdentificationData cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        this.isSetCardNumber = true;
        return this;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardNumber() {
        return this.cardNumber;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        this.isSetCardNumber = true;
    }

    public IdentificationData expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        this.isSetExpiryDate = true;
        return this;
    }

    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryDate() {
        return this.expiryDate;
    }

    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        this.isSetExpiryDate = true;
    }

    @Deprecated
    public IdentificationData issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        this.isSetIssuerCountry = true;
        return this;
    }

    @Deprecated
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @Deprecated
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        this.isSetIssuerCountry = true;
    }

    public IdentificationData issuerState(String issuerState) {
        this.issuerState = issuerState;
        this.isSetIssuerState = true;
        return this;
    }

    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerState() {
        return this.issuerState;
    }

    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerState(String issuerState) {
        this.issuerState = issuerState;
        this.isSetIssuerState = true;
    }

    public IdentificationData nationalIdExempt(Boolean nationalIdExempt) {
        this.nationalIdExempt = nationalIdExempt;
        this.isSetNationalIdExempt = true;
        return this;
    }

    @JsonProperty(value="nationalIdExempt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNationalIdExempt() {
        return this.nationalIdExempt;
    }

    @JsonProperty(value="nationalIdExempt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationalIdExempt(Boolean nationalIdExempt) {
        this.nationalIdExempt = nationalIdExempt;
        this.isSetNationalIdExempt = true;
    }

    public IdentificationData number(String number) {
        this.number = number;
        this.isSetNumber = true;
        return this;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
        this.isSetNumber = true;
    }

    public IdentificationData type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public IdentificationData includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentificationData identificationData = (IdentificationData)o;
        return Objects.equals(this.cardNumber, identificationData.cardNumber) && Objects.equals(this.isSetCardNumber, identificationData.isSetCardNumber) && Objects.equals(this.expiryDate, identificationData.expiryDate) && Objects.equals(this.isSetExpiryDate, identificationData.isSetExpiryDate) && Objects.equals(this.issuerCountry, identificationData.issuerCountry) && Objects.equals(this.isSetIssuerCountry, identificationData.isSetIssuerCountry) && Objects.equals(this.issuerState, identificationData.issuerState) && Objects.equals(this.isSetIssuerState, identificationData.isSetIssuerState) && Objects.equals(this.nationalIdExempt, identificationData.nationalIdExempt) && Objects.equals(this.isSetNationalIdExempt, identificationData.isSetNationalIdExempt) && Objects.equals(this.number, identificationData.number) && Objects.equals(this.isSetNumber, identificationData.isSetNumber) && Objects.equals((Object)this.type, (Object)identificationData.type) && Objects.equals(this.isSetType, identificationData.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumber, this.isSetCardNumber, this.expiryDate, this.isSetExpiryDate, this.issuerCountry, this.isSetIssuerCountry, this.issuerState, this.isSetIssuerState, this.nationalIdExempt, this.isSetNationalIdExempt, this.number, this.isSetNumber, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentificationData {\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    issuerState: ").append(this.toIndentedString(this.issuerState)).append("\n");
        sb.append("    nationalIdExempt: ").append(this.toIndentedString(this.nationalIdExempt)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCardNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_CARD_NUMBER, this.cardNumber);
        }
        if (this.isSetExpiryDate) {
            this.addIfNull(nulls, JSON_PROPERTY_EXPIRY_DATE, this.expiryDate);
        }
        if (this.isSetIssuerCountry) {
            this.addIfNull(nulls, JSON_PROPERTY_ISSUER_COUNTRY, this.issuerCountry);
        }
        if (this.isSetIssuerState) {
            this.addIfNull(nulls, JSON_PROPERTY_ISSUER_STATE, this.issuerState);
        }
        if (this.isSetNationalIdExempt) {
            this.addIfNull(nulls, JSON_PROPERTY_NATIONAL_ID_EXEMPT, this.nationalIdExempt);
        }
        if (this.isSetNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_NUMBER, this.number);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static IdentificationData fromJson(String jsonString) throws JsonProcessingException {
        return (IdentificationData)JSON.getMapper().readValue(jsonString, IdentificationData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        NATIONALIDNUMBER(String.valueOf("nationalIdNumber")),
        PASSPORT(String.valueOf("passport")),
        DRIVERSLICENSE(String.valueOf("driversLicense")),
        IDENTITYCARD(String.valueOf("identityCard"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

