/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.adyen.model.checkout.PaymentMethodUPIApps;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"apps", "brand", "brands", "configuration", "fundingSource", "group", "inputDetails", "issuers", "name", "promoted", "type"})
public class PaymentMethod {
    public static final String JSON_PROPERTY_APPS = "apps";
    private List<PaymentMethodUPIApps> apps;
    private boolean isSetApps = false;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    private boolean isSetBrand = false;
    public static final String JSON_PROPERTY_BRANDS = "brands";
    private List<String> brands;
    private boolean isSetBrands = false;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private Map<String, String> configuration;
    private boolean isSetConfiguration = false;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    private boolean isSetFundingSource = false;
    public static final String JSON_PROPERTY_GROUP = "group";
    private PaymentMethodGroup group;
    private boolean isSetGroup = false;
    public static final String JSON_PROPERTY_INPUT_DETAILS = "inputDetails";
    @Deprecated
    private List<InputDetail> inputDetails;
    private boolean isSetInputDetails = false;
    public static final String JSON_PROPERTY_ISSUERS = "issuers";
    private List<PaymentMethodIssuer> issuers;
    private boolean isSetIssuers = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    private boolean isSetName = false;
    public static final String JSON_PROPERTY_PROMOTED = "promoted";
    private Boolean promoted;
    private boolean isSetPromoted = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PaymentMethod apps(List<PaymentMethodUPIApps> apps) {
        this.apps = apps;
        this.isSetApps = true;
        return this;
    }

    public PaymentMethod addAppsItem(PaymentMethodUPIApps appsItem) {
        if (this.apps == null) {
            this.apps = new ArrayList<PaymentMethodUPIApps>();
        }
        this.apps.add(appsItem);
        return this;
    }

    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethodUPIApps> getApps() {
        return this.apps;
    }

    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApps(List<PaymentMethodUPIApps> apps) {
        this.apps = apps;
        this.isSetApps = true;
    }

    public PaymentMethod brand(String brand) {
        this.brand = brand;
        this.isSetBrand = true;
        return this;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
        this.isSetBrand = true;
    }

    public PaymentMethod brands(List<String> brands) {
        this.brands = brands;
        this.isSetBrands = true;
        return this;
    }

    public PaymentMethod addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBrands() {
        return this.brands;
    }

    @JsonProperty(value="brands")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrands(List<String> brands) {
        this.brands = brands;
        this.isSetBrands = true;
    }

    public PaymentMethod configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        this.isSetConfiguration = true;
        return this;
    }

    public PaymentMethod putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
        this.isSetConfiguration = true;
    }

    public PaymentMethod fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        this.isSetFundingSource = true;
        return this;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        this.isSetFundingSource = true;
    }

    public PaymentMethod group(PaymentMethodGroup group) {
        this.group = group;
        this.isSetGroup = true;
        return this;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentMethodGroup getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroup(PaymentMethodGroup group) {
        this.group = group;
        this.isSetGroup = true;
    }

    @Deprecated
    public PaymentMethod inputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        this.isSetInputDetails = true;
        return this;
    }

    public PaymentMethod addInputDetailsItem(InputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<InputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InputDetail> getInputDetails() {
        return this.inputDetails;
    }

    @Deprecated
    @JsonProperty(value="inputDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        this.isSetInputDetails = true;
    }

    public PaymentMethod issuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        this.isSetIssuers = true;
        return this;
    }

    public PaymentMethod addIssuersItem(PaymentMethodIssuer issuersItem) {
        if (this.issuers == null) {
            this.issuers = new ArrayList<PaymentMethodIssuer>();
        }
        this.issuers.add(issuersItem);
        return this;
    }

    @JsonProperty(value="issuers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethodIssuer> getIssuers() {
        return this.issuers;
    }

    @JsonProperty(value="issuers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        this.isSetIssuers = true;
    }

    public PaymentMethod name(String name) {
        this.name = name;
        this.isSetName = true;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
        this.isSetName = true;
    }

    public PaymentMethod promoted(Boolean promoted) {
        this.promoted = promoted;
        this.isSetPromoted = true;
        return this;
    }

    @JsonProperty(value="promoted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPromoted() {
        return this.promoted;
    }

    @JsonProperty(value="promoted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromoted(Boolean promoted) {
        this.promoted = promoted;
        this.isSetPromoted = true;
    }

    public PaymentMethod type(String type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
        this.isSetType = true;
    }

    public PaymentMethod includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.apps, paymentMethod.apps) && Objects.equals(this.isSetApps, paymentMethod.isSetApps) && Objects.equals(this.brand, paymentMethod.brand) && Objects.equals(this.isSetBrand, paymentMethod.isSetBrand) && Objects.equals(this.brands, paymentMethod.brands) && Objects.equals(this.isSetBrands, paymentMethod.isSetBrands) && Objects.equals(this.configuration, paymentMethod.configuration) && Objects.equals(this.isSetConfiguration, paymentMethod.isSetConfiguration) && Objects.equals((Object)this.fundingSource, (Object)paymentMethod.fundingSource) && Objects.equals(this.isSetFundingSource, paymentMethod.isSetFundingSource) && Objects.equals(this.group, paymentMethod.group) && Objects.equals(this.isSetGroup, paymentMethod.isSetGroup) && Objects.equals(this.inputDetails, paymentMethod.inputDetails) && Objects.equals(this.isSetInputDetails, paymentMethod.isSetInputDetails) && Objects.equals(this.issuers, paymentMethod.issuers) && Objects.equals(this.isSetIssuers, paymentMethod.isSetIssuers) && Objects.equals(this.name, paymentMethod.name) && Objects.equals(this.isSetName, paymentMethod.isSetName) && Objects.equals(this.promoted, paymentMethod.promoted) && Objects.equals(this.isSetPromoted, paymentMethod.isSetPromoted) && Objects.equals(this.type, paymentMethod.type) && Objects.equals(this.isSetType, paymentMethod.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apps, this.isSetApps, this.brand, this.isSetBrand, this.brands, this.isSetBrands, this.configuration, this.isSetConfiguration, this.fundingSource, this.isSetFundingSource, this.group, this.isSetGroup, this.inputDetails, this.isSetInputDetails, this.issuers, this.isSetIssuers, this.name, this.isSetName, this.promoted, this.isSetPromoted, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    apps: ").append(this.toIndentedString(this.apps)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    issuers: ").append(this.toIndentedString(this.issuers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    promoted: ").append(this.toIndentedString(this.promoted)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetApps) {
            this.addIfNull(nulls, JSON_PROPERTY_APPS, this.apps);
        }
        if (this.isSetBrand) {
            this.addIfNull(nulls, JSON_PROPERTY_BRAND, this.brand);
        }
        if (this.isSetBrands) {
            this.addIfNull(nulls, JSON_PROPERTY_BRANDS, this.brands);
        }
        if (this.isSetConfiguration) {
            this.addIfNull(nulls, JSON_PROPERTY_CONFIGURATION, this.configuration);
        }
        if (this.isSetFundingSource) {
            this.addIfNull(nulls, JSON_PROPERTY_FUNDING_SOURCE, (Object)this.fundingSource);
        }
        if (this.isSetGroup) {
            this.addIfNull(nulls, JSON_PROPERTY_GROUP, this.group);
        }
        if (this.isSetInputDetails) {
            this.addIfNull(nulls, JSON_PROPERTY_INPUT_DETAILS, this.inputDetails);
        }
        if (this.isSetIssuers) {
            this.addIfNull(nulls, JSON_PROPERTY_ISSUERS, this.issuers);
        }
        if (this.isSetName) {
            this.addIfNull(nulls, JSON_PROPERTY_NAME, this.name);
        }
        if (this.isSetPromoted) {
            this.addIfNull(nulls, JSON_PROPERTY_PROMOTED, this.promoted);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethod)JSON.getMapper().readValue(jsonString, PaymentMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FundingSourceEnum {
        CREDIT(String.valueOf("credit")),
        DEBIT(String.valueOf("debit")),
        PREPAID(String.valueOf("prepaid"));

        private static final Logger LOG;
        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("FundingSourceEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])FundingSourceEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(FundingSourceEnum.class.getName());
        }
    }
}

