/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "expiresAt", "merchantAccount", "reference"})
public class CreateOrderRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private String expiresAt;
    private boolean isSetExpiresAt = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public CreateOrderRequest amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public CreateOrderRequest expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        this.isSetExpiresAt = true;
        return this;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        this.isSetExpiresAt = true;
    }

    public CreateOrderRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public CreateOrderRequest reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public CreateOrderRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderRequest createOrderRequest = (CreateOrderRequest)o;
        return Objects.equals(this.amount, createOrderRequest.amount) && Objects.equals(this.isSetAmount, createOrderRequest.isSetAmount) && Objects.equals(this.expiresAt, createOrderRequest.expiresAt) && Objects.equals(this.isSetExpiresAt, createOrderRequest.isSetExpiresAt) && Objects.equals(this.merchantAccount, createOrderRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, createOrderRequest.isSetMerchantAccount) && Objects.equals(this.reference, createOrderRequest.reference) && Objects.equals(this.isSetReference, createOrderRequest.isSetReference);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.isSetAmount, this.expiresAt, this.isSetExpiresAt, this.merchantAccount, this.isSetMerchantAccount, this.reference, this.isSetReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetExpiresAt) {
            this.addIfNull(nulls, JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static CreateOrderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreateOrderRequest)JSON.getMapper().readValue(jsonString, CreateOrderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

