/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"country", "identification", "identificationType"})
public class BankIdentification {
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    private boolean isSetCountry = false;
    public static final String JSON_PROPERTY_IDENTIFICATION = "identification";
    private String identification;
    private boolean isSetIdentification = false;
    public static final String JSON_PROPERTY_IDENTIFICATION_TYPE = "identificationType";
    private IdentificationTypeEnum identificationType;
    private boolean isSetIdentificationType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public BankIdentification country(String country) {
        this.country = country;
        this.isSetCountry = true;
        return this;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
        this.isSetCountry = true;
    }

    public BankIdentification identification(String identification) {
        this.identification = identification;
        this.isSetIdentification = true;
        return this;
    }

    @JsonProperty(value="identification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentification() {
        return this.identification;
    }

    @JsonProperty(value="identification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentification(String identification) {
        this.identification = identification;
        this.isSetIdentification = true;
    }

    public BankIdentification identificationType(IdentificationTypeEnum identificationType) {
        this.identificationType = identificationType;
        this.isSetIdentificationType = true;
        return this;
    }

    @JsonProperty(value="identificationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentificationTypeEnum getIdentificationType() {
        return this.identificationType;
    }

    @JsonProperty(value="identificationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentificationType(IdentificationTypeEnum identificationType) {
        this.identificationType = identificationType;
        this.isSetIdentificationType = true;
    }

    public BankIdentification includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankIdentification bankIdentification = (BankIdentification)o;
        return Objects.equals(this.country, bankIdentification.country) && Objects.equals(this.isSetCountry, bankIdentification.isSetCountry) && Objects.equals(this.identification, bankIdentification.identification) && Objects.equals(this.isSetIdentification, bankIdentification.isSetIdentification) && Objects.equals((Object)this.identificationType, (Object)bankIdentification.identificationType) && Objects.equals(this.isSetIdentificationType, bankIdentification.isSetIdentificationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.country, this.isSetCountry, this.identification, this.isSetIdentification, this.identificationType, this.isSetIdentificationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankIdentification {\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    identificationType: ").append(this.toIndentedString((Object)this.identificationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCountry) {
            this.addIfNull(nulls, JSON_PROPERTY_COUNTRY, this.country);
        }
        if (this.isSetIdentification) {
            this.addIfNull(nulls, JSON_PROPERTY_IDENTIFICATION, this.identification);
        }
        if (this.isSetIdentificationType) {
            this.addIfNull(nulls, JSON_PROPERTY_IDENTIFICATION_TYPE, (Object)this.identificationType);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static BankIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (BankIdentification)JSON.getMapper().readValue(jsonString, BankIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IdentificationTypeEnum {
        BIC(String.valueOf("bic")),
        IBAN(String.valueOf("iban")),
        ROUTINGNUMBER(String.valueOf("routingNumber")),
        SORTCODE(String.valueOf("sortCode"));

        private static final Logger LOG;
        private String value;

        private IdentificationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IdentificationTypeEnum fromValue(String value) {
            for (IdentificationTypeEnum b : IdentificationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("IdentificationTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])IdentificationTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(IdentificationTypeEnum.class.getName());
        }
    }
}

