/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.BalanceWebhookSettingInfo;
import com.adyen.model.balanceplatform.BalanceWebhookSettingInfoUpdate;
import com.adyen.model.balanceplatform.WebhookSetting;
import com.adyen.model.balanceplatform.WebhookSettings;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class BalancesApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public BalancesApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public BalancesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public WebhookSetting createWebhookSetting(String balancePlatformId, String webhookId, BalanceWebhookSettingInfo balanceWebhookSettingInfo) throws ApiException, IOException {
        return this.createWebhookSetting(balancePlatformId, webhookId, balanceWebhookSettingInfo, null);
    }

    public WebhookSetting createWebhookSetting(String balancePlatformId, String webhookId, BalanceWebhookSettingInfo balanceWebhookSettingInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balancePlatformId == null) {
            throw new IllegalArgumentException("Please provide the balancePlatformId path parameter");
        }
        pathParams.put("balancePlatformId", balancePlatformId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = balanceWebhookSettingInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{balancePlatformId}/webhooks/{webhookId}/settings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return WebhookSetting.fromJson(jsonResult);
    }

    public void deleteWebhookSetting(String balancePlatformId, String webhookId, String settingId) throws ApiException, IOException {
        this.deleteWebhookSetting(balancePlatformId, webhookId, settingId, null);
    }

    public void deleteWebhookSetting(String balancePlatformId, String webhookId, String settingId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balancePlatformId == null) {
            throw new IllegalArgumentException("Please provide the balancePlatformId path parameter");
        }
        pathParams.put("balancePlatformId", balancePlatformId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        if (settingId == null) {
            throw new IllegalArgumentException("Please provide the settingId path parameter");
        }
        pathParams.put("settingId", settingId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{balancePlatformId}/webhooks/{webhookId}/settings/{settingId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public WebhookSettings getAllWebhookSettings(String balancePlatformId, String webhookId) throws ApiException, IOException {
        return this.getAllWebhookSettings(balancePlatformId, webhookId, null);
    }

    public WebhookSettings getAllWebhookSettings(String balancePlatformId, String webhookId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balancePlatformId == null) {
            throw new IllegalArgumentException("Please provide the balancePlatformId path parameter");
        }
        pathParams.put("balancePlatformId", balancePlatformId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{balancePlatformId}/webhooks/{webhookId}/settings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return WebhookSettings.fromJson(jsonResult);
    }

    public WebhookSetting getWebhookSetting(String balancePlatformId, String webhookId, String settingId) throws ApiException, IOException {
        return this.getWebhookSetting(balancePlatformId, webhookId, settingId, null);
    }

    public WebhookSetting getWebhookSetting(String balancePlatformId, String webhookId, String settingId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balancePlatformId == null) {
            throw new IllegalArgumentException("Please provide the balancePlatformId path parameter");
        }
        pathParams.put("balancePlatformId", balancePlatformId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        if (settingId == null) {
            throw new IllegalArgumentException("Please provide the settingId path parameter");
        }
        pathParams.put("settingId", settingId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{balancePlatformId}/webhooks/{webhookId}/settings/{settingId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return WebhookSetting.fromJson(jsonResult);
    }

    public WebhookSetting updateWebhookSetting(String balancePlatformId, String webhookId, String settingId, BalanceWebhookSettingInfoUpdate balanceWebhookSettingInfoUpdate) throws ApiException, IOException {
        return this.updateWebhookSetting(balancePlatformId, webhookId, settingId, balanceWebhookSettingInfoUpdate, null);
    }

    public WebhookSetting updateWebhookSetting(String balancePlatformId, String webhookId, String settingId, BalanceWebhookSettingInfoUpdate balanceWebhookSettingInfoUpdate, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (balancePlatformId == null) {
            throw new IllegalArgumentException("Please provide the balancePlatformId path parameter");
        }
        pathParams.put("balancePlatformId", balancePlatformId);
        if (webhookId == null) {
            throw new IllegalArgumentException("Please provide the webhookId path parameter");
        }
        pathParams.put("webhookId", webhookId);
        if (settingId == null) {
            throw new IllegalArgumentException("Please provide the settingId path parameter");
        }
        pathParams.put("settingId", settingId);
        String requestBody = balanceWebhookSettingInfoUpdate.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{balancePlatformId}/webhooks/{webhookId}/settings/{settingId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return WebhookSetting.fromJson(jsonResult);
    }
}

