/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"modificationMerchantReference", "modificationPspReference", "paymentMerchantReference", "platformPaymentType", "pspPaymentReference", "type"})
public class PlatformPayment {
    public static final String JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE = "modificationMerchantReference";
    private String modificationMerchantReference;
    public static final String JSON_PROPERTY_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
    private String modificationPspReference;
    public static final String JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
    private String paymentMerchantReference;
    public static final String JSON_PROPERTY_PLATFORM_PAYMENT_TYPE = "platformPaymentType";
    private PlatformPaymentTypeEnum platformPaymentType;
    public static final String JSON_PROPERTY_PSP_PAYMENT_REFERENCE = "pspPaymentReference";
    private String pspPaymentReference;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public PlatformPayment modificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
        return this;
    }

    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationMerchantReference() {
        return this.modificationMerchantReference;
    }

    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
    }

    public PlatformPayment modificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
        return this;
    }

    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationPspReference() {
        return this.modificationPspReference;
    }

    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
    }

    public PlatformPayment paymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
        return this;
    }

    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMerchantReference() {
        return this.paymentMerchantReference;
    }

    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
    }

    public PlatformPayment platformPaymentType(PlatformPaymentTypeEnum platformPaymentType) {
        this.platformPaymentType = platformPaymentType;
        return this;
    }

    @JsonProperty(value="platformPaymentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformPaymentTypeEnum getPlatformPaymentType() {
        return this.platformPaymentType;
    }

    @JsonProperty(value="platformPaymentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformPaymentType(PlatformPaymentTypeEnum platformPaymentType) {
        this.platformPaymentType = platformPaymentType;
    }

    public PlatformPayment pspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
        return this;
    }

    @JsonProperty(value="pspPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspPaymentReference() {
        return this.pspPaymentReference;
    }

    @JsonProperty(value="pspPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
    }

    public PlatformPayment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformPayment platformPayment = (PlatformPayment)o;
        return Objects.equals(this.modificationMerchantReference, platformPayment.modificationMerchantReference) && Objects.equals(this.modificationPspReference, platformPayment.modificationPspReference) && Objects.equals(this.paymentMerchantReference, platformPayment.paymentMerchantReference) && Objects.equals((Object)this.platformPaymentType, (Object)platformPayment.platformPaymentType) && Objects.equals(this.pspPaymentReference, platformPayment.pspPaymentReference) && Objects.equals((Object)this.type, (Object)platformPayment.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modificationMerchantReference, this.modificationPspReference, this.paymentMerchantReference, this.platformPaymentType, this.pspPaymentReference, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlatformPayment {\n");
        sb.append("    modificationMerchantReference: ").append(this.toIndentedString(this.modificationMerchantReference)).append("\n");
        sb.append("    modificationPspReference: ").append(this.toIndentedString(this.modificationPspReference)).append("\n");
        sb.append("    paymentMerchantReference: ").append(this.toIndentedString(this.paymentMerchantReference)).append("\n");
        sb.append("    platformPaymentType: ").append(this.toIndentedString((Object)this.platformPaymentType)).append("\n");
        sb.append("    pspPaymentReference: ").append(this.toIndentedString(this.pspPaymentReference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PlatformPayment fromJson(String jsonString) throws JsonProcessingException {
        return (PlatformPayment)JSON.getMapper().readValue(jsonString, PlatformPayment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PLATFORMPAYMENT(String.valueOf("platformPayment"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum PlatformPaymentTypeEnum {
        ACQUIRINGFEES(String.valueOf("AcquiringFees")),
        ADYENCOMMISSION(String.valueOf("AdyenCommission")),
        ADYENFEES(String.valueOf("AdyenFees")),
        ADYENMARKUP(String.valueOf("AdyenMarkup")),
        BALANCEACCOUNT(String.valueOf("BalanceAccount")),
        CHARGEBACKREMAINDER(String.valueOf("ChargebackRemainder")),
        COMMISSION(String.valueOf("Commission")),
        DCCPLATFORMCOMMISSION(String.valueOf("DCCPlatformCommission")),
        DEFAULT(String.valueOf("Default")),
        INTERCHANGE(String.valueOf("Interchange")),
        PAYMENTFEE(String.valueOf("PaymentFee")),
        REMAINDER(String.valueOf("Remainder")),
        SCHEMEFEE(String.valueOf("SchemeFee")),
        SURCHARGE(String.valueOf("Surcharge")),
        TIP(String.valueOf("Tip")),
        TOPUP(String.valueOf("TopUp")),
        VAT(String.valueOf("VAT"));

        private static final Logger LOG;
        private String value;

        private PlatformPaymentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlatformPaymentTypeEnum fromValue(String value) {
            for (PlatformPaymentTypeEnum b : PlatformPaymentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PlatformPaymentTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PlatformPaymentTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PlatformPaymentTypeEnum.class.getName());
        }
    }
}

