/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.DeliveryMethod;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.TaxTotal;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "deliveryMethods", "paymentData", "pspReference", "sessionId", "taxTotal"})
public class PaypalUpdateOrderRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DELIVERY_METHODS = "deliveryMethods";
    private List<DeliveryMethod> deliveryMethods;
    public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
    private String paymentData;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
    private String sessionId;
    public static final String JSON_PROPERTY_TAX_TOTAL = "taxTotal";
    private TaxTotal taxTotal;

    public PaypalUpdateOrderRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaypalUpdateOrderRequest deliveryMethods(List<DeliveryMethod> deliveryMethods) {
        this.deliveryMethods = deliveryMethods;
        return this;
    }

    public PaypalUpdateOrderRequest addDeliveryMethodsItem(DeliveryMethod deliveryMethodsItem) {
        if (this.deliveryMethods == null) {
            this.deliveryMethods = new ArrayList<DeliveryMethod>();
        }
        this.deliveryMethods.add(deliveryMethodsItem);
        return this;
    }

    @JsonProperty(value="deliveryMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DeliveryMethod> getDeliveryMethods() {
        return this.deliveryMethods;
    }

    @JsonProperty(value="deliveryMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryMethods(List<DeliveryMethod> deliveryMethods) {
        this.deliveryMethods = deliveryMethods;
    }

    public PaypalUpdateOrderRequest paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentData() {
        return this.paymentData;
    }

    @JsonProperty(value="paymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public PaypalUpdateOrderRequest pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaypalUpdateOrderRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public PaypalUpdateOrderRequest taxTotal(TaxTotal taxTotal) {
        this.taxTotal = taxTotal;
        return this;
    }

    @JsonProperty(value="taxTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TaxTotal getTaxTotal() {
        return this.taxTotal;
    }

    @JsonProperty(value="taxTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxTotal(TaxTotal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaypalUpdateOrderRequest paypalUpdateOrderRequest = (PaypalUpdateOrderRequest)o;
        return Objects.equals(this.amount, paypalUpdateOrderRequest.amount) && Objects.equals(this.deliveryMethods, paypalUpdateOrderRequest.deliveryMethods) && Objects.equals(this.paymentData, paypalUpdateOrderRequest.paymentData) && Objects.equals(this.pspReference, paypalUpdateOrderRequest.pspReference) && Objects.equals(this.sessionId, paypalUpdateOrderRequest.sessionId) && Objects.equals(this.taxTotal, paypalUpdateOrderRequest.taxTotal);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.deliveryMethods, this.paymentData, this.pspReference, this.sessionId, this.taxTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaypalUpdateOrderRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    deliveryMethods: ").append(this.toIndentedString(this.deliveryMethods)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    taxTotal: ").append(this.toIndentedString(this.taxTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaypalUpdateOrderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaypalUpdateOrderRequest)JSON.getMapper().readValue(jsonString, PaypalUpdateOrderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

