/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.CreateMerchantUserRequest;
import com.adyen.model.management.CreateUserResponse;
import com.adyen.model.management.ListMerchantUsersResponse;
import com.adyen.model.management.UpdateMerchantUserRequest;
import com.adyen.model.management.User;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class UsersMerchantLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public UsersMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public UsersMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public CreateUserResponse createNewUser(String merchantId, CreateMerchantUserRequest createMerchantUserRequest) throws ApiException, IOException {
        return this.createNewUser(merchantId, createMerchantUserRequest, null);
    }

    public CreateUserResponse createNewUser(String merchantId, CreateMerchantUserRequest createMerchantUserRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = createMerchantUserRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/users", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return CreateUserResponse.fromJson(jsonResult);
    }

    public User getUserDetails(String merchantId, String userId) throws ApiException, IOException {
        return this.getUserDetails(merchantId, userId, null);
    }

    public User getUserDetails(String merchantId, String userId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (userId == null) {
            throw new IllegalArgumentException("Please provide the userId path parameter");
        }
        pathParams.put("userId", userId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/users/{userId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return User.fromJson(jsonResult);
    }

    public ListMerchantUsersResponse listUsers(String merchantId) throws ApiException, IOException {
        return this.listUsers(merchantId, null, null, null, null);
    }

    public ListMerchantUsersResponse listUsers(String merchantId, Integer pageNumber, Integer pageSize, String username, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (username != null) {
            queryParams.put("username", username);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/users", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantUsersResponse.fromJson(jsonResult);
    }

    public User updateUser(String merchantId, String userId, UpdateMerchantUserRequest updateMerchantUserRequest) throws ApiException, IOException {
        return this.updateUser(merchantId, userId, updateMerchantUserRequest, null);
    }

    public User updateUser(String merchantId, String userId, UpdateMerchantUserRequest updateMerchantUserRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (userId == null) {
            throw new IllegalArgumentException("Please provide the userId path parameter");
        }
        pathParams.put("userId", userId);
        String requestBody = updateMerchantUserRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/users/{userId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return User.fromJson(jsonResult);
    }
}

