/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.CheckoutOrderResponse;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ResponsePaymentMethod;
import com.adyen.model.checkout.ThreeDS2ResponseData;
import com.adyen.model.checkout.ThreeDS2Result;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "amount", "donationToken", "fraudResult", "merchantReference", "order", "paymentMethod", "pspReference", "refusalReason", "refusalReasonCode", "resultCode", "shopperLocale", "threeDS2ResponseData", "threeDS2Result", "threeDSPaymentData"})
public class PaymentDetailsResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DONATION_TOKEN = "donationToken";
    private String donationToken;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_ORDER = "order";
    private CheckoutOrderResponse order;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private ResponsePaymentMethod paymentMethod;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_REFUSAL_REASON_CODE = "refusalReasonCode";
    private String refusalReasonCode;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA = "threeDS2ResponseData";
    private ThreeDS2ResponseData threeDS2ResponseData;
    public static final String JSON_PROPERTY_THREE_D_S2_RESULT = "threeDS2Result";
    private ThreeDS2Result threeDS2Result;
    public static final String JSON_PROPERTY_THREE_D_S_PAYMENT_DATA = "threeDSPaymentData";
    private String threeDSPaymentData;

    public PaymentDetailsResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentDetailsResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentDetailsResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentDetailsResponse donationToken(String donationToken) {
        this.donationToken = donationToken;
        return this;
    }

    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationToken() {
        return this.donationToken;
    }

    @JsonProperty(value="donationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationToken(String donationToken) {
        this.donationToken = donationToken;
    }

    public PaymentDetailsResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PaymentDetailsResponse merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public PaymentDetailsResponse order(CheckoutOrderResponse order) {
        this.order = order;
        return this;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutOrderResponse getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(CheckoutOrderResponse order) {
        this.order = order;
    }

    public PaymentDetailsResponse paymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponsePaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentDetailsResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentDetailsResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentDetailsResponse refusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        return this;
    }

    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
    }

    public PaymentDetailsResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public PaymentDetailsResponse shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentDetailsResponse threeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
        return this;
    }

    @JsonProperty(value="threeDS2ResponseData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2ResponseData getThreeDS2ResponseData() {
        return this.threeDS2ResponseData;
    }

    @JsonProperty(value="threeDS2ResponseData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
    }

    public PaymentDetailsResponse threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        return this;
    }

    @JsonProperty(value="threeDS2Result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    @JsonProperty(value="threeDS2Result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
    }

    public PaymentDetailsResponse threeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
        return this;
    }

    @JsonProperty(value="threeDSPaymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSPaymentData() {
        return this.threeDSPaymentData;
    }

    @JsonProperty(value="threeDSPaymentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentDetailsResponse paymentDetailsResponse = (PaymentDetailsResponse)o;
        return Objects.equals(this.additionalData, paymentDetailsResponse.additionalData) && Objects.equals(this.amount, paymentDetailsResponse.amount) && Objects.equals(this.donationToken, paymentDetailsResponse.donationToken) && Objects.equals(this.fraudResult, paymentDetailsResponse.fraudResult) && Objects.equals(this.merchantReference, paymentDetailsResponse.merchantReference) && Objects.equals(this.order, paymentDetailsResponse.order) && Objects.equals(this.paymentMethod, paymentDetailsResponse.paymentMethod) && Objects.equals(this.pspReference, paymentDetailsResponse.pspReference) && Objects.equals(this.refusalReason, paymentDetailsResponse.refusalReason) && Objects.equals(this.refusalReasonCode, paymentDetailsResponse.refusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)paymentDetailsResponse.resultCode) && Objects.equals(this.shopperLocale, paymentDetailsResponse.shopperLocale) && Objects.equals(this.threeDS2ResponseData, paymentDetailsResponse.threeDS2ResponseData) && Objects.equals(this.threeDS2Result, paymentDetailsResponse.threeDS2Result) && Objects.equals(this.threeDSPaymentData, paymentDetailsResponse.threeDSPaymentData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.amount, this.donationToken, this.fraudResult, this.merchantReference, this.order, this.paymentMethod, this.pspReference, this.refusalReason, this.refusalReasonCode, this.resultCode, this.shopperLocale, this.threeDS2ResponseData, this.threeDS2Result, this.threeDSPaymentData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentDetailsResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    donationToken: ").append(this.toIndentedString(this.donationToken)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(this.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    threeDS2ResponseData: ").append(this.toIndentedString(this.threeDS2ResponseData)).append("\n");
        sb.append("    threeDS2Result: ").append(this.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    threeDSPaymentData: ").append(this.toIndentedString(this.threeDSPaymentData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentDetailsResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentDetailsResponse)JSON.getMapper().readValue(jsonString, PaymentDetailsResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED(String.valueOf("AuthenticationFinished")),
        AUTHENTICATIONNOTREQUIRED(String.valueOf("AuthenticationNotRequired")),
        AUTHORISED(String.valueOf("Authorised")),
        CANCELLED(String.valueOf("Cancelled")),
        CHALLENGESHOPPER(String.valueOf("ChallengeShopper")),
        ERROR(String.valueOf("Error")),
        IDENTIFYSHOPPER(String.valueOf("IdentifyShopper")),
        PARTIALLYAUTHORISED(String.valueOf("PartiallyAuthorised")),
        PENDING(String.valueOf("Pending")),
        PRESENTTOSHOPPER(String.valueOf("PresentToShopper")),
        RECEIVED(String.valueOf("Received")),
        REDIRECTSHOPPER(String.valueOf("RedirectShopper")),
        REFUSED(String.valueOf("Refused")),
        SUCCESS(String.valueOf("Success"));

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

