/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayhop;

import com.adyen.model.marketpayhop.CollectInformation;
import com.adyen.model.marketpayhop.JSON;
import com.adyen.model.marketpayhop.ShowPages;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "collectInformation", "editMode", "mobileOAuthCallbackUrl", "platformName", "returnUrl", "shopperLocale", "showPages"})
public class GetOnboardingUrlRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_COLLECT_INFORMATION = "collectInformation";
    private CollectInformation collectInformation;
    public static final String JSON_PROPERTY_EDIT_MODE = "editMode";
    private Boolean editMode;
    public static final String JSON_PROPERTY_MOBILE_O_AUTH_CALLBACK_URL = "mobileOAuthCallbackUrl";
    private String mobileOAuthCallbackUrl;
    public static final String JSON_PROPERTY_PLATFORM_NAME = "platformName";
    private String platformName;
    public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
    private String returnUrl;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOW_PAGES = "showPages";
    private ShowPages showPages;

    public GetOnboardingUrlRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The account holder code you provided when you created the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public GetOnboardingUrlRequest collectInformation(CollectInformation collectInformation) {
        this.collectInformation = collectInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="collectInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CollectInformation getCollectInformation() {
        return this.collectInformation;
    }

    @JsonProperty(value="collectInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCollectInformation(CollectInformation collectInformation) {
        this.collectInformation = collectInformation;
    }

    public GetOnboardingUrlRequest editMode(Boolean editMode) {
        this.editMode = editMode;
        return this;
    }

    @ApiModelProperty(value="Indicates if editing checks is allowed even if all the checks have passed.")
    @JsonProperty(value="editMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEditMode() {
        return this.editMode;
    }

    @JsonProperty(value="editMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEditMode(Boolean editMode) {
        this.editMode = editMode;
    }

    public GetOnboardingUrlRequest mobileOAuthCallbackUrl(String mobileOAuthCallbackUrl) {
        this.mobileOAuthCallbackUrl = mobileOAuthCallbackUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to which the account holder is redirected after completing an OAuth authentication with a bank through Trustly/PayMyBank.")
    @JsonProperty(value="mobileOAuthCallbackUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMobileOAuthCallbackUrl() {
        return this.mobileOAuthCallbackUrl;
    }

    @JsonProperty(value="mobileOAuthCallbackUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMobileOAuthCallbackUrl(String mobileOAuthCallbackUrl) {
        this.mobileOAuthCallbackUrl = mobileOAuthCallbackUrl;
    }

    public GetOnboardingUrlRequest platformName(String platformName) {
        this.platformName = platformName;
        return this;
    }

    @ApiModelProperty(value="The platform name which will show up in the welcome page.")
    @JsonProperty(value="platformName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlatformName() {
        return this.platformName;
    }

    @JsonProperty(value="platformName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public GetOnboardingUrlRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @ApiModelProperty(value="The URL where the account holder will be redirected back to after they complete the onboarding, or if their session times out. Maximum length of 500 characters. If you don't provide this, the account holder will be redirected back to the default return URL configured in your platform account.")
    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public GetOnboardingUrlRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The language to be used in the page, specified by a combination of a language and country code. For example, **pt-BR**.   If not specified in the request or if the language is not supported, the page uses the browser language. If the browser language is not supported, the page uses **en-US** by default.  For a list of supported languages, refer to [Change the page language](https://docs.adyen.com/marketplaces-and-platforms/classic/hosted-onboarding-page/customize-experience#change-page-language).")
    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public GetOnboardingUrlRequest showPages(ShowPages showPages) {
        this.showPages = showPages;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="showPages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShowPages getShowPages() {
        return this.showPages;
    }

    @JsonProperty(value="showPages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowPages(ShowPages showPages) {
        this.showPages = showPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOnboardingUrlRequest getOnboardingUrlRequest = (GetOnboardingUrlRequest)o;
        return Objects.equals(this.accountHolderCode, getOnboardingUrlRequest.accountHolderCode) && Objects.equals(this.collectInformation, getOnboardingUrlRequest.collectInformation) && Objects.equals(this.editMode, getOnboardingUrlRequest.editMode) && Objects.equals(this.mobileOAuthCallbackUrl, getOnboardingUrlRequest.mobileOAuthCallbackUrl) && Objects.equals(this.platformName, getOnboardingUrlRequest.platformName) && Objects.equals(this.returnUrl, getOnboardingUrlRequest.returnUrl) && Objects.equals(this.shopperLocale, getOnboardingUrlRequest.shopperLocale) && Objects.equals(this.showPages, getOnboardingUrlRequest.showPages);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.collectInformation, this.editMode, this.mobileOAuthCallbackUrl, this.platformName, this.returnUrl, this.shopperLocale, this.showPages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetOnboardingUrlRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    collectInformation: ").append(this.toIndentedString(this.collectInformation)).append("\n");
        sb.append("    editMode: ").append(this.toIndentedString(this.editMode)).append("\n");
        sb.append("    mobileOAuthCallbackUrl: ").append(this.toIndentedString(this.mobileOAuthCallbackUrl)).append("\n");
        sb.append("    platformName: ").append(this.toIndentedString(this.platformName)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    showPages: ").append(this.toIndentedString(this.showPages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetOnboardingUrlRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetOnboardingUrlRequest)JSON.getMapper().readValue(jsonString, GetOnboardingUrlRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

