/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"reasons", "result", "type"})
public class ValidationFacts {
    public static final String JSON_PROPERTY_REASONS = "reasons";
    private List<String> reasons;
    public static final String JSON_PROPERTY_RESULT = "result";
    private ResultEnum result;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public ValidationFacts reasons(List<String> reasons) {
        this.reasons = reasons;
        return this;
    }

    public ValidationFacts addReasonsItem(String reasonsItem) {
        if (this.reasons == null) {
            this.reasons = new ArrayList<String>();
        }
        this.reasons.add(reasonsItem);
        return this;
    }

    @JsonProperty(value="reasons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getReasons() {
        return this.reasons;
    }

    @JsonProperty(value="reasons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasons(List<String> reasons) {
        this.reasons = reasons;
    }

    public ValidationFacts result(ResultEnum result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultEnum getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResult(ResultEnum result) {
        this.result = result;
    }

    public ValidationFacts type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationFacts validationFacts = (ValidationFacts)o;
        return Objects.equals(this.reasons, validationFacts.reasons) && Objects.equals((Object)this.result, (Object)validationFacts.result) && Objects.equals(this.type, validationFacts.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reasons, this.result, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidationFacts {\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ValidationFacts fromJson(String jsonString) throws JsonProcessingException {
        return (ValidationFacts)JSON.getMapper().readValue(jsonString, ValidationFacts.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultEnum {
        INVALID(String.valueOf("invalid")),
        NOTAPPLICABLE(String.valueOf("notApplicable")),
        NOTVALIDATED(String.valueOf("notValidated")),
        VALID(String.valueOf("valid"));

        private String value;

        private ResultEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultEnum fromValue(String value) {
            for (ResultEnum b : ResultEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

