/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.PaginationLinks;
import com.adyen.model.management.PaymentMethod;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "data", "itemsTotal", "pagesTotal", "typesWithErrors"})
public class PaymentMethodResponse {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private PaginationLinks links;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<PaymentMethod> data;
    public static final String JSON_PROPERTY_ITEMS_TOTAL = "itemsTotal";
    private Integer itemsTotal;
    public static final String JSON_PROPERTY_PAGES_TOTAL = "pagesTotal";
    private Integer pagesTotal;
    public static final String JSON_PROPERTY_TYPES_WITH_ERRORS = "typesWithErrors";
    private List<TypesWithErrorsEnum> typesWithErrors;

    public PaymentMethodResponse links(PaginationLinks links) {
        this.links = links;
        return this;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaginationLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(PaginationLinks links) {
        this.links = links;
    }

    public PaymentMethodResponse data(List<PaymentMethod> data) {
        this.data = data;
        return this;
    }

    public PaymentMethodResponse addDataItem(PaymentMethod dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<PaymentMethod>();
        }
        this.data.add(dataItem);
        return this;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PaymentMethod> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(List<PaymentMethod> data) {
        this.data = data;
    }

    public PaymentMethodResponse itemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
        return this;
    }

    @JsonProperty(value="itemsTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    @JsonProperty(value="itemsTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
    }

    public PaymentMethodResponse pagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
        return this;
    }

    @JsonProperty(value="pagesTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    @JsonProperty(value="pagesTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
    }

    public PaymentMethodResponse typesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
        this.typesWithErrors = typesWithErrors;
        return this;
    }

    public PaymentMethodResponse addTypesWithErrorsItem(TypesWithErrorsEnum typesWithErrorsItem) {
        if (this.typesWithErrors == null) {
            this.typesWithErrors = new ArrayList<TypesWithErrorsEnum>();
        }
        this.typesWithErrors.add(typesWithErrorsItem);
        return this;
    }

    @JsonProperty(value="typesWithErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TypesWithErrorsEnum> getTypesWithErrors() {
        return this.typesWithErrors;
    }

    @JsonProperty(value="typesWithErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
        this.typesWithErrors = typesWithErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodResponse paymentMethodResponse = (PaymentMethodResponse)o;
        return Objects.equals(this.links, paymentMethodResponse.links) && Objects.equals(this.data, paymentMethodResponse.data) && Objects.equals(this.itemsTotal, paymentMethodResponse.itemsTotal) && Objects.equals(this.pagesTotal, paymentMethodResponse.pagesTotal) && Objects.equals(this.typesWithErrors, paymentMethodResponse.typesWithErrors);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.data, this.itemsTotal, this.pagesTotal, this.typesWithErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    pagesTotal: ").append(this.toIndentedString(this.pagesTotal)).append("\n");
        sb.append("    typesWithErrors: ").append(this.toIndentedString(this.typesWithErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethodResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethodResponse)JSON.getMapper().readValue(jsonString, PaymentMethodResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypesWithErrorsEnum {
        ACCEL(String.valueOf("accel")),
        ACH(String.valueOf("ach")),
        AFFIRM(String.valueOf("affirm")),
        AFTERPAYTOUCH(String.valueOf("afterpaytouch")),
        ALELO(String.valueOf("alelo")),
        ALIPAY(String.valueOf("alipay")),
        ALIPAY_HK(String.valueOf("alipay_hk")),
        ALIPAY_WAP(String.valueOf("alipay_wap")),
        AMEX(String.valueOf("amex")),
        APPLEPAY(String.valueOf("applepay")),
        BANESE_CARD(String.valueOf("banese_card")),
        BANESE_CARD_CREDIT(String.valueOf("banese_card_credit")),
        BANESE_CARD_DEBIT(String.valueOf("banese_card_debit")),
        BANESE_CARD_PREPAID(String.valueOf("banese_card_prepaid")),
        BCMC(String.valueOf("bcmc")),
        BLIK(String.valueOf("blik")),
        CARTEBANCAIRE(String.valueOf("cartebancaire")),
        CLEARPAY(String.valueOf("clearpay")),
        CLICKTOPAY(String.valueOf("clicktopay")),
        CREDTODOS(String.valueOf("credtodos")),
        CREDTODOS_PRIVATE_CREDIT(String.valueOf("credtodos_private_credit")),
        CREDTODOS_PRIVATE_DEBIT(String.valueOf("credtodos_private_debit")),
        CUP(String.valueOf("cup")),
        DINERS(String.valueOf("diners")),
        DIRECTDEBIT_GB(String.valueOf("directdebit_GB")),
        DISCOVER(String.valueOf("discover")),
        EBANKING_FI(String.valueOf("ebanking_FI")),
        EFT_DIRECTDEBIT_CA(String.valueOf("eft_directdebit_CA")),
        EFTPOS_AUSTRALIA(String.valueOf("eftpos_australia")),
        ELO(String.valueOf("elo")),
        ELOCREDIT(String.valueOf("elocredit")),
        ELODEBIT(String.valueOf("elodebit")),
        GIROCARD(String.valueOf("girocard")),
        GOOGLEPAY(String.valueOf("googlepay")),
        HIPER(String.valueOf("hiper")),
        HIPERCARD(String.valueOf("hipercard")),
        IDEAL(String.valueOf("ideal")),
        INTERAC_CARD(String.valueOf("interac_card")),
        JCB(String.valueOf("jcb")),
        KLARNA(String.valueOf("klarna")),
        KLARNA_ACCOUNT(String.valueOf("klarna_account")),
        KLARNA_PAYNOW(String.valueOf("klarna_paynow")),
        MAESTRO(String.valueOf("maestro")),
        MBWAY(String.valueOf("mbway")),
        MC(String.valueOf("mc")),
        MCDEBIT(String.valueOf("mcdebit")),
        MEALVOUCHER_FR(String.valueOf("mealVoucher_FR")),
        MOBILEPAY(String.valueOf("mobilepay")),
        MULTIBANCO(String.valueOf("multibanco")),
        NYCE(String.valueOf("nyce")),
        ONLINEBANKING_PL(String.valueOf("onlineBanking_PL")),
        PAYBYBANK(String.valueOf("paybybank")),
        PAYME(String.valueOf("payme")),
        PAYME_POS(String.valueOf("payme_pos")),
        PAYNOW(String.valueOf("paynow")),
        PAYNOW_POS(String.valueOf("paynow_pos")),
        PAYPAL(String.valueOf("paypal")),
        PAYSHOP(String.valueOf("payshop")),
        PAYTO(String.valueOf("payto")),
        PULSE(String.valueOf("pulse")),
        SODEXO(String.valueOf("sodexo")),
        STAR(String.valueOf("star")),
        SWISH(String.valueOf("swish")),
        TICKET(String.valueOf("ticket")),
        TODO_GIFTCARD(String.valueOf("todo_giftcard")),
        TRUSTLY(String.valueOf("trustly")),
        TWINT(String.valueOf("twint")),
        TWINT_POS(String.valueOf("twint_pos")),
        UP_BRAZIL_CREDIT(String.valueOf("up_brazil_credit")),
        VALE_REFEICAO(String.valueOf("vale_refeicao")),
        VALE_REFEICAO_PREPAID(String.valueOf("vale_refeicao_prepaid")),
        VIPPS(String.valueOf("vipps")),
        VISA(String.valueOf("visa")),
        VISADEBIT(String.valueOf("visadebit")),
        VPAY(String.valueOf("vpay")),
        WECHATPAY(String.valueOf("wechatpay")),
        WECHATPAY_POS(String.valueOf("wechatpay_pos"));

        private String value;

        private TypesWithErrorsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypesWithErrorsEnum fromValue(String value) {
            for (TypesWithErrorsEnum b : TypesWithErrorsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

