/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "amount", "expiresAt", "fraudResult", "orderData", "pspReference", "reference", "refusalReason", "remainingAmount", "resultCode"})
public class CreateOrderResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private String expiresAt;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_ORDER_DATA = "orderData";
    private String orderData;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_REMAINING_AMOUNT = "remainingAmount";
    private Amount remainingAmount;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;

    public CreateOrderResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CreateOrderResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CreateOrderResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CreateOrderResponse expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CreateOrderResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public CreateOrderResponse orderData(String orderData) {
        this.orderData = orderData;
        return this;
    }

    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderData() {
        return this.orderData;
    }

    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderData(String orderData) {
        this.orderData = orderData;
    }

    public CreateOrderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public CreateOrderResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public CreateOrderResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public CreateOrderResponse remainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
        return this;
    }

    @JsonProperty(value="remainingAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getRemainingAmount() {
        return this.remainingAmount;
    }

    @JsonProperty(value="remainingAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public CreateOrderResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderResponse createOrderResponse = (CreateOrderResponse)o;
        return Objects.equals(this.additionalData, createOrderResponse.additionalData) && Objects.equals(this.amount, createOrderResponse.amount) && Objects.equals(this.expiresAt, createOrderResponse.expiresAt) && Objects.equals(this.fraudResult, createOrderResponse.fraudResult) && Objects.equals(this.orderData, createOrderResponse.orderData) && Objects.equals(this.pspReference, createOrderResponse.pspReference) && Objects.equals(this.reference, createOrderResponse.reference) && Objects.equals(this.refusalReason, createOrderResponse.refusalReason) && Objects.equals(this.remainingAmount, createOrderResponse.remainingAmount) && Objects.equals((Object)this.resultCode, (Object)createOrderResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.amount, this.expiresAt, this.fraudResult, this.orderData, this.pspReference, this.reference, this.refusalReason, this.remainingAmount, this.resultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    orderData: ").append(this.toIndentedString(this.orderData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    remainingAmount: ").append(this.toIndentedString(this.remainingAmount)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateOrderResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateOrderResponse)JSON.getMapper().readValue(jsonString, CreateOrderResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        SUCCESS(String.valueOf("Success"));

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

