/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.Logo;
import com.adyen.model.management.TerminalSettings;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalSettingsCompanyLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TerminalSettingsCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public TerminalSettingsCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public Logo getTerminalLogo(String companyId, String model) throws ApiException, IOException {
        return this.getTerminalLogo(companyId, model, null);
    }

    public Logo getTerminalLogo(String companyId, String model, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettings(String companyId) throws ApiException, IOException {
        return this.getTerminalSettings(companyId, null);
    }

    public TerminalSettings getTerminalSettings(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo updateTerminalLogo(String companyId, String model, Logo logo) throws ApiException, IOException {
        return this.updateTerminalLogo(companyId, model, logo, null);
    }

    public Logo updateTerminalLogo(String companyId, String model, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettings(String companyId, TerminalSettings terminalSettings) throws ApiException, IOException {
        return this.updateTerminalSettings(companyId, terminalSettings, null);
    }

    public TerminalSettings updateTerminalSettings(String companyId, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }
}

