/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Attachment;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.OwnerEntity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"attachment", "attachments", "creationDate", "description", "expiryDate", "fileName", "id", "issuerCountry", "issuerState", "modificationDate", "number", "owner", "type"})
public class Document {
    public static final String JSON_PROPERTY_ATTACHMENT = "attachment";
    private Attachment attachment;
    public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
    private List<Attachment> attachments = new ArrayList<Attachment>();
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
    @Deprecated
    private String expiryDate;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    @Deprecated
    private String issuerCountry;
    public static final String JSON_PROPERTY_ISSUER_STATE = "issuerState";
    @Deprecated
    private String issuerState;
    public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
    private OffsetDateTime modificationDate;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private OwnerEntity owner;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public Document() {
    }

    @JsonCreator
    public Document(@JsonProperty(value="creationDate") OffsetDateTime creationDate, @JsonProperty(value="id") String id, @JsonProperty(value="modificationDate") OffsetDateTime modificationDate) {
        this();
        this.creationDate = creationDate;
        this.id = id;
        this.modificationDate = modificationDate;
    }

    public Document attachment(Attachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @JsonProperty(value="attachment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Attachment getAttachment() {
        return this.attachment;
    }

    @JsonProperty(value="attachment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public Document attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Document addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public Document description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public Document expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Deprecated
    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryDate() {
        return this.expiryDate;
    }

    @Deprecated
    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Document fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Deprecated
    public Document issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Deprecated
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @Deprecated
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    @Deprecated
    public Document issuerState(String issuerState) {
        this.issuerState = issuerState;
        return this;
    }

    @Deprecated
    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerState() {
        return this.issuerState;
    }

    @Deprecated
    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerState(String issuerState) {
        this.issuerState = issuerState;
    }

    @JsonProperty(value="modificationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModificationDate() {
        return this.modificationDate;
    }

    public Document number(String number) {
        this.number = number;
        return this;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    public Document owner(OwnerEntity owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OwnerEntity getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(OwnerEntity owner) {
        this.owner = owner;
    }

    public Document type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.attachment, document.attachment) && Objects.equals(this.attachments, document.attachments) && Objects.equals(this.creationDate, document.creationDate) && Objects.equals(this.description, document.description) && Objects.equals(this.expiryDate, document.expiryDate) && Objects.equals(this.fileName, document.fileName) && Objects.equals(this.id, document.id) && Objects.equals(this.issuerCountry, document.issuerCountry) && Objects.equals(this.issuerState, document.issuerState) && Objects.equals(this.modificationDate, document.modificationDate) && Objects.equals(this.number, document.number) && Objects.equals(this.owner, document.owner) && Objects.equals((Object)this.type, (Object)document.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachment, this.attachments, this.creationDate, this.description, this.expiryDate, this.fileName, this.id, this.issuerCountry, this.issuerState, this.modificationDate, this.number, this.owner, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    issuerState: ").append(this.toIndentedString(this.issuerState)).append("\n");
        sb.append("    modificationDate: ").append(this.toIndentedString(this.modificationDate)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Document fromJson(String jsonString) throws JsonProcessingException {
        return (Document)JSON.getMapper().readValue(jsonString, Document.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKSTATEMENT(String.valueOf("bankStatement")),
        DRIVERSLICENSE(String.valueOf("driversLicense")),
        IDENTITYCARD(String.valueOf("identityCard")),
        NATIONALIDNUMBER(String.valueOf("nationalIdNumber")),
        PASSPORT(String.valueOf("passport")),
        PROOFOFADDRESS(String.valueOf("proofOfAddress")),
        PROOFOFNATIONALIDNUMBER(String.valueOf("proofOfNationalIdNumber")),
        PROOFOFRESIDENCY(String.valueOf("proofOfResidency")),
        REGISTRATIONDOCUMENT(String.valueOf("registrationDocument")),
        VATDOCUMENT(String.valueOf("vatDocument")),
        PROOFOFORGANIZATIONTAXINFO(String.valueOf("proofOfOrganizationTaxInfo")),
        PROOFOFINDIVIDUALTAXID(String.valueOf("proofOfIndividualTaxId")),
        PROOFOFOWNERSHIP(String.valueOf("proofOfOwnership")),
        PROOFOFSIGNATORY(String.valueOf("proofOfSignatory")),
        LIVESELFIE(String.valueOf("liveSelfie")),
        PROOFOFINDUSTRY(String.valueOf("proofOfIndustry")),
        CONSTITUTIONALDOCUMENT(String.valueOf("constitutionalDocument")),
        PROOFOFFUNDINGORWEALTHSOURCE(String.valueOf("proofOfFundingOrWealthSource")),
        PROOFOFRELATIONSHIP(String.valueOf("proofOfRelationship"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

