/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"ids", "type"})
public class AssociationInitiateRequest {
    public static final String JSON_PROPERTY_IDS = "ids";
    private List<String> ids = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AssociationInitiateRequest ids(List<String> ids) {
        this.ids = ids;
        return this;
    }

    public AssociationInitiateRequest addIdsItem(String idsItem) {
        this.ids.add(idsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of unique identifiers of the resources that you are associating with the SCA device.  Maximum: 5 strings.")
    @JsonProperty(value="ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIds() {
        return this.ids;
    }

    @JsonProperty(value="ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public AssociationInitiateRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of resource that you are associating with the SCA device.  Possible value: **PaymentInstrument**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationInitiateRequest associationInitiateRequest = (AssociationInitiateRequest)o;
        return Objects.equals(this.ids, associationInitiateRequest.ids) && Objects.equals((Object)this.type, (Object)associationInitiateRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ids, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssociationInitiateRequest {\n");
        sb.append("    ids: ").append(this.toIndentedString(this.ids)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AssociationInitiateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (AssociationInitiateRequest)JSON.getMapper().readValue(jsonString, AssociationInitiateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PAYMENTINSTRUMENT("PaymentInstrument");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

