/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ScheduleTerminalActionsRequestActionDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"actionDetails", "scheduledAt", "storeId", "terminalIds"})
public class ScheduleTerminalActionsRequest {
    public static final String JSON_PROPERTY_ACTION_DETAILS = "actionDetails";
    private ScheduleTerminalActionsRequestActionDetails actionDetails;
    public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
    private String scheduledAt;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;
    public static final String JSON_PROPERTY_TERMINAL_IDS = "terminalIds";
    private List<String> terminalIds = null;

    public ScheduleTerminalActionsRequest actionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="actionDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScheduleTerminalActionsRequestActionDetails getActionDetails() {
        return this.actionDetails;
    }

    @JsonProperty(value="actionDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
    }

    public ScheduleTerminalActionsRequest scheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action should happen.  Format: [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339), but without the **Z** before the time offset. For example, **2021-11-15T12:16:21+0100**  The action is sent with the first [maintenance call](https://docs.adyen.com/point-of-sale/automating-terminal-management/terminal-actions-api#when-actions-take-effect) after the specified date and time in the time zone of the terminal.  An empty value causes the action to be sent as soon as possible: at the next maintenance call.")
    @JsonProperty(value="scheduledAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScheduledAt() {
        return this.scheduledAt;
    }

    @JsonProperty(value="scheduledAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public ScheduleTerminalActionsRequest storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the [store](https://docs.adyen.com/api-explorer/#/ManagementService/latest/get/stores). If present, all terminals in the `terminalIds` list must be assigned to this store.")
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public ScheduleTerminalActionsRequest terminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
        return this;
    }

    public ScheduleTerminalActionsRequest addTerminalIdsItem(String terminalIdsItem) {
        if (this.terminalIds == null) {
            this.terminalIds = new ArrayList<String>();
        }
        this.terminalIds.add(terminalIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of unique IDs of the terminals to apply the action to. You can extract the IDs from the [GET `/terminals`](https://docs.adyen.com/api-explorer/#/ManagementService/latest/get/terminals) response. Maximum length: 100 IDs.")
    @JsonProperty(value="terminalIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTerminalIds() {
        return this.terminalIds;
    }

    @JsonProperty(value="terminalIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTerminalActionsRequest scheduleTerminalActionsRequest = (ScheduleTerminalActionsRequest)o;
        return Objects.equals(this.actionDetails, scheduleTerminalActionsRequest.actionDetails) && Objects.equals(this.scheduledAt, scheduleTerminalActionsRequest.scheduledAt) && Objects.equals(this.storeId, scheduleTerminalActionsRequest.storeId) && Objects.equals(this.terminalIds, scheduleTerminalActionsRequest.terminalIds);
    }

    public int hashCode() {
        return Objects.hash(this.actionDetails, this.scheduledAt, this.storeId, this.terminalIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleTerminalActionsRequest {\n");
        sb.append("    actionDetails: ").append(this.toIndentedString(this.actionDetails)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    terminalIds: ").append(this.toIndentedString(this.terminalIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ScheduleTerminalActionsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (ScheduleTerminalActionsRequest)JSON.getMapper().readValue(jsonString, ScheduleTerminalActionsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

