/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantName", "payToPurpose"})
public class PayToInfo {
    public static final String JSON_PROPERTY_MERCHANT_NAME = "merchantName";
    private String merchantName;
    public static final String JSON_PROPERTY_PAY_TO_PURPOSE = "payToPurpose";
    private String payToPurpose;

    public PayToInfo merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(required=true, value="Merchant name displayed to the shopper in the Agreements")
    @JsonProperty(value="merchantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantName() {
        return this.merchantName;
    }

    @JsonProperty(value="merchantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public PayToInfo payToPurpose(String payToPurpose) {
        this.payToPurpose = payToPurpose;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the purpose of the Agreements created, it relates to the business type **Allowed values**: mortgage, utility, loan, gambling, retail, salary, personal, government, pension, tax, other")
    @JsonProperty(value="payToPurpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayToPurpose() {
        return this.payToPurpose;
    }

    @JsonProperty(value="payToPurpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayToPurpose(String payToPurpose) {
        this.payToPurpose = payToPurpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayToInfo payToInfo = (PayToInfo)o;
        return Objects.equals(this.merchantName, payToInfo.merchantName) && Objects.equals(this.payToPurpose, payToInfo.payToPurpose);
    }

    public int hashCode() {
        return Objects.hash(this.merchantName, this.payToPurpose);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayToInfo {\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    payToPurpose: ").append(this.toIndentedString(this.payToPurpose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayToInfo fromJson(String jsonString) throws JsonProcessingException {
        return (PayToInfo)JSON.getMapper().readValue(jsonString, PayToInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

