/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acquirerAccountCode", "acquirerCode", "acquirerReference", "alias", "aliasType", "authCode", "authorisationMid", "authorisedAmountCurrency", "authorisedAmountValue", "avsResult", "avsResultRaw", "bic", "coBrandedWith", "cvcResult", "cvcResultRaw", "dsTransID", "eci", "expiryDate", "extraCostsCurrency", "extraCostsValue", "fraudCheck-[itemNr]-[FraudCheckname]", "fraudManualReview", "fraudResultType", "fundingSource", "fundsAvailability", "inferredRefusalReason", "isCardCommercial", "issuerCountry", "liabilityShift", "mcBankNetReferenceNumber", "merchantAdviceCode", "merchantReference", "networkTxReference", "ownerName", "paymentAccountReference", "paymentMethod", "paymentMethodVariant", "payoutEligible", "realtimeAccountUpdaterStatus", "receiptFreeText", "recurring.contractTypes", "recurring.firstPspReference", "recurring.recurringDetailReference", "recurring.shopperReference", "recurringProcessingModel", "referred", "refusalReasonRaw", "requestAmount", "requestCurrencyCode", "shopperInteraction", "shopperReference", "terminalId", "threeDAuthenticated", "threeDAuthenticatedResponse", "threeDOffered", "threeDOfferedResponse", "threeDSVersion", "tokenization.shopperReference", "tokenization.store.operationType", "tokenization.storedPaymentMethodId", "visaTransactionId", "xid"})
public class ResponseAdditionalDataCommon {
    public static final String JSON_PROPERTY_ACQUIRER_ACCOUNT_CODE = "acquirerAccountCode";
    private String acquirerAccountCode;
    public static final String JSON_PROPERTY_ACQUIRER_CODE = "acquirerCode";
    private String acquirerCode;
    public static final String JSON_PROPERTY_ACQUIRER_REFERENCE = "acquirerReference";
    private String acquirerReference;
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;
    public static final String JSON_PROPERTY_ALIAS_TYPE = "aliasType";
    private String aliasType;
    public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
    private String authCode;
    public static final String JSON_PROPERTY_AUTHORISATION_MID = "authorisationMid";
    private String authorisationMid;
    public static final String JSON_PROPERTY_AUTHORISED_AMOUNT_CURRENCY = "authorisedAmountCurrency";
    private String authorisedAmountCurrency;
    public static final String JSON_PROPERTY_AUTHORISED_AMOUNT_VALUE = "authorisedAmountValue";
    private String authorisedAmountValue;
    public static final String JSON_PROPERTY_AVS_RESULT = "avsResult";
    private String avsResult;
    public static final String JSON_PROPERTY_AVS_RESULT_RAW = "avsResultRaw";
    private String avsResultRaw;
    public static final String JSON_PROPERTY_BIC = "bic";
    private String bic;
    public static final String JSON_PROPERTY_CO_BRANDED_WITH = "coBrandedWith";
    private String coBrandedWith;
    public static final String JSON_PROPERTY_CVC_RESULT = "cvcResult";
    private String cvcResult;
    public static final String JSON_PROPERTY_CVC_RESULT_RAW = "cvcResultRaw";
    private String cvcResultRaw;
    public static final String JSON_PROPERTY_DS_TRANS_I_D = "dsTransID";
    private String dsTransID;
    public static final String JSON_PROPERTY_ECI = "eci";
    private String eci;
    public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
    private String expiryDate;
    public static final String JSON_PROPERTY_EXTRA_COSTS_CURRENCY = "extraCostsCurrency";
    private String extraCostsCurrency;
    public static final String JSON_PROPERTY_EXTRA_COSTS_VALUE = "extraCostsValue";
    private String extraCostsValue;
    public static final String JSON_PROPERTY_FRAUD_CHECK_ITEM_NR_FRAUD_CHECKNAME = "fraudCheck-[itemNr]-[FraudCheckname]";
    private String fraudCheckItemNrFraudCheckname;
    public static final String JSON_PROPERTY_FRAUD_MANUAL_REVIEW = "fraudManualReview";
    private String fraudManualReview;
    public static final String JSON_PROPERTY_FRAUD_RESULT_TYPE = "fraudResultType";
    private FraudResultTypeEnum fraudResultType;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private String fundingSource;
    public static final String JSON_PROPERTY_FUNDS_AVAILABILITY = "fundsAvailability";
    private String fundsAvailability;
    public static final String JSON_PROPERTY_INFERRED_REFUSAL_REASON = "inferredRefusalReason";
    private String inferredRefusalReason;
    public static final String JSON_PROPERTY_IS_CARD_COMMERCIAL = "isCardCommercial";
    private String isCardCommercial;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    private String issuerCountry;
    public static final String JSON_PROPERTY_LIABILITY_SHIFT = "liabilityShift";
    private String liabilityShift;
    public static final String JSON_PROPERTY_MC_BANK_NET_REFERENCE_NUMBER = "mcBankNetReferenceNumber";
    private String mcBankNetReferenceNumber;
    public static final String JSON_PROPERTY_MERCHANT_ADVICE_CODE = "merchantAdviceCode";
    private String merchantAdviceCode;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_NETWORK_TX_REFERENCE = "networkTxReference";
    private String networkTxReference;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_PAYMENT_ACCOUNT_REFERENCE = "paymentAccountReference";
    private String paymentAccountReference;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private String paymentMethod;
    public static final String JSON_PROPERTY_PAYMENT_METHOD_VARIANT = "paymentMethodVariant";
    private String paymentMethodVariant;
    public static final String JSON_PROPERTY_PAYOUT_ELIGIBLE = "payoutEligible";
    private String payoutEligible;
    public static final String JSON_PROPERTY_REALTIME_ACCOUNT_UPDATER_STATUS = "realtimeAccountUpdaterStatus";
    private String realtimeAccountUpdaterStatus;
    public static final String JSON_PROPERTY_RECEIPT_FREE_TEXT = "receiptFreeText";
    private String receiptFreeText;
    public static final String JSON_PROPERTY_RECURRING_CONTRACT_TYPES = "recurring.contractTypes";
    private String recurringContractTypes;
    public static final String JSON_PROPERTY_RECURRING_FIRST_PSP_REFERENCE = "recurring.firstPspReference";
    private String recurringFirstPspReference;
    public static final String JSON_PROPERTY_RECURRING_RECURRING_DETAIL_REFERENCE = "recurring.recurringDetailReference";
    @Deprecated
    private String recurringRecurringDetailReference;
    public static final String JSON_PROPERTY_RECURRING_SHOPPER_REFERENCE = "recurring.shopperReference";
    @Deprecated
    private String recurringShopperReference;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_REFERRED = "referred";
    private String referred;
    public static final String JSON_PROPERTY_REFUSAL_REASON_RAW = "refusalReasonRaw";
    private String refusalReasonRaw;
    public static final String JSON_PROPERTY_REQUEST_AMOUNT = "requestAmount";
    private String requestAmount;
    public static final String JSON_PROPERTY_REQUEST_CURRENCY_CODE = "requestCurrencyCode";
    private String requestCurrencyCode;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private String shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_TERMINAL_ID = "terminalId";
    private String terminalId;
    public static final String JSON_PROPERTY_THREE_D_AUTHENTICATED = "threeDAuthenticated";
    private String threeDAuthenticated;
    public static final String JSON_PROPERTY_THREE_D_AUTHENTICATED_RESPONSE = "threeDAuthenticatedResponse";
    private String threeDAuthenticatedResponse;
    public static final String JSON_PROPERTY_THREE_D_OFFERED = "threeDOffered";
    private String threeDOffered;
    public static final String JSON_PROPERTY_THREE_D_OFFERED_RESPONSE = "threeDOfferedResponse";
    private String threeDOfferedResponse;
    public static final String JSON_PROPERTY_THREE_D_S_VERSION = "threeDSVersion";
    private String threeDSVersion;
    public static final String JSON_PROPERTY_TOKENIZATION_SHOPPER_REFERENCE = "tokenization.shopperReference";
    private String tokenizationShopperReference;
    public static final String JSON_PROPERTY_TOKENIZATION_STORE_OPERATION_TYPE = "tokenization.store.operationType";
    private TokenizationStoreOperationTypeEnum tokenizationStoreOperationType;
    public static final String JSON_PROPERTY_TOKENIZATION_STORED_PAYMENT_METHOD_ID = "tokenization.storedPaymentMethodId";
    private String tokenizationStoredPaymentMethodId;
    public static final String JSON_PROPERTY_VISA_TRANSACTION_ID = "visaTransactionId";
    private String visaTransactionId;
    public static final String JSON_PROPERTY_XID = "xid";
    private String xid;

    public ResponseAdditionalDataCommon acquirerAccountCode(String acquirerAccountCode) {
        this.acquirerAccountCode = acquirerAccountCode;
        return this;
    }

    @ApiModelProperty(value="The name of the Adyen acquirer account.  Example: PayPalSandbox_TestAcquirer  > Only relevant for PayPal transactions.")
    @JsonProperty(value="acquirerAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerAccountCode() {
        return this.acquirerAccountCode;
    }

    @JsonProperty(value="acquirerAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerAccountCode(String acquirerAccountCode) {
        this.acquirerAccountCode = acquirerAccountCode;
    }

    public ResponseAdditionalDataCommon acquirerCode(String acquirerCode) {
        this.acquirerCode = acquirerCode;
        return this;
    }

    @ApiModelProperty(value="The name of the acquirer processing the payment request.  Example: TestPmmAcquirer")
    @JsonProperty(value="acquirerCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerCode() {
        return this.acquirerCode;
    }

    @JsonProperty(value="acquirerCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerCode(String acquirerCode) {
        this.acquirerCode = acquirerCode;
    }

    public ResponseAdditionalDataCommon acquirerReference(String acquirerReference) {
        this.acquirerReference = acquirerReference;
        return this;
    }

    @ApiModelProperty(value="The reference number that can be used for reconciliation in case a non-Adyen acquirer is used for settlement.  Example: 7C9N3FNBKT9")
    @JsonProperty(value="acquirerReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerReference() {
        return this.acquirerReference;
    }

    @JsonProperty(value="acquirerReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerReference(String acquirerReference) {
        this.acquirerReference = acquirerReference;
    }

    public ResponseAdditionalDataCommon alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(value="The Adyen alias of the card.  Example: H167852639363479")
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlias() {
        return this.alias;
    }

    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ResponseAdditionalDataCommon aliasType(String aliasType) {
        this.aliasType = aliasType;
        return this;
    }

    @ApiModelProperty(value="The type of the card alias.  Example: Default")
    @JsonProperty(value="aliasType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAliasType() {
        return this.aliasType;
    }

    @JsonProperty(value="aliasType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAliasType(String aliasType) {
        this.aliasType = aliasType;
    }

    public ResponseAdditionalDataCommon authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @ApiModelProperty(value="Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.  Example: 58747")
    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthCode() {
        return this.authCode;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public ResponseAdditionalDataCommon authorisationMid(String authorisationMid) {
        this.authorisationMid = authorisationMid;
        return this;
    }

    @ApiModelProperty(value="Merchant ID known by the acquirer.")
    @JsonProperty(value="authorisationMid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorisationMid() {
        return this.authorisationMid;
    }

    @JsonProperty(value="authorisationMid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorisationMid(String authorisationMid) {
        this.authorisationMid = authorisationMid;
    }

    public ResponseAdditionalDataCommon authorisedAmountCurrency(String authorisedAmountCurrency) {
        this.authorisedAmountCurrency = authorisedAmountCurrency;
        return this;
    }

    @ApiModelProperty(value="The currency of the authorised amount, as a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="authorisedAmountCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorisedAmountCurrency() {
        return this.authorisedAmountCurrency;
    }

    @JsonProperty(value="authorisedAmountCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorisedAmountCurrency(String authorisedAmountCurrency) {
        this.authorisedAmountCurrency = authorisedAmountCurrency;
    }

    public ResponseAdditionalDataCommon authorisedAmountValue(String authorisedAmountValue) {
        this.authorisedAmountValue = authorisedAmountValue;
        return this;
    }

    @ApiModelProperty(value="Value of the amount authorised.  This amount is represented in minor units according to the [following table](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="authorisedAmountValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorisedAmountValue() {
        return this.authorisedAmountValue;
    }

    @JsonProperty(value="authorisedAmountValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorisedAmountValue(String authorisedAmountValue) {
        this.authorisedAmountValue = authorisedAmountValue;
    }

    public ResponseAdditionalDataCommon avsResult(String avsResult) {
        this.avsResult = avsResult;
        return this;
    }

    @ApiModelProperty(value="The AVS result code of the payment, which provides information about the outcome of the AVS check.  For possible values, see [AVS](https://docs.adyen.com/risk-management/configure-standard-risk-rules/consistency-rules#billing-address-does-not-match-cardholder-address-avs).")
    @JsonProperty(value="avsResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAvsResult() {
        return this.avsResult;
    }

    @JsonProperty(value="avsResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvsResult(String avsResult) {
        this.avsResult = avsResult;
    }

    public ResponseAdditionalDataCommon avsResultRaw(String avsResultRaw) {
        this.avsResultRaw = avsResultRaw;
        return this;
    }

    @ApiModelProperty(value="Raw AVS result received from the acquirer, where available.  Example: D")
    @JsonProperty(value="avsResultRaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAvsResultRaw() {
        return this.avsResultRaw;
    }

    @JsonProperty(value="avsResultRaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvsResultRaw(String avsResultRaw) {
        this.avsResultRaw = avsResultRaw;
    }

    public ResponseAdditionalDataCommon bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(value="BIC of a bank account.  Example: TESTNL01  > Only relevant for SEPA Direct Debit transactions.")
    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBic() {
        return this.bic;
    }

    @JsonProperty(value="bic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBic(String bic) {
        this.bic = bic;
    }

    public ResponseAdditionalDataCommon coBrandedWith(String coBrandedWith) {
        this.coBrandedWith = coBrandedWith;
        return this;
    }

    @ApiModelProperty(value="Includes the co-branded card information.")
    @JsonProperty(value="coBrandedWith")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCoBrandedWith() {
        return this.coBrandedWith;
    }

    @JsonProperty(value="coBrandedWith")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoBrandedWith(String coBrandedWith) {
        this.coBrandedWith = coBrandedWith;
    }

    public ResponseAdditionalDataCommon cvcResult(String cvcResult) {
        this.cvcResult = cvcResult;
        return this;
    }

    @ApiModelProperty(example="1 Matches", value="The result of CVC verification.")
    @JsonProperty(value="cvcResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCvcResult() {
        return this.cvcResult;
    }

    @JsonProperty(value="cvcResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCvcResult(String cvcResult) {
        this.cvcResult = cvcResult;
    }

    public ResponseAdditionalDataCommon cvcResultRaw(String cvcResultRaw) {
        this.cvcResultRaw = cvcResultRaw;
        return this;
    }

    @ApiModelProperty(example="M", value="The raw result of CVC verification.")
    @JsonProperty(value="cvcResultRaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCvcResultRaw() {
        return this.cvcResultRaw;
    }

    @JsonProperty(value="cvcResultRaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCvcResultRaw(String cvcResultRaw) {
        this.cvcResultRaw = cvcResultRaw;
    }

    public ResponseAdditionalDataCommon dsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
        return this;
    }

    @ApiModelProperty(value="Supported for 3D Secure 2. The unique transaction identifier assigned by the DS to identify a single transaction.")
    @JsonProperty(value="dsTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDsTransID() {
        return this.dsTransID;
    }

    @JsonProperty(value="dsTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
    }

    public ResponseAdditionalDataCommon eci(String eci) {
        this.eci = eci;
        return this;
    }

    @ApiModelProperty(value="The Electronic Commerce Indicator returned from the schemes for the 3DS payment session.  Example: 02")
    @JsonProperty(value="eci")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEci() {
        return this.eci;
    }

    @JsonProperty(value="eci")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEci(String eci) {
        this.eci = eci;
    }

    public ResponseAdditionalDataCommon expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @ApiModelProperty(value="The expiry date on the card.  Example: 6/2016  > Returned only in case of a card payment.")
    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryDate() {
        return this.expiryDate;
    }

    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public ResponseAdditionalDataCommon extraCostsCurrency(String extraCostsCurrency) {
        this.extraCostsCurrency = extraCostsCurrency;
        return this;
    }

    @ApiModelProperty(value="The currency of the extra amount charged due to additional amounts set in the skin used in the HPP payment request.  Example: EUR")
    @JsonProperty(value="extraCostsCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExtraCostsCurrency() {
        return this.extraCostsCurrency;
    }

    @JsonProperty(value="extraCostsCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraCostsCurrency(String extraCostsCurrency) {
        this.extraCostsCurrency = extraCostsCurrency;
    }

    public ResponseAdditionalDataCommon extraCostsValue(String extraCostsValue) {
        this.extraCostsValue = extraCostsValue;
        return this;
    }

    @ApiModelProperty(value="The value of the extra amount charged due to additional amounts set in the skin used in the HPP payment request. The amount is in minor units.")
    @JsonProperty(value="extraCostsValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExtraCostsValue() {
        return this.extraCostsValue;
    }

    @JsonProperty(value="extraCostsValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraCostsValue(String extraCostsValue) {
        this.extraCostsValue = extraCostsValue;
    }

    public ResponseAdditionalDataCommon fraudCheckItemNrFraudCheckname(String fraudCheckItemNrFraudCheckname) {
        this.fraudCheckItemNrFraudCheckname = fraudCheckItemNrFraudCheckname;
        return this;
    }

    @ApiModelProperty(value="The fraud score due to a particular fraud check. The fraud check name is found in the key of the key-value pair.")
    @JsonProperty(value="fraudCheck-[itemNr]-[FraudCheckname]")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFraudCheckItemNrFraudCheckname() {
        return this.fraudCheckItemNrFraudCheckname;
    }

    @JsonProperty(value="fraudCheck-[itemNr]-[FraudCheckname]")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudCheckItemNrFraudCheckname(String fraudCheckItemNrFraudCheckname) {
        this.fraudCheckItemNrFraudCheckname = fraudCheckItemNrFraudCheckname;
    }

    public ResponseAdditionalDataCommon fraudManualReview(String fraudManualReview) {
        this.fraudManualReview = fraudManualReview;
        return this;
    }

    @ApiModelProperty(value="Indicates if the payment is sent to manual review.")
    @JsonProperty(value="fraudManualReview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFraudManualReview() {
        return this.fraudManualReview;
    }

    @JsonProperty(value="fraudManualReview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudManualReview(String fraudManualReview) {
        this.fraudManualReview = fraudManualReview;
    }

    public ResponseAdditionalDataCommon fraudResultType(FraudResultTypeEnum fraudResultType) {
        this.fraudResultType = fraudResultType;
        return this;
    }

    @ApiModelProperty(value="The fraud result properties of the payment.")
    @JsonProperty(value="fraudResultType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResultTypeEnum getFraudResultType() {
        return this.fraudResultType;
    }

    @JsonProperty(value="fraudResultType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResultType(FraudResultTypeEnum fraudResultType) {
        this.fraudResultType = fraudResultType;
    }

    public ResponseAdditionalDataCommon fundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="Information regarding the funding type of the card. The possible return values are: * CHARGE * CREDIT * DEBIT * PREPAID * PREPAID_RELOADABLE  * PREPAID_NONRELOADABLE * DEFFERED_DEBIT  > This functionality requires additional configuration on Adyen's end. To enable it, contact the Support Team.  For receiving this field in the notification, enable **Include Funding Source** in **Notifications** > **Additional settings**.")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
    }

    public ResponseAdditionalDataCommon fundsAvailability(String fundsAvailability) {
        this.fundsAvailability = fundsAvailability;
        return this;
    }

    @ApiModelProperty(value="Indicates availability of funds.  Visa: * \"I\" (fast funds are supported) * \"N\" (otherwise)  Mastercard: * \"I\" (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \"N\" (otherwise)  > Returned when you verify a card BIN or estimate costs, and only if payoutEligible is \"Y\" or \"D\".")
    @JsonProperty(value="fundsAvailability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundsAvailability() {
        return this.fundsAvailability;
    }

    @JsonProperty(value="fundsAvailability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsAvailability(String fundsAvailability) {
        this.fundsAvailability = fundsAvailability;
    }

    public ResponseAdditionalDataCommon inferredRefusalReason(String inferredRefusalReason) {
        this.inferredRefusalReason = inferredRefusalReason;
        return this;
    }

    @ApiModelProperty(value="Provides the more granular indication of why a transaction was refused. When a transaction fails with either \"Refused\", \"Restricted Card\", \"Transaction Not Permitted\", \"Not supported\" or \"DeclinedNon Generic\" refusalReason from the issuer, Adyen cross references its PSP-wide data for extra insight into the refusal reason. If an inferred refusal reason is available, the `inferredRefusalReason`, field is populated and the `refusalReason`, is set to \"Not Supported\".  Possible values:  * 3D Secure Mandated * Closed Account * ContAuth Not Supported * CVC Mandated * Ecommerce Not Allowed * Crossborder Not Supported * Card Updated  * Low Authrate Bin * Non-reloadable prepaid card")
    @JsonProperty(value="inferredRefusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInferredRefusalReason() {
        return this.inferredRefusalReason;
    }

    @JsonProperty(value="inferredRefusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInferredRefusalReason(String inferredRefusalReason) {
        this.inferredRefusalReason = inferredRefusalReason;
    }

    public ResponseAdditionalDataCommon isCardCommercial(String isCardCommercial) {
        this.isCardCommercial = isCardCommercial;
        return this;
    }

    @ApiModelProperty(value="Indicates if the card is used for business purposes only.")
    @JsonProperty(value="isCardCommercial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsCardCommercial() {
        return this.isCardCommercial;
    }

    @JsonProperty(value="isCardCommercial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCardCommercial(String isCardCommercial) {
        this.isCardCommercial = isCardCommercial;
    }

    public ResponseAdditionalDataCommon issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @ApiModelProperty(value="The issuing country of the card based on the BIN list that Adyen maintains.  Example: JP")
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public ResponseAdditionalDataCommon liabilityShift(String liabilityShift) {
        this.liabilityShift = liabilityShift;
        return this;
    }

    @ApiModelProperty(value="A Boolean value indicating whether a liability shift was offered for this payment.")
    @JsonProperty(value="liabilityShift")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLiabilityShift() {
        return this.liabilityShift;
    }

    @JsonProperty(value="liabilityShift")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLiabilityShift(String liabilityShift) {
        this.liabilityShift = liabilityShift;
    }

    public ResponseAdditionalDataCommon mcBankNetReferenceNumber(String mcBankNetReferenceNumber) {
        this.mcBankNetReferenceNumber = mcBankNetReferenceNumber;
        return this;
    }

    @ApiModelProperty(value="The `mcBankNetReferenceNumber`, is a minimum of six characters and a maximum of nine characters long.  > Contact Support Team to enable this field.")
    @JsonProperty(value="mcBankNetReferenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcBankNetReferenceNumber() {
        return this.mcBankNetReferenceNumber;
    }

    @JsonProperty(value="mcBankNetReferenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcBankNetReferenceNumber(String mcBankNetReferenceNumber) {
        this.mcBankNetReferenceNumber = mcBankNetReferenceNumber;
    }

    public ResponseAdditionalDataCommon merchantAdviceCode(String merchantAdviceCode) {
        this.merchantAdviceCode = merchantAdviceCode;
        return this;
    }

    @ApiModelProperty(value="The Merchant Advice Code (MAC) can be returned by Mastercard issuers for refused payments. If present, the MAC contains information about why the payment failed, and whether it can be retried.  For more information see [Mastercard Merchant Advice Codes](https://docs.adyen.com/development-resources/raw-acquirer-responses#mastercard-merchant-advice-codes).")
    @JsonProperty(value="merchantAdviceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAdviceCode() {
        return this.merchantAdviceCode;
    }

    @JsonProperty(value="merchantAdviceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAdviceCode(String merchantAdviceCode) {
        this.merchantAdviceCode = merchantAdviceCode;
    }

    public ResponseAdditionalDataCommon merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The reference provided for the transaction.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public ResponseAdditionalDataCommon networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @ApiModelProperty(value="Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")
    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public ResponseAdditionalDataCommon ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The owner name of a bank account.  Only relevant for SEPA Direct Debit transactions.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public ResponseAdditionalDataCommon paymentAccountReference(String paymentAccountReference) {
        this.paymentAccountReference = paymentAccountReference;
        return this;
    }

    @ApiModelProperty(value="The Payment Account Reference (PAR) value links a network token with the underlying primary account number (PAN). The PAR value consists of 29 uppercase alphanumeric characters.")
    @JsonProperty(value="paymentAccountReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentAccountReference() {
        return this.paymentAccountReference;
    }

    @JsonProperty(value="paymentAccountReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentAccountReference(String paymentAccountReference) {
        this.paymentAccountReference = paymentAccountReference;
    }

    public ResponseAdditionalDataCommon paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="The payment method used in the transaction.")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public ResponseAdditionalDataCommon paymentMethodVariant(String paymentMethodVariant) {
        this.paymentMethodVariant = paymentMethodVariant;
        return this;
    }

    @ApiModelProperty(value="The Adyen sub-variant of the payment method used for the payment request.  For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).  Example: mcpro")
    @JsonProperty(value="paymentMethodVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMethodVariant() {
        return this.paymentMethodVariant;
    }

    @JsonProperty(value="paymentMethodVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethodVariant(String paymentMethodVariant) {
        this.paymentMethodVariant = paymentMethodVariant;
    }

    public ResponseAdditionalDataCommon payoutEligible(String payoutEligible) {
        this.payoutEligible = payoutEligible;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a payout is eligible or not for this card.  Visa: * \"Y\" * \"N\"  Mastercard: * \"Y\" (domestic and cross-border)  * \"D\" (only domestic) * \"N\" (no MoneySend) * \"U\" (unknown)")
    @JsonProperty(value="payoutEligible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutEligible() {
        return this.payoutEligible;
    }

    @JsonProperty(value="payoutEligible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutEligible(String payoutEligible) {
        this.payoutEligible = payoutEligible;
    }

    public ResponseAdditionalDataCommon realtimeAccountUpdaterStatus(String realtimeAccountUpdaterStatus) {
        this.realtimeAccountUpdaterStatus = realtimeAccountUpdaterStatus;
        return this;
    }

    @ApiModelProperty(value="The response code from the Real Time Account Updater service.  Possible return values are: * CardChanged * CardExpiryChanged * CloseAccount  * ContactCardAccountHolder")
    @JsonProperty(value="realtimeAccountUpdaterStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRealtimeAccountUpdaterStatus() {
        return this.realtimeAccountUpdaterStatus;
    }

    @JsonProperty(value="realtimeAccountUpdaterStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRealtimeAccountUpdaterStatus(String realtimeAccountUpdaterStatus) {
        this.realtimeAccountUpdaterStatus = realtimeAccountUpdaterStatus;
    }

    public ResponseAdditionalDataCommon receiptFreeText(String receiptFreeText) {
        this.receiptFreeText = receiptFreeText;
        return this;
    }

    @ApiModelProperty(value="Message to be displayed on the terminal.")
    @JsonProperty(value="receiptFreeText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReceiptFreeText() {
        return this.receiptFreeText;
    }

    @JsonProperty(value="receiptFreeText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiptFreeText(String receiptFreeText) {
        this.receiptFreeText = receiptFreeText;
    }

    public ResponseAdditionalDataCommon recurringContractTypes(String recurringContractTypes) {
        this.recurringContractTypes = recurringContractTypes;
        return this;
    }

    @ApiModelProperty(value="The recurring contract types applicable to the transaction.")
    @JsonProperty(value="recurring.contractTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringContractTypes() {
        return this.recurringContractTypes;
    }

    @JsonProperty(value="recurring.contractTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringContractTypes(String recurringContractTypes) {
        this.recurringContractTypes = recurringContractTypes;
    }

    public ResponseAdditionalDataCommon recurringFirstPspReference(String recurringFirstPspReference) {
        this.recurringFirstPspReference = recurringFirstPspReference;
        return this;
    }

    @ApiModelProperty(value="The `pspReference`, of the first recurring payment that created the recurring detail.  This functionality requires additional configuration on Adyen's end. To enable it, contact the Support Team.")
    @JsonProperty(value="recurring.firstPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringFirstPspReference() {
        return this.recurringFirstPspReference;
    }

    @JsonProperty(value="recurring.firstPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringFirstPspReference(String recurringFirstPspReference) {
        this.recurringFirstPspReference = recurringFirstPspReference;
    }

    @Deprecated
    public ResponseAdditionalDataCommon recurringRecurringDetailReference(String recurringRecurringDetailReference) {
        this.recurringRecurringDetailReference = recurringRecurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The reference that uniquely identifies the recurring transaction.")
    @JsonProperty(value="recurring.recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringRecurringDetailReference() {
        return this.recurringRecurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurring.recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringRecurringDetailReference(String recurringRecurringDetailReference) {
        this.recurringRecurringDetailReference = recurringRecurringDetailReference;
    }

    @Deprecated
    public ResponseAdditionalDataCommon recurringShopperReference(String recurringShopperReference) {
        this.recurringShopperReference = recurringShopperReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The provided reference of the shopper for a recurring transaction.")
    @JsonProperty(value="recurring.shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringShopperReference() {
        return this.recurringShopperReference;
    }

    @Deprecated
    @JsonProperty(value="recurring.shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringShopperReference(String recurringShopperReference) {
        this.recurringShopperReference = recurringShopperReference;
    }

    public ResponseAdditionalDataCommon recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="The processing model used for the recurring transaction.")
    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public ResponseAdditionalDataCommon referred(String referred) {
        this.referred = referred;
        return this;
    }

    @ApiModelProperty(value="If the payment is referred, this field is set to true.  This field is unavailable if the payment is referred and is usually not returned with ecommerce transactions.  Example: true")
    @JsonProperty(value="referred")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferred() {
        return this.referred;
    }

    @JsonProperty(value="referred")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferred(String referred) {
        this.referred = referred;
    }

    public ResponseAdditionalDataCommon refusalReasonRaw(String refusalReasonRaw) {
        this.refusalReasonRaw = refusalReasonRaw;
        return this;
    }

    @ApiModelProperty(value="Raw refusal reason received from the acquirer, where available.  Example: AUTHORISED")
    @JsonProperty(value="refusalReasonRaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReasonRaw() {
        return this.refusalReasonRaw;
    }

    @JsonProperty(value="refusalReasonRaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReasonRaw(String refusalReasonRaw) {
        this.refusalReasonRaw = refusalReasonRaw;
    }

    public ResponseAdditionalDataCommon requestAmount(String requestAmount) {
        this.requestAmount = requestAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the payment request.")
    @JsonProperty(value="requestAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestAmount() {
        return this.requestAmount;
    }

    @JsonProperty(value="requestAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestAmount(String requestAmount) {
        this.requestAmount = requestAmount;
    }

    public ResponseAdditionalDataCommon requestCurrencyCode(String requestCurrencyCode) {
        this.requestCurrencyCode = requestCurrencyCode;
        return this;
    }

    @ApiModelProperty(value="The currency of the payment request.")
    @JsonProperty(value="requestCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestCurrencyCode() {
        return this.requestCurrencyCode;
    }

    @JsonProperty(value="requestCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestCurrencyCode(String requestCurrencyCode) {
        this.requestCurrencyCode = requestCurrencyCode;
    }

    public ResponseAdditionalDataCommon shopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="The shopper interaction type of the payment request.  Example: Ecommerce")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public ResponseAdditionalDataCommon shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="The shopperReference passed in the payment request.  Example: AdyenTestShopperXX")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public ResponseAdditionalDataCommon terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="The terminal ID used in a point-of-sale payment.  Example: 06022622")
    @JsonProperty(value="terminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTerminalId() {
        return this.terminalId;
    }

    @JsonProperty(value="terminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public ResponseAdditionalDataCommon threeDAuthenticated(String threeDAuthenticated) {
        this.threeDAuthenticated = threeDAuthenticated;
        return this;
    }

    @ApiModelProperty(value="A Boolean value indicating whether 3DS authentication was completed on this payment.  Example: true")
    @JsonProperty(value="threeDAuthenticated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDAuthenticated() {
        return this.threeDAuthenticated;
    }

    @JsonProperty(value="threeDAuthenticated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDAuthenticated(String threeDAuthenticated) {
        this.threeDAuthenticated = threeDAuthenticated;
    }

    public ResponseAdditionalDataCommon threeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
        this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
        return this;
    }

    @ApiModelProperty(value="The raw 3DS authentication result from the card issuer.  Example: N")
    @JsonProperty(value="threeDAuthenticatedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDAuthenticatedResponse() {
        return this.threeDAuthenticatedResponse;
    }

    @JsonProperty(value="threeDAuthenticatedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDAuthenticatedResponse(String threeDAuthenticatedResponse) {
        this.threeDAuthenticatedResponse = threeDAuthenticatedResponse;
    }

    public ResponseAdditionalDataCommon threeDOffered(String threeDOffered) {
        this.threeDOffered = threeDOffered;
        return this;
    }

    @ApiModelProperty(value="A Boolean value indicating whether 3DS was offered for this payment.  Example: true")
    @JsonProperty(value="threeDOffered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDOffered() {
        return this.threeDOffered;
    }

    @JsonProperty(value="threeDOffered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDOffered(String threeDOffered) {
        this.threeDOffered = threeDOffered;
    }

    public ResponseAdditionalDataCommon threeDOfferedResponse(String threeDOfferedResponse) {
        this.threeDOfferedResponse = threeDOfferedResponse;
        return this;
    }

    @ApiModelProperty(value="The raw enrollment result from the 3DS directory services of the card schemes.  Example: Y")
    @JsonProperty(value="threeDOfferedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDOfferedResponse() {
        return this.threeDOfferedResponse;
    }

    @JsonProperty(value="threeDOfferedResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDOfferedResponse(String threeDOfferedResponse) {
        this.threeDOfferedResponse = threeDOfferedResponse;
    }

    public ResponseAdditionalDataCommon threeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @ApiModelProperty(value="The 3D Secure 2 version.")
    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSVersion() {
        return this.threeDSVersion;
    }

    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public ResponseAdditionalDataCommon tokenizationShopperReference(String tokenizationShopperReference) {
        this.tokenizationShopperReference = tokenizationShopperReference;
        return this;
    }

    @ApiModelProperty(value="The reference for the shopper that you sent when tokenizing the payment details.")
    @JsonProperty(value="tokenization.shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenizationShopperReference() {
        return this.tokenizationShopperReference;
    }

    @JsonProperty(value="tokenization.shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenizationShopperReference(String tokenizationShopperReference) {
        this.tokenizationShopperReference = tokenizationShopperReference;
    }

    public ResponseAdditionalDataCommon tokenizationStoreOperationType(TokenizationStoreOperationTypeEnum tokenizationStoreOperationType) {
        this.tokenizationStoreOperationType = tokenizationStoreOperationType;
        return this;
    }

    @ApiModelProperty(value="The operation performed on the token. Possible values:  * **created**: the token has been created. * **updated**: the existing token has been updated. * **alreadyExisting**: the details have already been stored. ")
    @JsonProperty(value="tokenization.store.operationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenizationStoreOperationTypeEnum getTokenizationStoreOperationType() {
        return this.tokenizationStoreOperationType;
    }

    @JsonProperty(value="tokenization.store.operationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenizationStoreOperationType(TokenizationStoreOperationTypeEnum tokenizationStoreOperationType) {
        this.tokenizationStoreOperationType = tokenizationStoreOperationType;
    }

    public ResponseAdditionalDataCommon tokenizationStoredPaymentMethodId(String tokenizationStoredPaymentMethodId) {
        this.tokenizationStoredPaymentMethodId = tokenizationStoredPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="The reference that uniquely identifies tokenized payment details.")
    @JsonProperty(value="tokenization.storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenizationStoredPaymentMethodId() {
        return this.tokenizationStoredPaymentMethodId;
    }

    @JsonProperty(value="tokenization.storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenizationStoredPaymentMethodId(String tokenizationStoredPaymentMethodId) {
        this.tokenizationStoredPaymentMethodId = tokenizationStoredPaymentMethodId;
    }

    public ResponseAdditionalDataCommon visaTransactionId(String visaTransactionId) {
        this.visaTransactionId = visaTransactionId;
        return this;
    }

    @ApiModelProperty(value="The `visaTransactionId`, has a fixed length of 15 numeric characters.  > Contact Support Team to enable this field.")
    @JsonProperty(value="visaTransactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVisaTransactionId() {
        return this.visaTransactionId;
    }

    @JsonProperty(value="visaTransactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisaTransactionId(String visaTransactionId) {
        this.visaTransactionId = visaTransactionId;
    }

    public ResponseAdditionalDataCommon xid(String xid) {
        this.xid = xid;
        return this;
    }

    @ApiModelProperty(value="The 3DS transaction ID of the 3DS session sent in notifications. The value is Base64-encoded and is returned for transactions with directoryResponse 'N' or 'Y'.   Example: ODgxNDc2MDg2MDExODk5MAAAAAA=")
    @JsonProperty(value="xid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getXid() {
        return this.xid;
    }

    @JsonProperty(value="xid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXid(String xid) {
        this.xid = xid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseAdditionalDataCommon responseAdditionalDataCommon = (ResponseAdditionalDataCommon)o;
        return Objects.equals(this.acquirerAccountCode, responseAdditionalDataCommon.acquirerAccountCode) && Objects.equals(this.acquirerCode, responseAdditionalDataCommon.acquirerCode) && Objects.equals(this.acquirerReference, responseAdditionalDataCommon.acquirerReference) && Objects.equals(this.alias, responseAdditionalDataCommon.alias) && Objects.equals(this.aliasType, responseAdditionalDataCommon.aliasType) && Objects.equals(this.authCode, responseAdditionalDataCommon.authCode) && Objects.equals(this.authorisationMid, responseAdditionalDataCommon.authorisationMid) && Objects.equals(this.authorisedAmountCurrency, responseAdditionalDataCommon.authorisedAmountCurrency) && Objects.equals(this.authorisedAmountValue, responseAdditionalDataCommon.authorisedAmountValue) && Objects.equals(this.avsResult, responseAdditionalDataCommon.avsResult) && Objects.equals(this.avsResultRaw, responseAdditionalDataCommon.avsResultRaw) && Objects.equals(this.bic, responseAdditionalDataCommon.bic) && Objects.equals(this.coBrandedWith, responseAdditionalDataCommon.coBrandedWith) && Objects.equals(this.cvcResult, responseAdditionalDataCommon.cvcResult) && Objects.equals(this.cvcResultRaw, responseAdditionalDataCommon.cvcResultRaw) && Objects.equals(this.dsTransID, responseAdditionalDataCommon.dsTransID) && Objects.equals(this.eci, responseAdditionalDataCommon.eci) && Objects.equals(this.expiryDate, responseAdditionalDataCommon.expiryDate) && Objects.equals(this.extraCostsCurrency, responseAdditionalDataCommon.extraCostsCurrency) && Objects.equals(this.extraCostsValue, responseAdditionalDataCommon.extraCostsValue) && Objects.equals(this.fraudCheckItemNrFraudCheckname, responseAdditionalDataCommon.fraudCheckItemNrFraudCheckname) && Objects.equals(this.fraudManualReview, responseAdditionalDataCommon.fraudManualReview) && Objects.equals((Object)this.fraudResultType, (Object)responseAdditionalDataCommon.fraudResultType) && Objects.equals(this.fundingSource, responseAdditionalDataCommon.fundingSource) && Objects.equals(this.fundsAvailability, responseAdditionalDataCommon.fundsAvailability) && Objects.equals(this.inferredRefusalReason, responseAdditionalDataCommon.inferredRefusalReason) && Objects.equals(this.isCardCommercial, responseAdditionalDataCommon.isCardCommercial) && Objects.equals(this.issuerCountry, responseAdditionalDataCommon.issuerCountry) && Objects.equals(this.liabilityShift, responseAdditionalDataCommon.liabilityShift) && Objects.equals(this.mcBankNetReferenceNumber, responseAdditionalDataCommon.mcBankNetReferenceNumber) && Objects.equals(this.merchantAdviceCode, responseAdditionalDataCommon.merchantAdviceCode) && Objects.equals(this.merchantReference, responseAdditionalDataCommon.merchantReference) && Objects.equals(this.networkTxReference, responseAdditionalDataCommon.networkTxReference) && Objects.equals(this.ownerName, responseAdditionalDataCommon.ownerName) && Objects.equals(this.paymentAccountReference, responseAdditionalDataCommon.paymentAccountReference) && Objects.equals(this.paymentMethod, responseAdditionalDataCommon.paymentMethod) && Objects.equals(this.paymentMethodVariant, responseAdditionalDataCommon.paymentMethodVariant) && Objects.equals(this.payoutEligible, responseAdditionalDataCommon.payoutEligible) && Objects.equals(this.realtimeAccountUpdaterStatus, responseAdditionalDataCommon.realtimeAccountUpdaterStatus) && Objects.equals(this.receiptFreeText, responseAdditionalDataCommon.receiptFreeText) && Objects.equals(this.recurringContractTypes, responseAdditionalDataCommon.recurringContractTypes) && Objects.equals(this.recurringFirstPspReference, responseAdditionalDataCommon.recurringFirstPspReference) && Objects.equals(this.recurringRecurringDetailReference, responseAdditionalDataCommon.recurringRecurringDetailReference) && Objects.equals(this.recurringShopperReference, responseAdditionalDataCommon.recurringShopperReference) && Objects.equals((Object)this.recurringProcessingModel, (Object)responseAdditionalDataCommon.recurringProcessingModel) && Objects.equals(this.referred, responseAdditionalDataCommon.referred) && Objects.equals(this.refusalReasonRaw, responseAdditionalDataCommon.refusalReasonRaw) && Objects.equals(this.requestAmount, responseAdditionalDataCommon.requestAmount) && Objects.equals(this.requestCurrencyCode, responseAdditionalDataCommon.requestCurrencyCode) && Objects.equals(this.shopperInteraction, responseAdditionalDataCommon.shopperInteraction) && Objects.equals(this.shopperReference, responseAdditionalDataCommon.shopperReference) && Objects.equals(this.terminalId, responseAdditionalDataCommon.terminalId) && Objects.equals(this.threeDAuthenticated, responseAdditionalDataCommon.threeDAuthenticated) && Objects.equals(this.threeDAuthenticatedResponse, responseAdditionalDataCommon.threeDAuthenticatedResponse) && Objects.equals(this.threeDOffered, responseAdditionalDataCommon.threeDOffered) && Objects.equals(this.threeDOfferedResponse, responseAdditionalDataCommon.threeDOfferedResponse) && Objects.equals(this.threeDSVersion, responseAdditionalDataCommon.threeDSVersion) && Objects.equals(this.tokenizationShopperReference, responseAdditionalDataCommon.tokenizationShopperReference) && Objects.equals((Object)this.tokenizationStoreOperationType, (Object)responseAdditionalDataCommon.tokenizationStoreOperationType) && Objects.equals(this.tokenizationStoredPaymentMethodId, responseAdditionalDataCommon.tokenizationStoredPaymentMethodId) && Objects.equals(this.visaTransactionId, responseAdditionalDataCommon.visaTransactionId) && Objects.equals(this.xid, responseAdditionalDataCommon.xid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquirerAccountCode, this.acquirerCode, this.acquirerReference, this.alias, this.aliasType, this.authCode, this.authorisationMid, this.authorisedAmountCurrency, this.authorisedAmountValue, this.avsResult, this.avsResultRaw, this.bic, this.coBrandedWith, this.cvcResult, this.cvcResultRaw, this.dsTransID, this.eci, this.expiryDate, this.extraCostsCurrency, this.extraCostsValue, this.fraudCheckItemNrFraudCheckname, this.fraudManualReview, this.fraudResultType, this.fundingSource, this.fundsAvailability, this.inferredRefusalReason, this.isCardCommercial, this.issuerCountry, this.liabilityShift, this.mcBankNetReferenceNumber, this.merchantAdviceCode, this.merchantReference, this.networkTxReference, this.ownerName, this.paymentAccountReference, this.paymentMethod, this.paymentMethodVariant, this.payoutEligible, this.realtimeAccountUpdaterStatus, this.receiptFreeText, this.recurringContractTypes, this.recurringFirstPspReference, this.recurringRecurringDetailReference, this.recurringShopperReference, this.recurringProcessingModel, this.referred, this.refusalReasonRaw, this.requestAmount, this.requestCurrencyCode, this.shopperInteraction, this.shopperReference, this.terminalId, this.threeDAuthenticated, this.threeDAuthenticatedResponse, this.threeDOffered, this.threeDOfferedResponse, this.threeDSVersion, this.tokenizationShopperReference, this.tokenizationStoreOperationType, this.tokenizationStoredPaymentMethodId, this.visaTransactionId, this.xid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseAdditionalDataCommon {\n");
        sb.append("    acquirerAccountCode: ").append(this.toIndentedString(this.acquirerAccountCode)).append("\n");
        sb.append("    acquirerCode: ").append(this.toIndentedString(this.acquirerCode)).append("\n");
        sb.append("    acquirerReference: ").append(this.toIndentedString(this.acquirerReference)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    aliasType: ").append(this.toIndentedString(this.aliasType)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    authorisationMid: ").append(this.toIndentedString(this.authorisationMid)).append("\n");
        sb.append("    authorisedAmountCurrency: ").append(this.toIndentedString(this.authorisedAmountCurrency)).append("\n");
        sb.append("    authorisedAmountValue: ").append(this.toIndentedString(this.authorisedAmountValue)).append("\n");
        sb.append("    avsResult: ").append(this.toIndentedString(this.avsResult)).append("\n");
        sb.append("    avsResultRaw: ").append(this.toIndentedString(this.avsResultRaw)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    coBrandedWith: ").append(this.toIndentedString(this.coBrandedWith)).append("\n");
        sb.append("    cvcResult: ").append(this.toIndentedString(this.cvcResult)).append("\n");
        sb.append("    cvcResultRaw: ").append(this.toIndentedString(this.cvcResultRaw)).append("\n");
        sb.append("    dsTransID: ").append(this.toIndentedString(this.dsTransID)).append("\n");
        sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    extraCostsCurrency: ").append(this.toIndentedString(this.extraCostsCurrency)).append("\n");
        sb.append("    extraCostsValue: ").append(this.toIndentedString(this.extraCostsValue)).append("\n");
        sb.append("    fraudCheckItemNrFraudCheckname: ").append(this.toIndentedString(this.fraudCheckItemNrFraudCheckname)).append("\n");
        sb.append("    fraudManualReview: ").append(this.toIndentedString(this.fraudManualReview)).append("\n");
        sb.append("    fraudResultType: ").append(this.toIndentedString((Object)this.fraudResultType)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString(this.fundingSource)).append("\n");
        sb.append("    fundsAvailability: ").append(this.toIndentedString(this.fundsAvailability)).append("\n");
        sb.append("    inferredRefusalReason: ").append(this.toIndentedString(this.inferredRefusalReason)).append("\n");
        sb.append("    isCardCommercial: ").append(this.toIndentedString(this.isCardCommercial)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    liabilityShift: ").append(this.toIndentedString(this.liabilityShift)).append("\n");
        sb.append("    mcBankNetReferenceNumber: ").append(this.toIndentedString(this.mcBankNetReferenceNumber)).append("\n");
        sb.append("    merchantAdviceCode: ").append(this.toIndentedString(this.merchantAdviceCode)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    paymentAccountReference: ").append(this.toIndentedString(this.paymentAccountReference)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentMethodVariant: ").append(this.toIndentedString(this.paymentMethodVariant)).append("\n");
        sb.append("    payoutEligible: ").append(this.toIndentedString(this.payoutEligible)).append("\n");
        sb.append("    realtimeAccountUpdaterStatus: ").append(this.toIndentedString(this.realtimeAccountUpdaterStatus)).append("\n");
        sb.append("    receiptFreeText: ").append(this.toIndentedString(this.receiptFreeText)).append("\n");
        sb.append("    recurringContractTypes: ").append(this.toIndentedString(this.recurringContractTypes)).append("\n");
        sb.append("    recurringFirstPspReference: ").append(this.toIndentedString(this.recurringFirstPspReference)).append("\n");
        sb.append("    recurringRecurringDetailReference: ").append(this.toIndentedString(this.recurringRecurringDetailReference)).append("\n");
        sb.append("    recurringShopperReference: ").append(this.toIndentedString(this.recurringShopperReference)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    referred: ").append(this.toIndentedString(this.referred)).append("\n");
        sb.append("    refusalReasonRaw: ").append(this.toIndentedString(this.refusalReasonRaw)).append("\n");
        sb.append("    requestAmount: ").append(this.toIndentedString(this.requestAmount)).append("\n");
        sb.append("    requestCurrencyCode: ").append(this.toIndentedString(this.requestCurrencyCode)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString(this.shopperInteraction)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    terminalId: ").append(this.toIndentedString(this.terminalId)).append("\n");
        sb.append("    threeDAuthenticated: ").append(this.toIndentedString(this.threeDAuthenticated)).append("\n");
        sb.append("    threeDAuthenticatedResponse: ").append(this.toIndentedString(this.threeDAuthenticatedResponse)).append("\n");
        sb.append("    threeDOffered: ").append(this.toIndentedString(this.threeDOffered)).append("\n");
        sb.append("    threeDOfferedResponse: ").append(this.toIndentedString(this.threeDOfferedResponse)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString(this.threeDSVersion)).append("\n");
        sb.append("    tokenizationShopperReference: ").append(this.toIndentedString(this.tokenizationShopperReference)).append("\n");
        sb.append("    tokenizationStoreOperationType: ").append(this.toIndentedString((Object)this.tokenizationStoreOperationType)).append("\n");
        sb.append("    tokenizationStoredPaymentMethodId: ").append(this.toIndentedString(this.tokenizationStoredPaymentMethodId)).append("\n");
        sb.append("    visaTransactionId: ").append(this.toIndentedString(this.visaTransactionId)).append("\n");
        sb.append("    xid: ").append(this.toIndentedString(this.xid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ResponseAdditionalDataCommon fromJson(String jsonString) throws JsonProcessingException {
        return (ResponseAdditionalDataCommon)JSON.getMapper().readValue(jsonString, ResponseAdditionalDataCommon.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TokenizationStoreOperationTypeEnum {
        CREATED("created"),
        UPDATED("updated"),
        ALREADYEXISTING("alreadyExisting");

        private String value;

        private TokenizationStoreOperationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenizationStoreOperationTypeEnum fromValue(String value) {
            for (TokenizationStoreOperationTypeEnum b : TokenizationStoreOperationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FraudResultTypeEnum {
        GREEN("GREEN"),
        FRAUD("FRAUD");

        private String value;

        private FraudResultTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FraudResultTypeEnum fromValue(String value) {
            for (FraudResultTypeEnum b : FraudResultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

