/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"checks", "signatoryCode"})
public class KYCSignatoryCheckResult {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    private List<KYCCheckStatusData> checks = null;
    public static final String JSON_PROPERTY_SIGNATORY_CODE = "signatoryCode";
    private String signatoryCode;

    public KYCSignatoryCheckResult checks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
        return this;
    }

    public KYCSignatoryCheckResult addChecksItem(KYCCheckStatusData checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<KYCCheckStatusData>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @ApiModelProperty(value="A list of the checks and their statuses.")
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCCheckStatusData> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
    }

    public KYCSignatoryCheckResult signatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
        return this;
    }

    @ApiModelProperty(value="The code of the signatory to which the check applies.")
    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignatoryCode() {
        return this.signatoryCode;
    }

    @JsonProperty(value="signatoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatoryCode(String signatoryCode) {
        this.signatoryCode = signatoryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCSignatoryCheckResult kyCSignatoryCheckResult = (KYCSignatoryCheckResult)o;
        return Objects.equals(this.checks, kyCSignatoryCheckResult.checks) && Objects.equals(this.signatoryCode, kyCSignatoryCheckResult.signatoryCode);
    }

    public int hashCode() {
        return Objects.hash(this.checks, this.signatoryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCSignatoryCheckResult {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    signatoryCode: ").append(this.toIndentedString(this.signatoryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCSignatoryCheckResult fromJson(String jsonString) throws JsonProcessingException {
        return (KYCSignatoryCheckResult)JSON.getMapper().readValue(jsonString, KYCSignatoryCheckResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

