/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;

@JsonPropertyOrder(value={"document", "id", "termsOfServiceAcceptanceReference", "termsOfServiceDocumentFormat"})
public class GetAcceptedTermsOfServiceDocumentResponse {
    public static final String JSON_PROPERTY_DOCUMENT = "document";
    private byte[] document;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TERMS_OF_SERVICE_ACCEPTANCE_REFERENCE = "termsOfServiceAcceptanceReference";
    private String termsOfServiceAcceptanceReference;
    public static final String JSON_PROPERTY_TERMS_OF_SERVICE_DOCUMENT_FORMAT = "termsOfServiceDocumentFormat";
    private TermsOfServiceDocumentFormatEnum termsOfServiceDocumentFormat;

    public GetAcceptedTermsOfServiceDocumentResponse document(byte[] document) {
        this.document = document;
        return this;
    }

    @ApiModelProperty(value="The accepted Terms of Service document in the requested format represented as a Base64-encoded bytes array.")
    @JsonProperty(value="document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getDocument() {
        return this.document;
    }

    @JsonProperty(value="document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocument(byte[] document) {
        this.document = document;
    }

    public GetAcceptedTermsOfServiceDocumentResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the legal entity.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public GetAcceptedTermsOfServiceDocumentResponse termsOfServiceAcceptanceReference(String termsOfServiceAcceptanceReference) {
        this.termsOfServiceAcceptanceReference = termsOfServiceAcceptanceReference;
        return this;
    }

    @ApiModelProperty(value="An Adyen-generated reference for the accepted Terms of Service.")
    @JsonProperty(value="termsOfServiceAcceptanceReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTermsOfServiceAcceptanceReference() {
        return this.termsOfServiceAcceptanceReference;
    }

    @JsonProperty(value="termsOfServiceAcceptanceReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTermsOfServiceAcceptanceReference(String termsOfServiceAcceptanceReference) {
        this.termsOfServiceAcceptanceReference = termsOfServiceAcceptanceReference;
    }

    public GetAcceptedTermsOfServiceDocumentResponse termsOfServiceDocumentFormat(TermsOfServiceDocumentFormatEnum termsOfServiceDocumentFormat) {
        this.termsOfServiceDocumentFormat = termsOfServiceDocumentFormat;
        return this;
    }

    @ApiModelProperty(value="The format of the Terms of Service document.")
    @JsonProperty(value="termsOfServiceDocumentFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TermsOfServiceDocumentFormatEnum getTermsOfServiceDocumentFormat() {
        return this.termsOfServiceDocumentFormat;
    }

    @JsonProperty(value="termsOfServiceDocumentFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTermsOfServiceDocumentFormat(TermsOfServiceDocumentFormatEnum termsOfServiceDocumentFormat) {
        this.termsOfServiceDocumentFormat = termsOfServiceDocumentFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAcceptedTermsOfServiceDocumentResponse getAcceptedTermsOfServiceDocumentResponse = (GetAcceptedTermsOfServiceDocumentResponse)o;
        return Arrays.equals(this.document, getAcceptedTermsOfServiceDocumentResponse.document) && Objects.equals(this.id, getAcceptedTermsOfServiceDocumentResponse.id) && Objects.equals(this.termsOfServiceAcceptanceReference, getAcceptedTermsOfServiceDocumentResponse.termsOfServiceAcceptanceReference) && Objects.equals((Object)this.termsOfServiceDocumentFormat, (Object)getAcceptedTermsOfServiceDocumentResponse.termsOfServiceDocumentFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.document), this.id, this.termsOfServiceAcceptanceReference, this.termsOfServiceDocumentFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAcceptedTermsOfServiceDocumentResponse {\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    termsOfServiceAcceptanceReference: ").append(this.toIndentedString(this.termsOfServiceAcceptanceReference)).append("\n");
        sb.append("    termsOfServiceDocumentFormat: ").append(this.toIndentedString((Object)this.termsOfServiceDocumentFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetAcceptedTermsOfServiceDocumentResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GetAcceptedTermsOfServiceDocumentResponse)JSON.getMapper().readValue(jsonString, GetAcceptedTermsOfServiceDocumentResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TermsOfServiceDocumentFormatEnum {
        JSON("JSON"),
        PDF("PDF"),
        TXT("TXT");

        private String value;

        private TermsOfServiceDocumentFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TermsOfServiceDocumentFormatEnum fromValue(String value) {
            for (TermsOfServiceDocumentFormatEnum b : TermsOfServiceDocumentFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

