/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.JSON;
import com.adyen.model.marketpayfund.TransactionListForAccount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "transactionListsPerAccount", "transactionStatuses"})
public class AccountHolderTransactionListRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_TRANSACTION_LISTS_PER_ACCOUNT = "transactionListsPerAccount";
    private List<TransactionListForAccount> transactionListsPerAccount = null;
    public static final String JSON_PROPERTY_TRANSACTION_STATUSES = "transactionStatuses";
    private List<TransactionStatusesEnum> transactionStatuses = null;

    public AccountHolderTransactionListRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder that owns the account(s) of which retrieve the transaction list.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderTransactionListRequest transactionListsPerAccount(List<TransactionListForAccount> transactionListsPerAccount) {
        this.transactionListsPerAccount = transactionListsPerAccount;
        return this;
    }

    public AccountHolderTransactionListRequest addTransactionListsPerAccountItem(TransactionListForAccount transactionListsPerAccountItem) {
        if (this.transactionListsPerAccount == null) {
            this.transactionListsPerAccount = new ArrayList<TransactionListForAccount>();
        }
        this.transactionListsPerAccount.add(transactionListsPerAccountItem);
        return this;
    }

    @ApiModelProperty(value="A list of accounts to include in the transaction list. If left blank, the last fifty (50) transactions for all accounts of the account holder will be included.")
    @JsonProperty(value="transactionListsPerAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransactionListForAccount> getTransactionListsPerAccount() {
        return this.transactionListsPerAccount;
    }

    @JsonProperty(value="transactionListsPerAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionListsPerAccount(List<TransactionListForAccount> transactionListsPerAccount) {
        this.transactionListsPerAccount = transactionListsPerAccount;
    }

    public AccountHolderTransactionListRequest transactionStatuses(List<TransactionStatusesEnum> transactionStatuses) {
        this.transactionStatuses = transactionStatuses;
        return this;
    }

    public AccountHolderTransactionListRequest addTransactionStatusesItem(TransactionStatusesEnum transactionStatusesItem) {
        if (this.transactionStatuses == null) {
            this.transactionStatuses = new ArrayList<TransactionStatusesEnum>();
        }
        this.transactionStatuses.add(transactionStatusesItem);
        return this;
    }

    @ApiModelProperty(value="A list of statuses to include in the transaction list. If left blank, all transactions will be included. >Permitted values: >* `PendingCredit` - a pending balance credit. >* `CreditFailed` - a pending credit failure; the balance will not be credited. >* `Credited` - a credited balance. >* `PendingDebit` - a pending balance debit (e.g., a refund). >* `CreditClosed` - a pending credit closed; the balance will not be credited. >* `CreditSuspended` - a pending credit closed; the balance will not be credited. >* `DebitFailed` - a pending debit failure; the balance will not be debited. >* `Debited` - a debited balance (e.g., a refund). >* `DebitReversedReceived` - a pending refund reversal. >* `DebitedReversed` - a reversed refund. >* `ChargebackReceived` - a received chargeback request. >* `Chargeback` - a processed chargeback. >* `ChargebackReversedReceived` - a pending chargeback reversal. >* `ChargebackReversed` - a reversed chargeback. >* `Converted` - converted. >* `ManualCorrected` - manual booking/adjustment by Adyen. >* `Payout` - a payout. >* `PayoutReversed` - a reversed payout. >* `PendingFundTransfer` - a pending transfer of funds from one account to another. >* `FundTransfer` - a transfer of funds from one account to another.")
    @JsonProperty(value="transactionStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransactionStatusesEnum> getTransactionStatuses() {
        return this.transactionStatuses;
    }

    @JsonProperty(value="transactionStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionStatuses(List<TransactionStatusesEnum> transactionStatuses) {
        this.transactionStatuses = transactionStatuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderTransactionListRequest accountHolderTransactionListRequest = (AccountHolderTransactionListRequest)o;
        return Objects.equals(this.accountHolderCode, accountHolderTransactionListRequest.accountHolderCode) && Objects.equals(this.transactionListsPerAccount, accountHolderTransactionListRequest.transactionListsPerAccount) && Objects.equals(this.transactionStatuses, accountHolderTransactionListRequest.transactionStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.transactionListsPerAccount, this.transactionStatuses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderTransactionListRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    transactionListsPerAccount: ").append(this.toIndentedString(this.transactionListsPerAccount)).append("\n");
        sb.append("    transactionStatuses: ").append(this.toIndentedString(this.transactionStatuses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderTransactionListRequest fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderTransactionListRequest)JSON.getMapper().readValue(jsonString, AccountHolderTransactionListRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TransactionStatusesEnum {
        BALANCENOTPAIDOUTTRANSFER("BalanceNotPaidOutTransfer"),
        BALANCEPLATFORMSWEEP("BalancePlatformSweep"),
        BALANCEPLATFORMSWEEPRETURNED("BalancePlatformSweepReturned"),
        CHARGEBACK("Chargeback"),
        CHARGEBACKCORRECTION("ChargebackCorrection"),
        CHARGEBACKCORRECTIONRECEIVED("ChargebackCorrectionReceived"),
        CHARGEBACKRECEIVED("ChargebackReceived"),
        CHARGEBACKREVERSED("ChargebackReversed"),
        CHARGEBACKREVERSEDCORRECTION("ChargebackReversedCorrection"),
        CHARGEBACKREVERSEDCORRECTIONRECEIVED("ChargebackReversedCorrectionReceived"),
        CHARGEBACKREVERSEDRECEIVED("ChargebackReversedReceived"),
        CONVERTED("Converted"),
        CREDITCLOSED("CreditClosed"),
        CREDITFAILED("CreditFailed"),
        CREDITREVERSED("CreditReversed"),
        CREDITREVERSEDRECEIVED("CreditReversedReceived"),
        CREDITSUSPENDED("CreditSuspended"),
        CREDITED("Credited"),
        DEBITFAILED("DebitFailed"),
        DEBITREVERSEDRECEIVED("DebitReversedReceived"),
        DEBITED("Debited"),
        DEBITEDREVERSED("DebitedReversed"),
        DEPOSITCORRECTIONCREDITED("DepositCorrectionCredited"),
        DEPOSITCORRECTIONDEBITED("DepositCorrectionDebited"),
        FEE("Fee"),
        FUNDTRANSFER("FundTransfer"),
        FUNDTRANSFERREVERSED("FundTransferReversed"),
        INVOICEDEDUCTIONCREDITED("InvoiceDeductionCredited"),
        INVOICEDEDUCTIONDEBITED("InvoiceDeductionDebited"),
        MANUALCORRECTED("ManualCorrected"),
        MANUALCORRECTIONCREDITED("ManualCorrectionCredited"),
        MANUALCORRECTIONDEBITED("ManualCorrectionDebited"),
        MERCHANTPAYIN("MerchantPayin"),
        MERCHANTPAYINREVERSED("MerchantPayinReversed"),
        PAYOUT("Payout"),
        PAYOUTREVERSED("PayoutReversed"),
        PENDINGCREDIT("PendingCredit"),
        PENDINGDEBIT("PendingDebit"),
        PENDINGFUNDTRANSFER("PendingFundTransfer"),
        RECREDITED("ReCredited"),
        RECREDITEDRECEIVED("ReCreditedReceived"),
        SECONDCHARGEBACK("SecondChargeback"),
        SECONDCHARGEBACKCORRECTION("SecondChargebackCorrection"),
        SECONDCHARGEBACKCORRECTIONRECEIVED("SecondChargebackCorrectionReceived"),
        SECONDCHARGEBACKRECEIVED("SecondChargebackReceived");

        private String value;

        private TransactionStatusesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransactionStatusesEnum fromValue(String value) {
            for (TransactionStatusesEnum b : TransactionStatusesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

