/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"businessLineId", "storeCode", "storeId", "storeReference"})
public class MigratedStores {
    public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
    private String businessLineId;
    public static final String JSON_PROPERTY_STORE_CODE = "storeCode";
    private String storeCode;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;
    public static final String JSON_PROPERTY_STORE_REFERENCE = "storeReference";
    private String storeReference;

    public MigratedStores businessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the business line associated with the migrated account holder in the balance platform.")
    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessLineId() {
        return this.businessLineId;
    }

    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
    }

    public MigratedStores storeCode(String storeCode) {
        this.storeCode = storeCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store associated with the migrated account holder in the classic integration.")
    @JsonProperty(value="storeCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreCode() {
        return this.storeCode;
    }

    @JsonProperty(value="storeCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public MigratedStores storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store associated with the migrated account holder in the balance platform.")
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public MigratedStores storeReference(String storeReference) {
        this.storeReference = storeReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the store in the classic integration. The [Customer Area](https://ca-test.adyen.com/) uses this value for the store description.")
    @JsonProperty(value="storeReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreReference() {
        return this.storeReference;
    }

    @JsonProperty(value="storeReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreReference(String storeReference) {
        this.storeReference = storeReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigratedStores migratedStores = (MigratedStores)o;
        return Objects.equals(this.businessLineId, migratedStores.businessLineId) && Objects.equals(this.storeCode, migratedStores.storeCode) && Objects.equals(this.storeId, migratedStores.storeId) && Objects.equals(this.storeReference, migratedStores.storeReference);
    }

    public int hashCode() {
        return Objects.hash(this.businessLineId, this.storeCode, this.storeId, this.storeReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigratedStores {\n");
        sb.append("    businessLineId: ").append(this.toIndentedString(this.businessLineId)).append("\n");
        sb.append("    storeCode: ").append(this.toIndentedString(this.storeCode)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    storeReference: ").append(this.toIndentedString(this.storeReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MigratedStores fromJson(String jsonString) throws JsonProcessingException {
        return (MigratedStores)JSON.getMapper().readValue(jsonString, MigratedStores.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

