/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.disputes;

import com.adyen.model.disputes.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"defenseReasonCode", "disputePspReference", "merchantAccountCode"})
public class DefendDisputeRequest {
    public static final String JSON_PROPERTY_DEFENSE_REASON_CODE = "defenseReasonCode";
    private String defenseReasonCode;
    public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
    private String disputePspReference;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
    private String merchantAccountCode;

    public DefendDisputeRequest defenseReasonCode(String defenseReasonCode) {
        this.defenseReasonCode = defenseReasonCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The defense reason code that was selected to defend this dispute.")
    @JsonProperty(value="defenseReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefenseReasonCode() {
        return this.defenseReasonCode;
    }

    @JsonProperty(value="defenseReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefenseReasonCode(String defenseReasonCode) {
        this.defenseReasonCode = defenseReasonCode;
    }

    public DefendDisputeRequest disputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The PSP reference assigned to the dispute.")
    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisputePspReference() {
        return this.disputePspReference;
    }

    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
    }

    public DefendDisputeRequest merchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, for which you want to process the dispute transaction.")
    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccountCode() {
        return this.merchantAccountCode;
    }

    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefendDisputeRequest defendDisputeRequest = (DefendDisputeRequest)o;
        return Objects.equals(this.defenseReasonCode, defendDisputeRequest.defenseReasonCode) && Objects.equals(this.disputePspReference, defendDisputeRequest.disputePspReference) && Objects.equals(this.merchantAccountCode, defendDisputeRequest.merchantAccountCode);
    }

    public int hashCode() {
        return Objects.hash(this.defenseReasonCode, this.disputePspReference, this.merchantAccountCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DefendDisputeRequest {\n");
        sb.append("    defenseReasonCode: ").append(this.toIndentedString(this.defenseReasonCode)).append("\n");
        sb.append("    disputePspReference: ").append(this.toIndentedString(this.disputePspReference)).append("\n");
        sb.append("    merchantAccountCode: ").append(this.toIndentedString(this.merchantAccountCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DefendDisputeRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DefendDisputeRequest)JSON.getMapper().readValue(jsonString, DefendDisputeRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

