/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.OperationStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "destinationAccountCode", "invalidFields", "merchantReference", "sourceAccountCode", "status", "transferCode"})
public class TransferFundsNotificationContent {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
    private String destinationAccountCode;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
    private String sourceAccountCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private OperationStatus status;
    public static final String JSON_PROPERTY_TRANSFER_CODE = "transferCode";
    private String transferCode;

    public TransferFundsNotificationContent amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferFundsNotificationContent destinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the Account to which funds were credited.")
    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountCode() {
        return this.destinationAccountCode;
    }

    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
    }

    public TransferFundsNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public TransferFundsNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Invalid fields list.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public TransferFundsNotificationContent merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The reference provided by the merchant.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public TransferFundsNotificationContent sourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the Account from which funds were debited.")
    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountCode() {
        return this.sourceAccountCode;
    }

    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
    }

    public TransferFundsNotificationContent status(OperationStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    public TransferFundsNotificationContent transferCode(String transferCode) {
        this.transferCode = transferCode;
        return this;
    }

    @ApiModelProperty(value="The transfer code.")
    @JsonProperty(value="transferCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferCode() {
        return this.transferCode;
    }

    @JsonProperty(value="transferCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferFundsNotificationContent transferFundsNotificationContent = (TransferFundsNotificationContent)o;
        return Objects.equals(this.amount, transferFundsNotificationContent.amount) && Objects.equals(this.destinationAccountCode, transferFundsNotificationContent.destinationAccountCode) && Objects.equals(this.invalidFields, transferFundsNotificationContent.invalidFields) && Objects.equals(this.merchantReference, transferFundsNotificationContent.merchantReference) && Objects.equals(this.sourceAccountCode, transferFundsNotificationContent.sourceAccountCode) && Objects.equals(this.status, transferFundsNotificationContent.status) && Objects.equals(this.transferCode, transferFundsNotificationContent.transferCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.destinationAccountCode, this.invalidFields, this.merchantReference, this.sourceAccountCode, this.status, this.transferCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferFundsNotificationContent {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    destinationAccountCode: ").append(this.toIndentedString(this.destinationAccountCode)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    sourceAccountCode: ").append(this.toIndentedString(this.sourceAccountCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transferCode: ").append(this.toIndentedString(this.transferCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferFundsNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (TransferFundsNotificationContent)JSON.getMapper().readValue(jsonString, TransferFundsNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

