/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.RegisterSCAFinalResponse;
import com.adyen.model.balanceplatform.RegisterSCARequest;
import com.adyen.model.balanceplatform.RegisterSCAResponse;
import com.adyen.model.balanceplatform.SearchRegisteredDevicesResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ManageScaDevicesApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public ManageScaDevicesApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public ManageScaDevicesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public RegisterSCAFinalResponse completeRegistrationOfScaDevice(String id, RegisterSCARequest registerSCARequest) throws ApiException, IOException {
        return this.completeRegistrationOfScaDevice(id, registerSCARequest, null);
    }

    public RegisterSCAFinalResponse completeRegistrationOfScaDevice(String id, RegisterSCARequest registerSCARequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = registerSCARequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/registeredDevices/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return RegisterSCAFinalResponse.fromJson(jsonResult);
    }

    public void deleteRegistrationOfScaDevice(String id, String paymentInstrumentId) throws ApiException, IOException {
        this.deleteRegistrationOfScaDevice(id, paymentInstrumentId, null);
    }

    public void deleteRegistrationOfScaDevice(String id, String paymentInstrumentId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (paymentInstrumentId != null) {
            queryParams.put("paymentInstrumentId", paymentInstrumentId);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/registeredDevices/{id}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams, queryParams);
    }

    public RegisterSCAResponse initiateRegistrationOfScaDevice(RegisterSCARequest registerSCARequest) throws ApiException, IOException {
        return this.initiateRegistrationOfScaDevice(registerSCARequest, null);
    }

    public RegisterSCAResponse initiateRegistrationOfScaDevice(RegisterSCARequest registerSCARequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = registerSCARequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/registeredDevices", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return RegisterSCAResponse.fromJson(jsonResult);
    }

    public SearchRegisteredDevicesResponse listRegisteredScaDevices(String paymentInstrumentId) throws ApiException, IOException {
        return this.listRegisteredScaDevices(paymentInstrumentId, null, null, null);
    }

    public SearchRegisteredDevicesResponse listRegisteredScaDevices(String paymentInstrumentId, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (paymentInstrumentId != null) {
            queryParams.put("paymentInstrumentId", paymentInstrumentId);
        }
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/registeredDevices", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return SearchRegisteredDevicesResponse.fromJson(jsonResult);
    }
}

