/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "status"})
public class SessionResultResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public SessionResultResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique identifier of the session.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SessionResultResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the session. The status included in the response doesn't get updated. Don't make the request again to check for payment status updates.  Possible values:           * **completed** \u2013 The shopper completed the payment. This means that the payment was authorized.          * **paymentPending** \u2013 The shopper is in the process of making the payment. This applies to payment methods with an asynchronous flow.          * **refused** \u2013 The session has been refused, due to too many refused payment attempts. Shoppers can no longer complete the payment with this session.          * **canceled** \u2013 The shopper canceled the payment.          * **active** \u2013 The session is still active and can be paid.          * **expired** \u2013 The session expired (default: 1 hour after session creation). Shoppers can no longer complete the payment with this session. ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionResultResponse sessionResultResponse = (SessionResultResponse)o;
        return Objects.equals(this.id, sessionResultResponse.id) && Objects.equals((Object)this.status, (Object)sessionResultResponse.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionResultResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SessionResultResponse fromJson(String jsonString) throws JsonProcessingException {
        return (SessionResultResponse)JSON.getMapper().readValue(jsonString, SessionResultResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        CANCELED("canceled"),
        COMPLETED("completed"),
        EXPIRED("expired"),
        PAYMENTPENDING("paymentPending"),
        REFUSED("refused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

