/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"allow3DS2", "challengeWindowSize", "executeThreeD", "mpiImplementationType", "scaExemption", "threeDSVersion"})
public class AdditionalData3DSecure {
    public static final String JSON_PROPERTY_ALLOW3_D_S2 = "allow3DS2";
    @Deprecated
    private String allow3DS2;
    public static final String JSON_PROPERTY_CHALLENGE_WINDOW_SIZE = "challengeWindowSize";
    private ChallengeWindowSizeEnum challengeWindowSize;
    public static final String JSON_PROPERTY_EXECUTE_THREE_D = "executeThreeD";
    @Deprecated
    private String executeThreeD;
    public static final String JSON_PROPERTY_MPI_IMPLEMENTATION_TYPE = "mpiImplementationType";
    private String mpiImplementationType;
    public static final String JSON_PROPERTY_SCA_EXEMPTION = "scaExemption";
    private String scaExemption;
    public static final String JSON_PROPERTY_THREE_D_S_VERSION = "threeDSVersion";
    private String threeDSVersion;

    @Deprecated
    public AdditionalData3DSecure allow3DS2(String allow3DS2) {
        this.allow3DS2 = allow3DS2;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Indicates if you are able to process 3D Secure 2 transactions natively on your payment page. Send this parameter when you are using `/payments` endpoint with any of our [native 3D Secure 2 solutions](https://docs.adyen.com/online-payments/3d-secure/native-3ds2).   > This parameter only indicates readiness to support native 3D Secure 2 authentication. To specify if you _want_ to perform 3D Secure, use [Dynamic 3D Secure](/risk-management/dynamic-3d-secure) or send the `executeThreeD` parameter.  Possible values: * **true** - Ready to support native 3D Secure 2 authentication. Setting this to true does not mean always applying 3D Secure 2. Adyen selects redirect or native authentication based on your configuration to optimize authorization rates and improve the shopper's experience. * **false** \u2013 Not ready to support native 3D Secure 2 authentication. Adyen offers redirect 3D Secure 2 authentication instead, based on your configuration. ")
    @JsonProperty(value="allow3DS2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAllow3DS2() {
        return this.allow3DS2;
    }

    @Deprecated
    @JsonProperty(value="allow3DS2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllow3DS2(String allow3DS2) {
        this.allow3DS2 = allow3DS2;
    }

    public AdditionalData3DSecure challengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
        return this;
    }

    @ApiModelProperty(value="Dimensions of the 3DS2 challenge window to be displayed to the cardholder.  Possible values:  * **01** - size of 250x400  * **02** - size of 390x400 * **03** - size of 500x600 * **04** - size of 600x400 * **05** - Fullscreen")
    @JsonProperty(value="challengeWindowSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChallengeWindowSizeEnum getChallengeWindowSize() {
        return this.challengeWindowSize;
    }

    @JsonProperty(value="challengeWindowSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChallengeWindowSize(ChallengeWindowSizeEnum challengeWindowSize) {
        this.challengeWindowSize = challengeWindowSize;
    }

    @Deprecated
    public AdditionalData3DSecure executeThreeD(String executeThreeD) {
        this.executeThreeD = executeThreeD;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Indicates if you want to perform 3D Secure authentication on a transaction.   > Alternatively, you can use [Dynamic 3D Secure](/risk-management/dynamic-3d-secure) to configure rules for applying 3D Secure.  Possible values: * **true** \u2013 Perform 3D Secure authentication. * **false** \u2013 Don't perform 3D Secure authentication. Note that this setting results in refusals if the issuer mandates 3D Secure because of the PSD2 directive  or other, national regulations.  ")
    @JsonProperty(value="executeThreeD")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExecuteThreeD() {
        return this.executeThreeD;
    }

    @Deprecated
    @JsonProperty(value="executeThreeD")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecuteThreeD(String executeThreeD) {
        this.executeThreeD = executeThreeD;
    }

    public AdditionalData3DSecure mpiImplementationType(String mpiImplementationType) {
        this.mpiImplementationType = mpiImplementationType;
        return this;
    }

    @ApiModelProperty(value="In case of Secure+, this field must be set to **CUPSecurePlus**.")
    @JsonProperty(value="mpiImplementationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMpiImplementationType() {
        return this.mpiImplementationType;
    }

    @JsonProperty(value="mpiImplementationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMpiImplementationType(String mpiImplementationType) {
        this.mpiImplementationType = mpiImplementationType;
    }

    public AdditionalData3DSecure scaExemption(String scaExemption) {
        this.scaExemption = scaExemption;
        return this;
    }

    @ApiModelProperty(value="Indicates the [exemption type](https://docs.adyen.com/payments-fundamentals/psd2-sca-compliance-and-implementation-guide#specifypreferenceinyourapirequest) that you want to request for the transaction.   Possible values: * **lowValue**  * **secureCorporate**  * **trustedBeneficiary**  * **transactionRiskAnalysis** ")
    @JsonProperty(value="scaExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScaExemption() {
        return this.scaExemption;
    }

    @JsonProperty(value="scaExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScaExemption(String scaExemption) {
        this.scaExemption = scaExemption;
    }

    public AdditionalData3DSecure threeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @ApiModelProperty(value="Indicates your preference for the 3D Secure version.  > If you use this parameter, you override the checks from Adyen's Authentication Engine. We recommend to use this field only if you have an extensive knowledge of 3D Secure.  Possible values: * **1.0.2**: Apply 3D Secure version 1.0.2.  * **2.1.0**: Apply 3D Secure version 2.1.0.  * **2.2.0**: Apply 3D Secure version 2.2.0. If the issuer does not support version 2.2.0, we will fall back to 2.1.0.  The following rules apply: * If you prefer 2.1.0 or 2.2.0 but we receive a negative `transStatus` in the `ARes`, we will apply the fallback policy configured in your account. For example, if the configuration is to fall back to 3D Secure 1, we will apply version 1.0.2. * If you prefer 2.1.0 or 2.2.0 but the BIN is not enrolled, you will receive an error.  ")
    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSVersion() {
        return this.threeDSVersion;
    }

    @JsonProperty(value="threeDSVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalData3DSecure additionalData3DSecure = (AdditionalData3DSecure)o;
        return Objects.equals(this.allow3DS2, additionalData3DSecure.allow3DS2) && Objects.equals((Object)this.challengeWindowSize, (Object)additionalData3DSecure.challengeWindowSize) && Objects.equals(this.executeThreeD, additionalData3DSecure.executeThreeD) && Objects.equals(this.mpiImplementationType, additionalData3DSecure.mpiImplementationType) && Objects.equals(this.scaExemption, additionalData3DSecure.scaExemption) && Objects.equals(this.threeDSVersion, additionalData3DSecure.threeDSVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allow3DS2, this.challengeWindowSize, this.executeThreeD, this.mpiImplementationType, this.scaExemption, this.threeDSVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalData3DSecure {\n");
        sb.append("    allow3DS2: ").append(this.toIndentedString(this.allow3DS2)).append("\n");
        sb.append("    challengeWindowSize: ").append(this.toIndentedString((Object)this.challengeWindowSize)).append("\n");
        sb.append("    executeThreeD: ").append(this.toIndentedString(this.executeThreeD)).append("\n");
        sb.append("    mpiImplementationType: ").append(this.toIndentedString(this.mpiImplementationType)).append("\n");
        sb.append("    scaExemption: ").append(this.toIndentedString(this.scaExemption)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString(this.threeDSVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AdditionalData3DSecure fromJson(String jsonString) throws JsonProcessingException {
        return (AdditionalData3DSecure)JSON.getMapper().readValue(jsonString, AdditionalData3DSecure.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ChallengeWindowSizeEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05");

        private String value;

        private ChallengeWindowSizeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChallengeWindowSizeEnum fromValue(String value) {
            for (ChallengeWindowSizeEnum b : ChallengeWindowSizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

