/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.notification;

import com.adyen.model.acswebhooks.AuthenticationNotificationRequest;
import com.adyen.model.configurationwebhooks.AccountHolderNotificationRequest;
import com.adyen.model.configurationwebhooks.BalanceAccountNotificationRequest;
import com.adyen.model.configurationwebhooks.CardOrderNotificationRequest;
import com.adyen.model.configurationwebhooks.PaymentNotificationRequest;
import com.adyen.model.configurationwebhooks.SweepConfigurationNotificationRequest;
import com.adyen.model.reportwebhooks.ReportNotificationRequest;
import com.adyen.model.transactionwebhooks.TransactionNotificationRequestV4;
import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.TransferNotificationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class BankingWebhookHandler {
    private static final Logger LOG = Logger.getLogger(BankingWebhookHandler.class.getName());
    private final String payload;

    public BankingWebhookHandler(String payload) {
        this.payload = payload;
    }

    public Optional<AuthenticationNotificationRequest> getAuthenticationNotificationRequest() {
        return this.getOptionalField(AuthenticationNotificationRequest.class);
    }

    public Optional<AccountHolderNotificationRequest> getAccountHolderNotificationRequest() {
        return this.getOptionalField(AccountHolderNotificationRequest.class);
    }

    public Optional<BalanceAccountNotificationRequest> getBalanceAccountNotificationRequest() {
        return this.getOptionalField(BalanceAccountNotificationRequest.class);
    }

    public Optional<CardOrderNotificationRequest> getCardOrderNotificationRequest() {
        return this.getOptionalField(CardOrderNotificationRequest.class);
    }

    public Optional<PaymentNotificationRequest> getPaymentNotificationRequest() {
        return this.getOptionalField(PaymentNotificationRequest.class);
    }

    public Optional<SweepConfigurationNotificationRequest> getSweepConfigurationNotificationRequest() {
        return this.getOptionalField(SweepConfigurationNotificationRequest.class);
    }

    public Optional<ReportNotificationRequest> getReportNotificationRequest() {
        return this.getOptionalField(ReportNotificationRequest.class);
    }

    public Optional<TransferNotificationRequest> getTransferNotificationRequest() {
        return this.getOptionalField(TransferNotificationRequest.class);
    }

    public Optional<TransactionNotificationRequestV4> getTransactionNotificationRequest() {
        return this.getOptionalField(TransactionNotificationRequestV4.class);
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

