/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"chAccAgeInd", "chAccChange", "chAccChangeInd", "chAccPwChange", "chAccPwChangeInd", "chAccString", "nbPurchaseAccount", "paymentAccAge", "paymentAccInd", "provisionAttemptsDay", "shipAddressUsage", "shipAddressUsageInd", "shipNameIndicator", "suspiciousAccActivity", "txnActivityDay", "txnActivityYear"})
public class AcctInfo {
    public static final String JSON_PROPERTY_CH_ACC_AGE_IND = "chAccAgeInd";
    private ChAccAgeIndEnum chAccAgeInd;
    public static final String JSON_PROPERTY_CH_ACC_CHANGE = "chAccChange";
    private String chAccChange;
    public static final String JSON_PROPERTY_CH_ACC_CHANGE_IND = "chAccChangeInd";
    private ChAccChangeIndEnum chAccChangeInd;
    public static final String JSON_PROPERTY_CH_ACC_PW_CHANGE = "chAccPwChange";
    private String chAccPwChange;
    public static final String JSON_PROPERTY_CH_ACC_PW_CHANGE_IND = "chAccPwChangeInd";
    private ChAccPwChangeIndEnum chAccPwChangeInd;
    public static final String JSON_PROPERTY_CH_ACC_STRING = "chAccString";
    private String chAccString;
    public static final String JSON_PROPERTY_NB_PURCHASE_ACCOUNT = "nbPurchaseAccount";
    private String nbPurchaseAccount;
    public static final String JSON_PROPERTY_PAYMENT_ACC_AGE = "paymentAccAge";
    private String paymentAccAge;
    public static final String JSON_PROPERTY_PAYMENT_ACC_IND = "paymentAccInd";
    private PaymentAccIndEnum paymentAccInd;
    public static final String JSON_PROPERTY_PROVISION_ATTEMPTS_DAY = "provisionAttemptsDay";
    private String provisionAttemptsDay;
    public static final String JSON_PROPERTY_SHIP_ADDRESS_USAGE = "shipAddressUsage";
    private String shipAddressUsage;
    public static final String JSON_PROPERTY_SHIP_ADDRESS_USAGE_IND = "shipAddressUsageInd";
    private ShipAddressUsageIndEnum shipAddressUsageInd;
    public static final String JSON_PROPERTY_SHIP_NAME_INDICATOR = "shipNameIndicator";
    private ShipNameIndicatorEnum shipNameIndicator;
    public static final String JSON_PROPERTY_SUSPICIOUS_ACC_ACTIVITY = "suspiciousAccActivity";
    private SuspiciousAccActivityEnum suspiciousAccActivity;
    public static final String JSON_PROPERTY_TXN_ACTIVITY_DAY = "txnActivityDay";
    private String txnActivityDay;
    public static final String JSON_PROPERTY_TXN_ACTIVITY_YEAR = "txnActivityYear";
    private String txnActivityYear;

    public AcctInfo chAccAgeInd(ChAccAgeIndEnum chAccAgeInd) {
        this.chAccAgeInd = chAccAgeInd;
        return this;
    }

    @ApiModelProperty(value="Length of time that the cardholder has had the account with the 3DS Requestor.  Allowed values: * **01** \u2014 No account * **02** \u2014 Created during this transaction * **03** \u2014 Less than 30 days * **04** \u2014 30\u201360 days * **05** \u2014 More than 60 days")
    @JsonProperty(value="chAccAgeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChAccAgeIndEnum getChAccAgeInd() {
        return this.chAccAgeInd;
    }

    @JsonProperty(value="chAccAgeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChAccAgeInd(ChAccAgeIndEnum chAccAgeInd) {
        this.chAccAgeInd = chAccAgeInd;
    }

    public AcctInfo chAccChange(String chAccChange) {
        this.chAccChange = chAccChange;
        return this;
    }

    @ApiModelProperty(value="Date that the cardholder\u2019s account with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Format: **YYYYMMDD**")
    @JsonProperty(value="chAccChange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChAccChange() {
        return this.chAccChange;
    }

    @JsonProperty(value="chAccChange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChAccChange(String chAccChange) {
        this.chAccChange = chAccChange;
    }

    public AcctInfo chAccChangeInd(ChAccChangeIndEnum chAccChangeInd) {
        this.chAccChangeInd = chAccChangeInd;
        return this;
    }

    @ApiModelProperty(value="Length of time since the cardholder\u2019s account information with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Allowed values: * **01** \u2014 Changed during this transaction * **02** \u2014 Less than 30 days * **03** \u2014 30\u201360 days * **04** \u2014 More than 60 days")
    @JsonProperty(value="chAccChangeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChAccChangeIndEnum getChAccChangeInd() {
        return this.chAccChangeInd;
    }

    @JsonProperty(value="chAccChangeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChAccChangeInd(ChAccChangeIndEnum chAccChangeInd) {
        this.chAccChangeInd = chAccChangeInd;
    }

    public AcctInfo chAccPwChange(String chAccPwChange) {
        this.chAccPwChange = chAccPwChange;
        return this;
    }

    @ApiModelProperty(value="Date that cardholder\u2019s account with the 3DS Requestor had a password change or account reset.  Format: **YYYYMMDD**")
    @JsonProperty(value="chAccPwChange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChAccPwChange() {
        return this.chAccPwChange;
    }

    @JsonProperty(value="chAccPwChange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChAccPwChange(String chAccPwChange) {
        this.chAccPwChange = chAccPwChange;
    }

    public AcctInfo chAccPwChangeInd(ChAccPwChangeIndEnum chAccPwChangeInd) {
        this.chAccPwChangeInd = chAccPwChangeInd;
        return this;
    }

    @ApiModelProperty(value="Indicates the length of time since the cardholder\u2019s account with the 3DS Requestor had a password change or account reset.  Allowed values: * **01** \u2014 No change * **02** \u2014 Changed during this transaction * **03** \u2014 Less than 30 days * **04** \u2014 30\u201360 days * **05** \u2014 More than 60 days")
    @JsonProperty(value="chAccPwChangeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChAccPwChangeIndEnum getChAccPwChangeInd() {
        return this.chAccPwChangeInd;
    }

    @JsonProperty(value="chAccPwChangeInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChAccPwChangeInd(ChAccPwChangeIndEnum chAccPwChangeInd) {
        this.chAccPwChangeInd = chAccPwChangeInd;
    }

    public AcctInfo chAccString(String chAccString) {
        this.chAccString = chAccString;
        return this;
    }

    @ApiModelProperty(value="Date that the cardholder opened the account with the 3DS Requestor.  Format: **YYYYMMDD**")
    @JsonProperty(value="chAccString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChAccString() {
        return this.chAccString;
    }

    @JsonProperty(value="chAccString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChAccString(String chAccString) {
        this.chAccString = chAccString;
    }

    public AcctInfo nbPurchaseAccount(String nbPurchaseAccount) {
        this.nbPurchaseAccount = nbPurchaseAccount;
        return this;
    }

    @ApiModelProperty(value="Number of purchases with this cardholder account during the previous six months. Max length: 4 characters.")
    @JsonProperty(value="nbPurchaseAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNbPurchaseAccount() {
        return this.nbPurchaseAccount;
    }

    @JsonProperty(value="nbPurchaseAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNbPurchaseAccount(String nbPurchaseAccount) {
        this.nbPurchaseAccount = nbPurchaseAccount;
    }

    public AcctInfo paymentAccAge(String paymentAccAge) {
        this.paymentAccAge = paymentAccAge;
        return this;
    }

    @ApiModelProperty(value="String that the payment account was enrolled in the cardholder\u2019s account with the 3DS Requestor.  Format: **YYYYMMDD**")
    @JsonProperty(value="paymentAccAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentAccAge() {
        return this.paymentAccAge;
    }

    @JsonProperty(value="paymentAccAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentAccAge(String paymentAccAge) {
        this.paymentAccAge = paymentAccAge;
    }

    public AcctInfo paymentAccInd(PaymentAccIndEnum paymentAccInd) {
        this.paymentAccInd = paymentAccInd;
        return this;
    }

    @ApiModelProperty(value="Indicates the length of time that the payment account was enrolled in the cardholder\u2019s account with the 3DS Requestor.  Allowed values: * **01** \u2014 No account (guest checkout) * **02** \u2014 During this transaction * **03** \u2014 Less than 30 days * **04** \u2014 30\u201360 days * **05** \u2014 More than 60 days")
    @JsonProperty(value="paymentAccInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAccIndEnum getPaymentAccInd() {
        return this.paymentAccInd;
    }

    @JsonProperty(value="paymentAccInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentAccInd(PaymentAccIndEnum paymentAccInd) {
        this.paymentAccInd = paymentAccInd;
    }

    public AcctInfo provisionAttemptsDay(String provisionAttemptsDay) {
        this.provisionAttemptsDay = provisionAttemptsDay;
        return this;
    }

    @ApiModelProperty(value="Number of Add Card attempts in the last 24 hours. Max length: 3 characters.")
    @JsonProperty(value="provisionAttemptsDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProvisionAttemptsDay() {
        return this.provisionAttemptsDay;
    }

    @JsonProperty(value="provisionAttemptsDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvisionAttemptsDay(String provisionAttemptsDay) {
        this.provisionAttemptsDay = provisionAttemptsDay;
    }

    public AcctInfo shipAddressUsage(String shipAddressUsage) {
        this.shipAddressUsage = shipAddressUsage;
        return this;
    }

    @ApiModelProperty(value="String when the shipping address used for this transaction was first used with the 3DS Requestor.  Format: **YYYYMMDD**")
    @JsonProperty(value="shipAddressUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShipAddressUsage() {
        return this.shipAddressUsage;
    }

    @JsonProperty(value="shipAddressUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShipAddressUsage(String shipAddressUsage) {
        this.shipAddressUsage = shipAddressUsage;
    }

    public AcctInfo shipAddressUsageInd(ShipAddressUsageIndEnum shipAddressUsageInd) {
        this.shipAddressUsageInd = shipAddressUsageInd;
        return this;
    }

    @ApiModelProperty(value="Indicates when the shipping address used for this transaction was first used with the 3DS Requestor.  Allowed values: * **01** \u2014 This transaction * **02** \u2014 Less than 30 days * **03** \u2014 30\u201360 days * **04** \u2014 More than 60 days")
    @JsonProperty(value="shipAddressUsageInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShipAddressUsageIndEnum getShipAddressUsageInd() {
        return this.shipAddressUsageInd;
    }

    @JsonProperty(value="shipAddressUsageInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShipAddressUsageInd(ShipAddressUsageIndEnum shipAddressUsageInd) {
        this.shipAddressUsageInd = shipAddressUsageInd;
    }

    public AcctInfo shipNameIndicator(ShipNameIndicatorEnum shipNameIndicator) {
        this.shipNameIndicator = shipNameIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates if the Cardholder Name on the account is identical to the shipping Name used for this transaction.  Allowed values: * **01** \u2014 Account Name identical to shipping Name * **02** \u2014 Account Name different to shipping Name")
    @JsonProperty(value="shipNameIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShipNameIndicatorEnum getShipNameIndicator() {
        return this.shipNameIndicator;
    }

    @JsonProperty(value="shipNameIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShipNameIndicator(ShipNameIndicatorEnum shipNameIndicator) {
        this.shipNameIndicator = shipNameIndicator;
    }

    public AcctInfo suspiciousAccActivity(SuspiciousAccActivityEnum suspiciousAccActivity) {
        this.suspiciousAccActivity = suspiciousAccActivity;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the 3DS Requestor has experienced suspicious activity (including previous fraud) on the cardholder account.  Allowed values: * **01** \u2014 No suspicious activity has been observed * **02** \u2014 Suspicious activity has been observed")
    @JsonProperty(value="suspiciousAccActivity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SuspiciousAccActivityEnum getSuspiciousAccActivity() {
        return this.suspiciousAccActivity;
    }

    @JsonProperty(value="suspiciousAccActivity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuspiciousAccActivity(SuspiciousAccActivityEnum suspiciousAccActivity) {
        this.suspiciousAccActivity = suspiciousAccActivity;
    }

    public AcctInfo txnActivityDay(String txnActivityDay) {
        this.txnActivityDay = txnActivityDay;
        return this;
    }

    @ApiModelProperty(value="Number of transactions (successful and abandoned) for this cardholder account with the 3DS Requestor across all payment accounts in the previous 24 hours. Max length: 3 characters.")
    @JsonProperty(value="txnActivityDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxnActivityDay() {
        return this.txnActivityDay;
    }

    @JsonProperty(value="txnActivityDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxnActivityDay(String txnActivityDay) {
        this.txnActivityDay = txnActivityDay;
    }

    public AcctInfo txnActivityYear(String txnActivityYear) {
        this.txnActivityYear = txnActivityYear;
        return this;
    }

    @ApiModelProperty(value="Number of transactions (successful and abandoned) for this cardholder account with the 3DS Requestor across all payment accounts in the previous year. Max length: 3 characters.")
    @JsonProperty(value="txnActivityYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxnActivityYear() {
        return this.txnActivityYear;
    }

    @JsonProperty(value="txnActivityYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxnActivityYear(String txnActivityYear) {
        this.txnActivityYear = txnActivityYear;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcctInfo acctInfo = (AcctInfo)o;
        return Objects.equals((Object)this.chAccAgeInd, (Object)acctInfo.chAccAgeInd) && Objects.equals(this.chAccChange, acctInfo.chAccChange) && Objects.equals((Object)this.chAccChangeInd, (Object)acctInfo.chAccChangeInd) && Objects.equals(this.chAccPwChange, acctInfo.chAccPwChange) && Objects.equals((Object)this.chAccPwChangeInd, (Object)acctInfo.chAccPwChangeInd) && Objects.equals(this.chAccString, acctInfo.chAccString) && Objects.equals(this.nbPurchaseAccount, acctInfo.nbPurchaseAccount) && Objects.equals(this.paymentAccAge, acctInfo.paymentAccAge) && Objects.equals((Object)this.paymentAccInd, (Object)acctInfo.paymentAccInd) && Objects.equals(this.provisionAttemptsDay, acctInfo.provisionAttemptsDay) && Objects.equals(this.shipAddressUsage, acctInfo.shipAddressUsage) && Objects.equals((Object)this.shipAddressUsageInd, (Object)acctInfo.shipAddressUsageInd) && Objects.equals((Object)this.shipNameIndicator, (Object)acctInfo.shipNameIndicator) && Objects.equals((Object)this.suspiciousAccActivity, (Object)acctInfo.suspiciousAccActivity) && Objects.equals(this.txnActivityDay, acctInfo.txnActivityDay) && Objects.equals(this.txnActivityYear, acctInfo.txnActivityYear);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chAccAgeInd, this.chAccChange, this.chAccChangeInd, this.chAccPwChange, this.chAccPwChangeInd, this.chAccString, this.nbPurchaseAccount, this.paymentAccAge, this.paymentAccInd, this.provisionAttemptsDay, this.shipAddressUsage, this.shipAddressUsageInd, this.shipNameIndicator, this.suspiciousAccActivity, this.txnActivityDay, this.txnActivityYear});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcctInfo {\n");
        sb.append("    chAccAgeInd: ").append(this.toIndentedString((Object)this.chAccAgeInd)).append("\n");
        sb.append("    chAccChange: ").append(this.toIndentedString(this.chAccChange)).append("\n");
        sb.append("    chAccChangeInd: ").append(this.toIndentedString((Object)this.chAccChangeInd)).append("\n");
        sb.append("    chAccPwChange: ").append(this.toIndentedString(this.chAccPwChange)).append("\n");
        sb.append("    chAccPwChangeInd: ").append(this.toIndentedString((Object)this.chAccPwChangeInd)).append("\n");
        sb.append("    chAccString: ").append(this.toIndentedString(this.chAccString)).append("\n");
        sb.append("    nbPurchaseAccount: ").append(this.toIndentedString(this.nbPurchaseAccount)).append("\n");
        sb.append("    paymentAccAge: ").append(this.toIndentedString(this.paymentAccAge)).append("\n");
        sb.append("    paymentAccInd: ").append(this.toIndentedString((Object)this.paymentAccInd)).append("\n");
        sb.append("    provisionAttemptsDay: ").append(this.toIndentedString(this.provisionAttemptsDay)).append("\n");
        sb.append("    shipAddressUsage: ").append(this.toIndentedString(this.shipAddressUsage)).append("\n");
        sb.append("    shipAddressUsageInd: ").append(this.toIndentedString((Object)this.shipAddressUsageInd)).append("\n");
        sb.append("    shipNameIndicator: ").append(this.toIndentedString((Object)this.shipNameIndicator)).append("\n");
        sb.append("    suspiciousAccActivity: ").append(this.toIndentedString((Object)this.suspiciousAccActivity)).append("\n");
        sb.append("    txnActivityDay: ").append(this.toIndentedString(this.txnActivityDay)).append("\n");
        sb.append("    txnActivityYear: ").append(this.toIndentedString(this.txnActivityYear)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AcctInfo fromJson(String jsonString) throws JsonProcessingException {
        return (AcctInfo)JSON.getMapper().readValue(jsonString, AcctInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum SuspiciousAccActivityEnum {
        _01("01"),
        _02("02");

        private String value;

        private SuspiciousAccActivityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SuspiciousAccActivityEnum fromValue(String value) {
            for (SuspiciousAccActivityEnum b : SuspiciousAccActivityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ShipNameIndicatorEnum {
        _01("01"),
        _02("02");

        private String value;

        private ShipNameIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShipNameIndicatorEnum fromValue(String value) {
            for (ShipNameIndicatorEnum b : ShipNameIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ShipAddressUsageIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04");

        private String value;

        private ShipAddressUsageIndEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShipAddressUsageIndEnum fromValue(String value) {
            for (ShipAddressUsageIndEnum b : ShipAddressUsageIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentAccIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05");

        private String value;

        private PaymentAccIndEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentAccIndEnum fromValue(String value) {
            for (PaymentAccIndEnum b : PaymentAccIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChAccPwChangeIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05");

        private String value;

        private ChAccPwChangeIndEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChAccPwChangeIndEnum fromValue(String value) {
            for (ChAccPwChangeIndEnum b : ChAccPwChangeIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChAccChangeIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04");

        private String value;

        private ChAccChangeIndEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChAccChangeIndEnum fromValue(String value) {
            for (ChAccChangeIndEnum b : ChAccChangeIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChAccAgeIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05");

        private String value;

        private ChAccAgeIndEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChAccAgeIndEnum fromValue(String value) {
            for (ChAccAgeIndEnum b : ChAccAgeIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

