/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "accountType", "formFactor", "iban", "routingNumber", "sortCode", "type"})
public class BankAccountDetails {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    private String accountType;
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private String formFactor;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_SORT_CODE = "sortCode";
    private String sortCode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public BankAccountDetails accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account number, without separators or whitespace.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BankAccountDetails accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.")
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public BankAccountDetails formFactor(String formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(value="Business accounts with a `formFactor` value of **physical** are business accounts issued under the central bank of that country. The default value is **physical** for NL, US, and UK business accounts.   Adyen creates a local IBAN for business accounts when the `formFactor` value is set to **virtual**. The local IBANs that are supported are for DE and FR, which reference a physical NL account, with funds being routed through the central bank of NL.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(String formFactor) {
        this.formFactor = formFactor;
    }

    public BankAccountDetails iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The international bank account number as defined in the [ISO-13616](https://www.iso.org/standard/81090.html) standard.")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIban(String iban) {
        this.iban = iban;
    }

    public BankAccountDetails routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @ApiModelProperty(value="The [routing number](https://en.wikipedia.org/wiki/ABA_routing_transit_number), without separators or whitespace.")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public BankAccountDetails sortCode(String sortCode) {
        this.sortCode = sortCode;
        return this;
    }

    @ApiModelProperty(value="The [sort code](https://en.wikipedia.org/wiki/Sort_code), without separators or whitespace.")
    @JsonProperty(value="sortCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSortCode() {
        return this.sortCode;
    }

    @JsonProperty(value="sortCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public BankAccountDetails type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**iban** or **usLocal** or **ukLocal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccountDetails bankAccountDetails = (BankAccountDetails)o;
        return Objects.equals(this.accountNumber, bankAccountDetails.accountNumber) && Objects.equals(this.accountType, bankAccountDetails.accountType) && Objects.equals(this.formFactor, bankAccountDetails.formFactor) && Objects.equals(this.iban, bankAccountDetails.iban) && Objects.equals(this.routingNumber, bankAccountDetails.routingNumber) && Objects.equals(this.sortCode, bankAccountDetails.sortCode) && Objects.equals(this.type, bankAccountDetails.type);
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.accountType, this.formFactor, this.iban, this.routingNumber, this.sortCode, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccountDetails {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString(this.formFactor)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    sortCode: ").append(this.toIndentedString(this.sortCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BankAccountDetails fromJson(String jsonString) throws JsonProcessingException {
        return (BankAccountDetails)JSON.getMapper().readValue(jsonString, BankAccountDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

