/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "bankAccountUUIDs"})
public class DeleteBankAccountRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_DS = "bankAccountUUIDs";
    private List<String> bankAccountUUIDs = new ArrayList<String>();

    public DeleteBankAccountRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the Account Holder from which to delete the Bank Account(s).")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public DeleteBankAccountRequest bankAccountUUIDs(List<String> bankAccountUUIDs) {
        this.bankAccountUUIDs = bankAccountUUIDs;
        return this;
    }

    public DeleteBankAccountRequest addBankAccountUUIDsItem(String bankAccountUUIDsItem) {
        this.bankAccountUUIDs.add(bankAccountUUIDsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The code(s) of the Bank Accounts to be deleted.")
    @JsonProperty(value="bankAccountUUIDs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBankAccountUUIDs() {
        return this.bankAccountUUIDs;
    }

    @JsonProperty(value="bankAccountUUIDs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUIDs(List<String> bankAccountUUIDs) {
        this.bankAccountUUIDs = bankAccountUUIDs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteBankAccountRequest deleteBankAccountRequest = (DeleteBankAccountRequest)o;
        return Objects.equals(this.accountHolderCode, deleteBankAccountRequest.accountHolderCode) && Objects.equals(this.bankAccountUUIDs, deleteBankAccountRequest.bankAccountUUIDs);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.bankAccountUUIDs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteBankAccountRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    bankAccountUUIDs: ").append(this.toIndentedString(this.bankAccountUUIDs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DeleteBankAccountRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DeleteBankAccountRequest)JSON.getMapper().readValue(jsonString, DeleteBankAccountRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

