/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Links;
import com.adyen.model.management.Name;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "accountGroups", "active", "apps", "email", "id", "name", "roles", "timeZoneCode", "username"})
public class CreateUserResponse {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private Links links;
    public static final String JSON_PROPERTY_ACCOUNT_GROUPS = "accountGroups";
    private List<String> accountGroups = null;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_APPS = "apps";
    private List<String> apps = null;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private Name name;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_TIME_ZONE_CODE = "timeZoneCode";
    private String timeZoneCode;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public CreateUserResponse links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Links getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Links links) {
        this.links = links;
    }

    public CreateUserResponse accountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
        return this;
    }

    public CreateUserResponse addAccountGroupsItem(String accountGroupsItem) {
        if (this.accountGroups == null) {
            this.accountGroups = new ArrayList<String>();
        }
        this.accountGroups.add(accountGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
    @JsonProperty(value="accountGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAccountGroups() {
        return this.accountGroups;
    }

    @JsonProperty(value="accountGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
    }

    public CreateUserResponse active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Indicates whether this user is active.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public CreateUserResponse apps(List<String> apps) {
        this.apps = apps;
        return this;
    }

    public CreateUserResponse addAppsItem(String appsItem) {
        if (this.apps == null) {
            this.apps = new ArrayList<String>();
        }
        this.apps.add(appsItem);
        return this;
    }

    @ApiModelProperty(value="Set of apps available to this user")
    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getApps() {
        return this.apps;
    }

    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApps(List<String> apps) {
        this.apps = apps;
    }

    public CreateUserResponse email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of the user.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public CreateUserResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the user.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CreateUserResponse name(Name name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(Name name) {
        this.name = name;
    }

    public CreateUserResponse roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateUserResponse addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CreateUserResponse timeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
    @JsonProperty(value="timeZoneCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZoneCode() {
        return this.timeZoneCode;
    }

    @JsonProperty(value="timeZoneCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
    }

    public CreateUserResponse username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The username for this user.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserResponse createUserResponse = (CreateUserResponse)o;
        return Objects.equals(this.links, createUserResponse.links) && Objects.equals(this.accountGroups, createUserResponse.accountGroups) && Objects.equals(this.active, createUserResponse.active) && Objects.equals(this.apps, createUserResponse.apps) && Objects.equals(this.email, createUserResponse.email) && Objects.equals(this.id, createUserResponse.id) && Objects.equals(this.name, createUserResponse.name) && Objects.equals(this.roles, createUserResponse.roles) && Objects.equals(this.timeZoneCode, createUserResponse.timeZoneCode) && Objects.equals(this.username, createUserResponse.username);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.accountGroups, this.active, this.apps, this.email, this.id, this.name, this.roles, this.timeZoneCode, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    accountGroups: ").append(this.toIndentedString(this.accountGroups)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    apps: ").append(this.toIndentedString(this.apps)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    timeZoneCode: ").append(this.toIndentedString(this.timeZoneCode)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateUserResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateUserResponse)JSON.getMapper().readValue(jsonString, CreateUserResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

