/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.AbstractOpenApiSchema;
import com.adyen.model.configurationwebhooks.IbanAccountIdentification;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.UKLocalAccountIdentification;
import com.adyen.model.configurationwebhooks.USLocalAccountIdentification;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=PaymentInstrumentBankAccountDeserializer.class)
@JsonSerialize(using=PaymentInstrumentBankAccountSerializer.class)
public class PaymentInstrumentBankAccount
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(PaymentInstrumentBankAccount.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public PaymentInstrumentBankAccount() {
        super("oneOf", Boolean.FALSE);
    }

    public PaymentInstrumentBankAccount(IbanAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public PaymentInstrumentBankAccount(UKLocalAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public PaymentInstrumentBankAccount(USLocalAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(IbanAccountIdentification.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UKLocalAccountIdentification.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(USLocalAccountIdentification.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be IbanAccountIdentification, UKLocalAccountIdentification, USLocalAccountIdentification");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public IbanAccountIdentification getIbanAccountIdentification() throws ClassCastException {
        return (IbanAccountIdentification)super.getActualInstance();
    }

    public UKLocalAccountIdentification getUKLocalAccountIdentification() throws ClassCastException {
        return (UKLocalAccountIdentification)super.getActualInstance();
    }

    public USLocalAccountIdentification getUSLocalAccountIdentification() throws ClassCastException {
        return (USLocalAccountIdentification)super.getActualInstance();
    }

    public static PaymentInstrumentBankAccount fromJson(String jsonString) throws IOException {
        return (PaymentInstrumentBankAccount)JSON.getMapper().readValue(jsonString, PaymentInstrumentBankAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    static {
        schemas.put("IbanAccountIdentification", (GenericType)new GenericType<IbanAccountIdentification>(){});
        schemas.put("UKLocalAccountIdentification", (GenericType)new GenericType<UKLocalAccountIdentification>(){});
        schemas.put("USLocalAccountIdentification", (GenericType)new GenericType<USLocalAccountIdentification>(){});
        JSON.registerDescendants(PaymentInstrumentBankAccount.class, Collections.unmodifiableMap(schemas));
    }

    public static class PaymentInstrumentBankAccountDeserializer
    extends StdDeserializer<PaymentInstrumentBankAccount> {
        public PaymentInstrumentBankAccountDeserializer() {
            this(PaymentInstrumentBankAccount.class);
        }

        public PaymentInstrumentBankAccountDeserializer(Class<?> vc) {
            super(vc);
        }

        public PaymentInstrumentBankAccount deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            boolean typeMatch;
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((IbanAccountIdentification.class.equals(Integer.class) || IbanAccountIdentification.class.equals(Long.class) || IbanAccountIdentification.class.equals(Float.class) || IbanAccountIdentification.class.equals(Double.class) || IbanAccountIdentification.class.equals(Boolean.class) || IbanAccountIdentification.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (IbanAccountIdentification.class.equals(Integer.class) || IbanAccountIdentification.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (IbanAccountIdentification.class.equals(Float.class) || IbanAccountIdentification.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= IbanAccountIdentification.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= IbanAccountIdentification.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                typeMatch = Arrays.stream(IbanAccountIdentification.TypeEnum.values()).anyMatch(t -> t.getValue().contains(tree.findValue("type").asText()));
                if (attemptParsing || typeMatch) {
                    deserialized = JSON.getMapper().readValue(tree.toString(), IbanAccountIdentification.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'IbanAccountIdentification'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'IbanAccountIdentification'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((UKLocalAccountIdentification.class.equals(Integer.class) || UKLocalAccountIdentification.class.equals(Long.class) || UKLocalAccountIdentification.class.equals(Float.class) || UKLocalAccountIdentification.class.equals(Double.class) || UKLocalAccountIdentification.class.equals(Boolean.class) || UKLocalAccountIdentification.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (UKLocalAccountIdentification.class.equals(Integer.class) || UKLocalAccountIdentification.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (UKLocalAccountIdentification.class.equals(Float.class) || UKLocalAccountIdentification.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= UKLocalAccountIdentification.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= UKLocalAccountIdentification.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                typeMatch = Arrays.stream(UKLocalAccountIdentification.TypeEnum.values()).anyMatch(t -> t.getValue().contains(tree.findValue("type").asText()));
                if (attemptParsing || typeMatch) {
                    deserialized = JSON.getMapper().readValue(tree.toString(), UKLocalAccountIdentification.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'UKLocalAccountIdentification'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'UKLocalAccountIdentification'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((USLocalAccountIdentification.class.equals(Integer.class) || USLocalAccountIdentification.class.equals(Long.class) || USLocalAccountIdentification.class.equals(Float.class) || USLocalAccountIdentification.class.equals(Double.class) || USLocalAccountIdentification.class.equals(Boolean.class) || USLocalAccountIdentification.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (USLocalAccountIdentification.class.equals(Integer.class) || USLocalAccountIdentification.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (USLocalAccountIdentification.class.equals(Float.class) || USLocalAccountIdentification.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= USLocalAccountIdentification.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= USLocalAccountIdentification.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                typeMatch = Arrays.stream(USLocalAccountIdentification.TypeEnum.values()).anyMatch(t -> t.getValue().contains(tree.findValue("type").asText()));
                if (attemptParsing || typeMatch) {
                    deserialized = JSON.getMapper().readValue(tree.toString(), USLocalAccountIdentification.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'USLocalAccountIdentification'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'USLocalAccountIdentification'", e);
            }
            if (match == 0) {
                throw new IOException(String.format("Failed deserialization for PaymentInstrumentBankAccount: %d classes match result, expected 1", match));
            }
            if (match > 1) {
                log.log(Level.WARNING, String.format("Warning, indecisive deserialization for PaymentInstrumentBankAccount: %d classes match result, expected 1", match));
            }
            PaymentInstrumentBankAccount ret = new PaymentInstrumentBankAccount();
            ret.setActualInstance(deserialized);
            return ret;
        }

        public PaymentInstrumentBankAccount getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "PaymentInstrumentBankAccount cannot be null");
        }
    }

    public static class PaymentInstrumentBankAccountSerializer
    extends StdSerializer<PaymentInstrumentBankAccount> {
        public PaymentInstrumentBankAccountSerializer(Class<PaymentInstrumentBankAccount> t) {
            super(t);
        }

        public PaymentInstrumentBankAccountSerializer() {
            this(null);
        }

        public void serialize(PaymentInstrumentBankAccount value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

