/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ModelConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"askConfirmation", "configurations"})
public class Surcharge {
    public static final String JSON_PROPERTY_ASK_CONFIRMATION = "askConfirmation";
    private Boolean askConfirmation;
    public static final String JSON_PROPERTY_CONFIGURATIONS = "configurations";
    private List<ModelConfiguration> configurations = null;

    public Surcharge askConfirmation(Boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
        return this;
    }

    @ApiModelProperty(value="Show the surcharge details on the terminal, so the shopper can confirm.")
    @JsonProperty(value="askConfirmation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAskConfirmation() {
        return this.askConfirmation;
    }

    @JsonProperty(value="askConfirmation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAskConfirmation(Boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
    }

    public Surcharge configurations(List<ModelConfiguration> configurations) {
        this.configurations = configurations;
        return this;
    }

    public Surcharge addConfigurationsItem(ModelConfiguration configurationsItem) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<ModelConfiguration>();
        }
        this.configurations.add(configurationsItem);
        return this;
    }

    @ApiModelProperty(value="Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.")
    @JsonProperty(value="configurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ModelConfiguration> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="configurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurations(List<ModelConfiguration> configurations) {
        this.configurations = configurations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Surcharge surcharge = (Surcharge)o;
        return Objects.equals(this.askConfirmation, surcharge.askConfirmation) && Objects.equals(this.configurations, surcharge.configurations);
    }

    public int hashCode() {
        return Objects.hash(this.askConfirmation, this.configurations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Surcharge {\n");
        sb.append("    askConfirmation: ").append(this.toIndentedString(this.askConfirmation)).append("\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Surcharge fromJson(String jsonString) throws JsonProcessingException {
        return (Surcharge)JSON.getMapper().readValue(jsonString, Surcharge.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

