/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.FraudResult;
import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "authCode", "dccAmount", "dccSignature", "fraudResult", "issuerUrl", "md", "paRequest", "pspReference", "refusalReason", "resultCode"})
public class PaymentResult {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
    private String authCode;
    public static final String JSON_PROPERTY_DCC_AMOUNT = "dccAmount";
    private Amount dccAmount;
    public static final String JSON_PROPERTY_DCC_SIGNATURE = "dccSignature";
    private String dccSignature;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
    private String issuerUrl;
    public static final String JSON_PROPERTY_MD = "md";
    private String md;
    public static final String JSON_PROPERTY_PA_REQUEST = "paRequest";
    private String paRequest;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;

    public PaymentResult additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentResult putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentResult authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @ApiModelProperty(value="Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.")
    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthCode() {
        return this.authCode;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public PaymentResult dccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dccAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getDccAmount() {
        return this.dccAmount;
    }

    @JsonProperty(value="dccAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
    }

    public PaymentResult dccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
        return this;
    }

    @ApiModelProperty(value="Cryptographic signature used to verify `dccQuote`. > This value only applies if you have implemented Dynamic Currency Conversion. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    @JsonProperty(value="dccSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDccSignature() {
        return this.dccSignature;
    }

    @JsonProperty(value="dccSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
    }

    public PaymentResult fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PaymentResult issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to direct the shopper to. > In case of SecurePlus, do not redirect a shopper to this URL.")
    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public PaymentResult md(String md) {
        this.md = md;
        return this;
    }

    @ApiModelProperty(value="The payment session.")
    @JsonProperty(value="md")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMd() {
        return this.md;
    }

    @JsonProperty(value="md")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMd(String md) {
        this.md = md;
    }

    public PaymentResult paRequest(String paRequest) {
        this.paRequest = paRequest;
        return this;
    }

    @ApiModelProperty(value="The 3D request data for the issuer.  If the value is **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass it in the `/authorise3D` request. For more information, see [3D Secure](https://docs.adyen.com/classic-integration/3d-secure).")
    @JsonProperty(value="paRequest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaRequest() {
        return this.paRequest;
    }

    @JsonProperty(value="paRequest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaRequest(String paRequest) {
        this.paRequest = paRequest;
    }

    public PaymentResult pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentResult refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentResult resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. For more information, see [Result codes](https://docs.adyen.com/online-payments/payment-result-codes).  Possible values:  * **AuthenticationFinished** \u2013 The payment has been successfully authenticated with 3D Secure 2. Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** \u2013 The transaction does not require 3D Secure authentication. Returned for [standalone authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). * **Authorised** \u2013 The payment was successfully authorised. This state serves as an indicator to proceed with the delivery of goods and services. This is a final state. * **Cancelled** \u2013 Indicates the payment has been cancelled (either by the shopper or the merchant) before processing was completed. This is a final state. * **ChallengeShopper** \u2013 The issuer requires further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Error** \u2013 There was an error when the payment was being processed. The reason is given in the `refusalReason` field. This is a final state. * **IdentifyShopper** \u2013 The issuer requires the shopper's device fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** \u2013 The payment has been authorised for a partial amount. This happens for card payments when the merchant supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** \u2013 Indicates that it is not possible to obtain the final status of the payment. This can happen if the systems providing final status information for the payment are unavailable, or if the shopper needs to take further action to complete the payment. * **PresentToShopper** \u2013 Indicates that the response contains additional information that you need to present to a shopper, so that they can use it to complete a payment. * **Received** \u2013 Indicates the payment has successfully been received by Adyen, and will be processed. This is the initial state for all payments. * **RedirectShopper** \u2013 Indicates the shopper should be redirected to an external web page or app to complete the authorisation. * **Refused** \u2013 Indicates the payment was refused. The reason is given in the `refusalReason` field. This is a final state.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResult paymentResult = (PaymentResult)o;
        return Objects.equals(this.additionalData, paymentResult.additionalData) && Objects.equals(this.authCode, paymentResult.authCode) && Objects.equals(this.dccAmount, paymentResult.dccAmount) && Objects.equals(this.dccSignature, paymentResult.dccSignature) && Objects.equals(this.fraudResult, paymentResult.fraudResult) && Objects.equals(this.issuerUrl, paymentResult.issuerUrl) && Objects.equals(this.md, paymentResult.md) && Objects.equals(this.paRequest, paymentResult.paRequest) && Objects.equals(this.pspReference, paymentResult.pspReference) && Objects.equals(this.refusalReason, paymentResult.refusalReason) && Objects.equals((Object)this.resultCode, (Object)paymentResult.resultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.authCode, this.dccAmount, this.dccSignature, this.fraudResult, this.issuerUrl, this.md, this.paRequest, this.pspReference, this.refusalReason, this.resultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResult {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    dccAmount: ").append(this.toIndentedString(this.dccAmount)).append("\n");
        sb.append("    dccSignature: ").append(this.toIndentedString(this.dccSignature)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    md: ").append(this.toIndentedString(this.md)).append("\n");
        sb.append("    paRequest: ").append(this.toIndentedString(this.paRequest)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentResult fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentResult)JSON.getMapper().readValue(jsonString, PaymentResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired"),
        AUTHORISED("Authorised"),
        CANCELLED("Cancelled"),
        CHALLENGESHOPPER("ChallengeShopper"),
        ERROR("Error"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        PARTIALLYAUTHORISED("PartiallyAuthorised"),
        PENDING("Pending"),
        PRESENTTOSHOPPER("PresentToShopper"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        REFUSED("Refused"),
        SUCCESS("Success");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

