/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"domains"})
public class ApplePayInfo {
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    private List<String> domains = new ArrayList<String>();

    public ApplePayInfo domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public ApplePayInfo addDomainsItem(String domainsItem) {
        this.domains.add(domainsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of merchant domains. Maximum: 99 domains per request.  For more information, see [Apple Pay documentation](https://docs.adyen.com/payment-methods/apple-pay/web-drop-in?tab=adyen-certificate-live_1#going-live).")
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplePayInfo applePayInfo = (ApplePayInfo)o;
        return Objects.equals(this.domains, applePayInfo.domains);
    }

    public int hashCode() {
        return Objects.hash(this.domains);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplePayInfo {\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ApplePayInfo fromJson(String jsonString) throws JsonProcessingException {
        return (ApplePayInfo)JSON.getMapper().readValue(jsonString, ApplePayInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

