/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"errorCode", "terminalModels"})
public class AndroidAppError {
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;
    public static final String JSON_PROPERTY_TERMINAL_MODELS = "terminalModels";
    private List<String> terminalModels = null;

    public AndroidAppError errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(value="The error code of the Android app with the `status` of either **error** or **invalid**.")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public AndroidAppError terminalModels(List<String> terminalModels) {
        this.terminalModels = terminalModels;
        return this;
    }

    public AndroidAppError addTerminalModelsItem(String terminalModelsItem) {
        if (this.terminalModels == null) {
            this.terminalModels = new ArrayList<String>();
        }
        this.terminalModels.add(terminalModelsItem);
        return this;
    }

    @ApiModelProperty(value="The list of payment terminal models to which the returned `errorCode` applies.")
    @JsonProperty(value="terminalModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTerminalModels() {
        return this.terminalModels;
    }

    @JsonProperty(value="terminalModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminalModels(List<String> terminalModels) {
        this.terminalModels = terminalModels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidAppError androidAppError = (AndroidAppError)o;
        return Objects.equals(this.errorCode, androidAppError.errorCode) && Objects.equals(this.terminalModels, androidAppError.terminalModels);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.terminalModels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidAppError {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    terminalModels: ").append(this.toIndentedString(this.terminalModels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AndroidAppError fromJson(String jsonString) throws JsonProcessingException {
        return (AndroidAppError)JSON.getMapper().readValue(jsonString, AndroidAppError.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

