/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"detail", "errorCode", "priority", "title"})
public class RoutingDetails {
    public static final String JSON_PROPERTY_DETAIL = "detail";
    private String detail;
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public RoutingDetails detail(String detail) {
        this.detail = detail;
        return this;
    }

    @ApiModelProperty(value="A human-readable explanation specific to this occurrence of the problem.")
    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public RoutingDetails errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(value="A code that identifies the problem type.")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public RoutingDetails priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: for normal, low-value transactions.  * **fast**: a faster way to transfer funds, but the fees are higher. Recommended for high-priority, low-value transactions.  * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: for instant funds transfers in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: for high-value transfers to a recipient in a different country.  * **internal**: for transfers to an Adyen-issued business bank account (by bank account number/IBAN).")
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public RoutingDetails title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="A short, human-readable summary of the problem type.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingDetails routingDetails = (RoutingDetails)o;
        return Objects.equals(this.detail, routingDetails.detail) && Objects.equals(this.errorCode, routingDetails.errorCode) && Objects.equals((Object)this.priority, (Object)routingDetails.priority) && Objects.equals(this.title, routingDetails.title);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detail, this.errorCode, this.priority, this.title});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutingDetails {\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RoutingDetails fromJson(String jsonString) throws JsonProcessingException {
        return (RoutingDetails)JSON.getMapper().readValue(jsonString, RoutingDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PriorityEnum {
        CROSSBORDER("crossBorder"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

