/*
 * Fund API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Fund API provides endpoints for managing the funds in the accounts on your platform. These management operations include, for example, the transfer of funds from one account to another, the payout of funds to an account holder, and the retrieval of balances in an account.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Fund API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Fund/v6/accountHolderBalance ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayfund;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayfund.TransactionListForAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AccountHolderTransactionListRequest
 */
@JsonPropertyOrder({
  AccountHolderTransactionListRequest.JSON_PROPERTY_ACCOUNT_HOLDER_CODE,
  AccountHolderTransactionListRequest.JSON_PROPERTY_TRANSACTION_LISTS_PER_ACCOUNT,
  AccountHolderTransactionListRequest.JSON_PROPERTY_TRANSACTION_STATUSES
})

public class AccountHolderTransactionListRequest {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
  private String accountHolderCode;

  public static final String JSON_PROPERTY_TRANSACTION_LISTS_PER_ACCOUNT = "transactionListsPerAccount";
  private List<TransactionListForAccount> transactionListsPerAccount = null;

  /**
   * Gets or Sets transactionStatuses
   */
  public enum TransactionStatusesEnum {
    BALANCENOTPAIDOUTTRANSFER("BalanceNotPaidOutTransfer"),
    
    BALANCEPLATFORMSWEEP("BalancePlatformSweep"),
    
    BALANCEPLATFORMSWEEPRETURNED("BalancePlatformSweepReturned"),
    
    CHARGEBACK("Chargeback"),
    
    CHARGEBACKCORRECTION("ChargebackCorrection"),
    
    CHARGEBACKCORRECTIONRECEIVED("ChargebackCorrectionReceived"),
    
    CHARGEBACKRECEIVED("ChargebackReceived"),
    
    CHARGEBACKREVERSED("ChargebackReversed"),
    
    CHARGEBACKREVERSEDCORRECTION("ChargebackReversedCorrection"),
    
    CHARGEBACKREVERSEDCORRECTIONRECEIVED("ChargebackReversedCorrectionReceived"),
    
    CHARGEBACKREVERSEDRECEIVED("ChargebackReversedReceived"),
    
    CONVERTED("Converted"),
    
    CREDITCLOSED("CreditClosed"),
    
    CREDITFAILED("CreditFailed"),
    
    CREDITREVERSED("CreditReversed"),
    
    CREDITREVERSEDRECEIVED("CreditReversedReceived"),
    
    CREDITSUSPENDED("CreditSuspended"),
    
    CREDITED("Credited"),
    
    DEBITFAILED("DebitFailed"),
    
    DEBITREVERSEDRECEIVED("DebitReversedReceived"),
    
    DEBITED("Debited"),
    
    DEBITEDREVERSED("DebitedReversed"),
    
    DEPOSITCORRECTIONCREDITED("DepositCorrectionCredited"),
    
    DEPOSITCORRECTIONDEBITED("DepositCorrectionDebited"),
    
    FEE("Fee"),
    
    FUNDTRANSFER("FundTransfer"),
    
    FUNDTRANSFERREVERSED("FundTransferReversed"),
    
    INVOICEDEDUCTIONCREDITED("InvoiceDeductionCredited"),
    
    INVOICEDEDUCTIONDEBITED("InvoiceDeductionDebited"),
    
    MANUALCORRECTED("ManualCorrected"),
    
    MANUALCORRECTIONCREDITED("ManualCorrectionCredited"),
    
    MANUALCORRECTIONDEBITED("ManualCorrectionDebited"),
    
    MERCHANTPAYIN("MerchantPayin"),
    
    MERCHANTPAYINREVERSED("MerchantPayinReversed"),
    
    PAYOUT("Payout"),
    
    PAYOUTREVERSED("PayoutReversed"),
    
    PENDINGCREDIT("PendingCredit"),
    
    PENDINGDEBIT("PendingDebit"),
    
    PENDINGFUNDTRANSFER("PendingFundTransfer"),
    
    RECREDITED("ReCredited"),
    
    RECREDITEDRECEIVED("ReCreditedReceived"),
    
    SECONDCHARGEBACK("SecondChargeback"),
    
    SECONDCHARGEBACKCORRECTION("SecondChargebackCorrection"),
    
    SECONDCHARGEBACKCORRECTIONRECEIVED("SecondChargebackCorrectionReceived"),
    
    SECONDCHARGEBACKRECEIVED("SecondChargebackReceived");

    private String value;

    TransactionStatusesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransactionStatusesEnum fromValue(String value) {
      for (TransactionStatusesEnum b : TransactionStatusesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANSACTION_STATUSES = "transactionStatuses";
  private List<TransactionStatusesEnum> transactionStatuses = null;

  public AccountHolderTransactionListRequest() { 
  }

  public AccountHolderTransactionListRequest accountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
    return this;
  }

   /**
   * The code of the account holder that owns the account(s) of which retrieve the transaction list.
   * @return accountHolderCode
  **/
  @ApiModelProperty(required = true, value = "The code of the account holder that owns the account(s) of which retrieve the transaction list.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountHolderCode() {
    return accountHolderCode;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderCode(String accountHolderCode) {
    this.accountHolderCode = accountHolderCode;
  }


  public AccountHolderTransactionListRequest transactionListsPerAccount(List<TransactionListForAccount> transactionListsPerAccount) {
    this.transactionListsPerAccount = transactionListsPerAccount;
    return this;
  }

  public AccountHolderTransactionListRequest addTransactionListsPerAccountItem(TransactionListForAccount transactionListsPerAccountItem) {
    if (this.transactionListsPerAccount == null) {
      this.transactionListsPerAccount = new ArrayList<>();
    }
    this.transactionListsPerAccount.add(transactionListsPerAccountItem);
    return this;
  }

   /**
   * A list of accounts to include in the transaction list. If left blank, the last fifty (50) transactions for all accounts of the account holder will be included.
   * @return transactionListsPerAccount
  **/
  @ApiModelProperty(value = "A list of accounts to include in the transaction list. If left blank, the last fifty (50) transactions for all accounts of the account holder will be included.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_LISTS_PER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionListForAccount> getTransactionListsPerAccount() {
    return transactionListsPerAccount;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_LISTS_PER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionListsPerAccount(List<TransactionListForAccount> transactionListsPerAccount) {
    this.transactionListsPerAccount = transactionListsPerAccount;
  }


  public AccountHolderTransactionListRequest transactionStatuses(List<TransactionStatusesEnum> transactionStatuses) {
    this.transactionStatuses = transactionStatuses;
    return this;
  }

  public AccountHolderTransactionListRequest addTransactionStatusesItem(TransactionStatusesEnum transactionStatusesItem) {
    if (this.transactionStatuses == null) {
      this.transactionStatuses = new ArrayList<>();
    }
    this.transactionStatuses.add(transactionStatusesItem);
    return this;
  }

   /**
   * A list of statuses to include in the transaction list. If left blank, all transactions will be included. &gt;Permitted values: &gt;* &#x60;PendingCredit&#x60; - a pending balance credit. &gt;* &#x60;CreditFailed&#x60; - a pending credit failure; the balance will not be credited. &gt;* &#x60;Credited&#x60; - a credited balance. &gt;* &#x60;PendingDebit&#x60; - a pending balance debit (e.g., a refund). &gt;* &#x60;CreditClosed&#x60; - a pending credit closed; the balance will not be credited. &gt;* &#x60;CreditSuspended&#x60; - a pending credit closed; the balance will not be credited. &gt;* &#x60;DebitFailed&#x60; - a pending debit failure; the balance will not be debited. &gt;* &#x60;Debited&#x60; - a debited balance (e.g., a refund). &gt;* &#x60;DebitReversedReceived&#x60; - a pending refund reversal. &gt;* &#x60;DebitedReversed&#x60; - a reversed refund. &gt;* &#x60;ChargebackReceived&#x60; - a received chargeback request. &gt;* &#x60;Chargeback&#x60; - a processed chargeback. &gt;* &#x60;ChargebackReversedReceived&#x60; - a pending chargeback reversal. &gt;* &#x60;ChargebackReversed&#x60; - a reversed chargeback. &gt;* &#x60;Converted&#x60; - converted. &gt;* &#x60;ManualCorrected&#x60; - manual booking/adjustment by Adyen. &gt;* &#x60;Payout&#x60; - a payout. &gt;* &#x60;PayoutReversed&#x60; - a reversed payout. &gt;* &#x60;PendingFundTransfer&#x60; - a pending transfer of funds from one account to another. &gt;* &#x60;FundTransfer&#x60; - a transfer of funds from one account to another.
   * @return transactionStatuses
  **/
  @ApiModelProperty(value = "A list of statuses to include in the transaction list. If left blank, all transactions will be included. >Permitted values: >* `PendingCredit` - a pending balance credit. >* `CreditFailed` - a pending credit failure; the balance will not be credited. >* `Credited` - a credited balance. >* `PendingDebit` - a pending balance debit (e.g., a refund). >* `CreditClosed` - a pending credit closed; the balance will not be credited. >* `CreditSuspended` - a pending credit closed; the balance will not be credited. >* `DebitFailed` - a pending debit failure; the balance will not be debited. >* `Debited` - a debited balance (e.g., a refund). >* `DebitReversedReceived` - a pending refund reversal. >* `DebitedReversed` - a reversed refund. >* `ChargebackReceived` - a received chargeback request. >* `Chargeback` - a processed chargeback. >* `ChargebackReversedReceived` - a pending chargeback reversal. >* `ChargebackReversed` - a reversed chargeback. >* `Converted` - converted. >* `ManualCorrected` - manual booking/adjustment by Adyen. >* `Payout` - a payout. >* `PayoutReversed` - a reversed payout. >* `PendingFundTransfer` - a pending transfer of funds from one account to another. >* `FundTransfer` - a transfer of funds from one account to another.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_STATUSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionStatusesEnum> getTransactionStatuses() {
    return transactionStatuses;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_STATUSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionStatuses(List<TransactionStatusesEnum> transactionStatuses) {
    this.transactionStatuses = transactionStatuses;
  }


  /**
   * Return true if this AccountHolderTransactionListRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountHolderTransactionListRequest accountHolderTransactionListRequest = (AccountHolderTransactionListRequest) o;
    return Objects.equals(this.accountHolderCode, accountHolderTransactionListRequest.accountHolderCode) &&
        Objects.equals(this.transactionListsPerAccount, accountHolderTransactionListRequest.transactionListsPerAccount) &&
        Objects.equals(this.transactionStatuses, accountHolderTransactionListRequest.transactionStatuses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolderCode, transactionListsPerAccount, transactionStatuses);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountHolderTransactionListRequest {\n");
    sb.append("    accountHolderCode: ").append(toIndentedString(accountHolderCode)).append("\n");
    sb.append("    transactionListsPerAccount: ").append(toIndentedString(transactionListsPerAccount)).append("\n");
    sb.append("    transactionStatuses: ").append(toIndentedString(transactionStatuses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AccountHolderTransactionListRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountHolderTransactionListRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to AccountHolderTransactionListRequest
   */
  public static AccountHolderTransactionListRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AccountHolderTransactionListRequest.class);
  }
/**
  * Convert an instance of AccountHolderTransactionListRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

