/*
 * Management Webhooks
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.managementwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TerminalSettingsData
 */
@JsonPropertyOrder({
  TerminalSettingsData.JSON_PROPERTY_COMPANY_ID,
  TerminalSettingsData.JSON_PROPERTY_MERCHANT_ID,
  TerminalSettingsData.JSON_PROPERTY_STORE_ID,
  TerminalSettingsData.JSON_PROPERTY_TERMINAL_ID,
  TerminalSettingsData.JSON_PROPERTY_UPDATE_SOURCE,
  TerminalSettingsData.JSON_PROPERTY_USER
})

public class TerminalSettingsData {
  public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
  private String companyId;

  public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
  private String merchantId;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  private String storeId;

  public static final String JSON_PROPERTY_TERMINAL_ID = "terminalId";
  private String terminalId;

  /**
   * Indicates whether the terminal settings were updated using the Customer Area or the Management API.
   */
  public enum UpdateSourceEnum {
    CUSTOMER_AREA("Customer Area"),
    
    MANAGEMENT_API("Management Api");

    private String value;

    UpdateSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UpdateSourceEnum fromValue(String value) {
      for (UpdateSourceEnum b : UpdateSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_UPDATE_SOURCE = "updateSource";
  private UpdateSourceEnum updateSource;

  public static final String JSON_PROPERTY_USER = "user";
  private String user;

  public TerminalSettingsData() { 
  }

  public TerminalSettingsData companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * The unique identifier of the company account.
   * @return companyId
  **/
  @ApiModelProperty(value = "The unique identifier of the company account.")
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompanyId() {
    return companyId;
  }


 /**
  * The unique identifier of the company account.
  *
  * @param companyId
  */ 
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }


  public TerminalSettingsData merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

   /**
   * The unique identifier of the merchant account.
   * @return merchantId
  **/
  @ApiModelProperty(value = "The unique identifier of the merchant account.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantId() {
    return merchantId;
  }


 /**
  * The unique identifier of the merchant account.
  *
  * @param merchantId
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }


  public TerminalSettingsData storeId(String storeId) {
    this.storeId = storeId;
    return this;
  }

   /**
   * The unique identifier of the store.
   * @return storeId
  **/
  @ApiModelProperty(value = "The unique identifier of the store.")
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStoreId() {
    return storeId;
  }


 /**
  * The unique identifier of the store.
  *
  * @param storeId
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(String storeId) {
    this.storeId = storeId;
  }


  public TerminalSettingsData terminalId(String terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * The unique identifier of the terminal.
   * @return terminalId
  **/
  @ApiModelProperty(value = "The unique identifier of the terminal.")
  @JsonProperty(JSON_PROPERTY_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTerminalId() {
    return terminalId;
  }


 /**
  * The unique identifier of the terminal.
  *
  * @param terminalId
  */ 
  @JsonProperty(JSON_PROPERTY_TERMINAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTerminalId(String terminalId) {
    this.terminalId = terminalId;
  }


  public TerminalSettingsData updateSource(UpdateSourceEnum updateSource) {
    this.updateSource = updateSource;
    return this;
  }

   /**
   * Indicates whether the terminal settings were updated using the Customer Area or the Management API.
   * @return updateSource
  **/
  @ApiModelProperty(required = true, value = "Indicates whether the terminal settings were updated using the Customer Area or the Management API.")
  @JsonProperty(JSON_PROPERTY_UPDATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpdateSourceEnum getUpdateSource() {
    return updateSource;
  }


 /**
  * Indicates whether the terminal settings were updated using the Customer Area or the Management API.
  *
  * @param updateSource
  */ 
  @JsonProperty(JSON_PROPERTY_UPDATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdateSource(UpdateSourceEnum updateSource) {
    this.updateSource = updateSource;
  }


  public TerminalSettingsData user(String user) {
    this.user = user;
    return this;
  }

   /**
   * The user that updated the terminal settings. Can be Adyen or your API credential username.
   * @return user
  **/
  @ApiModelProperty(required = true, value = "The user that updated the terminal settings. Can be Adyen or your API credential username.")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUser() {
    return user;
  }


 /**
  * The user that updated the terminal settings. Can be Adyen or your API credential username.
  *
  * @param user
  */ 
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(String user) {
    this.user = user;
  }


  /**
   * Return true if this TerminalSettingsData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalSettingsData terminalSettingsData = (TerminalSettingsData) o;
    return Objects.equals(this.companyId, terminalSettingsData.companyId) &&
        Objects.equals(this.merchantId, terminalSettingsData.merchantId) &&
        Objects.equals(this.storeId, terminalSettingsData.storeId) &&
        Objects.equals(this.terminalId, terminalSettingsData.terminalId) &&
        Objects.equals(this.updateSource, terminalSettingsData.updateSource) &&
        Objects.equals(this.user, terminalSettingsData.user);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, merchantId, storeId, terminalId, updateSource, user);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalSettingsData {\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    updateSource: ").append(toIndentedString(updateSource)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TerminalSettingsData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TerminalSettingsData
   * @throws JsonProcessingException if the JSON string is invalid with respect to TerminalSettingsData
   */
  public static TerminalSettingsData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TerminalSettingsData.class);
  }
/**
  * Convert an instance of TerminalSettingsData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

