/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.ModelConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Surcharge
 */
@JsonPropertyOrder({
  Surcharge.JSON_PROPERTY_ASK_CONFIRMATION,
  Surcharge.JSON_PROPERTY_CONFIGURATIONS
})

public class Surcharge {
  public static final String JSON_PROPERTY_ASK_CONFIRMATION = "askConfirmation";
  private Boolean askConfirmation;

  public static final String JSON_PROPERTY_CONFIGURATIONS = "configurations";
  private List<ModelConfiguration> configurations = null;

  public Surcharge() { 
  }

  public Surcharge askConfirmation(Boolean askConfirmation) {
    this.askConfirmation = askConfirmation;
    return this;
  }

   /**
   * Show the surcharge details on the terminal, so the shopper can confirm.
   * @return askConfirmation
  **/
  @ApiModelProperty(value = "Show the surcharge details on the terminal, so the shopper can confirm.")
  @JsonProperty(JSON_PROPERTY_ASK_CONFIRMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAskConfirmation() {
    return askConfirmation;
  }


 /**
  * Show the surcharge details on the terminal, so the shopper can confirm.
  *
  * @param askConfirmation
  */ 
  @JsonProperty(JSON_PROPERTY_ASK_CONFIRMATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAskConfirmation(Boolean askConfirmation) {
    this.askConfirmation = askConfirmation;
  }


  public Surcharge configurations(List<ModelConfiguration> configurations) {
    this.configurations = configurations;
    return this;
  }

  public Surcharge addConfigurationsItem(ModelConfiguration configurationsItem) {
    if (this.configurations == null) {
      this.configurations = new ArrayList<>();
    }
    this.configurations.add(configurationsItem);
    return this;
  }

   /**
   * Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.
   * @return configurations
  **/
  @ApiModelProperty(value = "Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.")
  @JsonProperty(JSON_PROPERTY_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ModelConfiguration> getConfigurations() {
    return configurations;
  }


 /**
  * Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.
  *
  * @param configurations
  */ 
  @JsonProperty(JSON_PROPERTY_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfigurations(List<ModelConfiguration> configurations) {
    this.configurations = configurations;
  }


  /**
   * Return true if this Surcharge object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Surcharge surcharge = (Surcharge) o;
    return Objects.equals(this.askConfirmation, surcharge.askConfirmation) &&
        Objects.equals(this.configurations, surcharge.configurations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(askConfirmation, configurations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Surcharge {\n");
    sb.append("    askConfirmation: ").append(toIndentedString(askConfirmation)).append("\n");
    sb.append("    configurations: ").append(toIndentedString(configurations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Surcharge given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Surcharge
   * @throws JsonProcessingException if the JSON string is invalid with respect to Surcharge
   */
  public static Surcharge fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Surcharge.class);
  }
/**
  * Convert an instance of Surcharge to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

