/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.BillingAddress;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.CheckoutPaymentMethod;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.DeliveryAddress;
import com.adyen.model.checkout.EncryptedOrderData;
import com.adyen.model.checkout.ForexQuote;
import com.adyen.model.checkout.FundOrigin;
import com.adyen.model.checkout.FundRecipient;
import com.adyen.model.checkout.Installments;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDS2RequestFields;
import com.adyen.model.checkout.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentRequest
 */
@JsonPropertyOrder({
  PaymentRequest.JSON_PROPERTY_ACCOUNT_INFO,
  PaymentRequest.JSON_PROPERTY_ADDITIONAL_AMOUNT,
  PaymentRequest.JSON_PROPERTY_ADDITIONAL_DATA,
  PaymentRequest.JSON_PROPERTY_AMOUNT,
  PaymentRequest.JSON_PROPERTY_APPLICATION_INFO,
  PaymentRequest.JSON_PROPERTY_AUTHENTICATION_DATA,
  PaymentRequest.JSON_PROPERTY_BILLING_ADDRESS,
  PaymentRequest.JSON_PROPERTY_BROWSER_INFO,
  PaymentRequest.JSON_PROPERTY_CAPTURE_DELAY_HOURS,
  PaymentRequest.JSON_PROPERTY_CHANNEL,
  PaymentRequest.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  PaymentRequest.JSON_PROPERTY_COMPANY,
  PaymentRequest.JSON_PROPERTY_CONVERSION_ID,
  PaymentRequest.JSON_PROPERTY_COUNTRY_CODE,
  PaymentRequest.JSON_PROPERTY_DATE_OF_BIRTH,
  PaymentRequest.JSON_PROPERTY_DCC_QUOTE,
  PaymentRequest.JSON_PROPERTY_DELIVER_AT,
  PaymentRequest.JSON_PROPERTY_DELIVERY_ADDRESS,
  PaymentRequest.JSON_PROPERTY_DELIVERY_DATE,
  PaymentRequest.JSON_PROPERTY_DEVICE_FINGERPRINT,
  PaymentRequest.JSON_PROPERTY_ENABLE_ONE_CLICK,
  PaymentRequest.JSON_PROPERTY_ENABLE_PAY_OUT,
  PaymentRequest.JSON_PROPERTY_ENABLE_RECURRING,
  PaymentRequest.JSON_PROPERTY_ENTITY_TYPE,
  PaymentRequest.JSON_PROPERTY_FRAUD_OFFSET,
  PaymentRequest.JSON_PROPERTY_FUND_ORIGIN,
  PaymentRequest.JSON_PROPERTY_FUND_RECIPIENT,
  PaymentRequest.JSON_PROPERTY_INDUSTRY_USAGE,
  PaymentRequest.JSON_PROPERTY_INSTALLMENTS,
  PaymentRequest.JSON_PROPERTY_LINE_ITEMS,
  PaymentRequest.JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT,
  PaymentRequest.JSON_PROPERTY_MANDATE,
  PaymentRequest.JSON_PROPERTY_MCC,
  PaymentRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  PaymentRequest.JSON_PROPERTY_MERCHANT_ORDER_REFERENCE,
  PaymentRequest.JSON_PROPERTY_MERCHANT_RISK_INDICATOR,
  PaymentRequest.JSON_PROPERTY_METADATA,
  PaymentRequest.JSON_PROPERTY_MPI_DATA,
  PaymentRequest.JSON_PROPERTY_ORDER,
  PaymentRequest.JSON_PROPERTY_ORDER_REFERENCE,
  PaymentRequest.JSON_PROPERTY_ORIGIN,
  PaymentRequest.JSON_PROPERTY_PAYMENT_METHOD,
  PaymentRequest.JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC,
  PaymentRequest.JSON_PROPERTY_RECURRING_EXPIRY,
  PaymentRequest.JSON_PROPERTY_RECURRING_FREQUENCY,
  PaymentRequest.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  PaymentRequest.JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD,
  PaymentRequest.JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD,
  PaymentRequest.JSON_PROPERTY_REFERENCE,
  PaymentRequest.JSON_PROPERTY_RETURN_URL,
  PaymentRequest.JSON_PROPERTY_RISK_DATA,
  PaymentRequest.JSON_PROPERTY_SESSION_VALIDITY,
  PaymentRequest.JSON_PROPERTY_SHOPPER_EMAIL,
  PaymentRequest.JSON_PROPERTY_SHOPPER_I_P,
  PaymentRequest.JSON_PROPERTY_SHOPPER_INTERACTION,
  PaymentRequest.JSON_PROPERTY_SHOPPER_LOCALE,
  PaymentRequest.JSON_PROPERTY_SHOPPER_NAME,
  PaymentRequest.JSON_PROPERTY_SHOPPER_REFERENCE,
  PaymentRequest.JSON_PROPERTY_SHOPPER_STATEMENT,
  PaymentRequest.JSON_PROPERTY_SOCIAL_SECURITY_NUMBER,
  PaymentRequest.JSON_PROPERTY_SPLITS,
  PaymentRequest.JSON_PROPERTY_STORE,
  PaymentRequest.JSON_PROPERTY_STORE_PAYMENT_METHOD,
  PaymentRequest.JSON_PROPERTY_TELEPHONE_NUMBER,
  PaymentRequest.JSON_PROPERTY_THREE_D_S2_REQUEST_DATA,
  PaymentRequest.JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY,
  PaymentRequest.JSON_PROPERTY_TRUSTED_SHOPPER
})

public class PaymentRequest {
  public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
  private AccountInfo accountInfo;

  public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
  private Amount additionalAmount;

  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData = null;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_AUTHENTICATION_DATA = "authenticationData";
  private AuthenticationData authenticationData;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private BillingAddress billingAddress;

  public static final String JSON_PROPERTY_BROWSER_INFO = "browserInfo";
  private BrowserInfo browserInfo;

  public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
  private Integer captureDelayHours;

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * iOS * Android * Web
   */
  public enum ChannelEnum {
    IOS("iOS"),
    
    ANDROID("Android"),
    
    WEB("Web");

    private String value;

    ChannelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelEnum fromValue(String value) {
      for (ChannelEnum b : ChannelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL = "channel";
  private ChannelEnum channel;

  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private Company company;

  public static final String JSON_PROPERTY_CONVERSION_ID = "conversionId";
  @Deprecated
  private String conversionId;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private OffsetDateTime dateOfBirth;

  public static final String JSON_PROPERTY_DCC_QUOTE = "dccQuote";
  private ForexQuote dccQuote;

  public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
  private OffsetDateTime deliverAt;

  public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
  private DeliveryAddress deliveryAddress;

  public static final String JSON_PROPERTY_DELIVERY_DATE = "deliveryDate";
  @Deprecated
  private OffsetDateTime deliveryDate;

  public static final String JSON_PROPERTY_DEVICE_FINGERPRINT = "deviceFingerprint";
  private String deviceFingerprint;

  public static final String JSON_PROPERTY_ENABLE_ONE_CLICK = "enableOneClick";
  private Boolean enableOneClick;

  public static final String JSON_PROPERTY_ENABLE_PAY_OUT = "enablePayOut";
  private Boolean enablePayOut;

  public static final String JSON_PROPERTY_ENABLE_RECURRING = "enableRecurring";
  private Boolean enableRecurring;

  /**
   * The type of the entity the payment is processed for.
   */
  public enum EntityTypeEnum {
    NATURALPERSON("NaturalPerson"),
    
    COMPANYNAME("CompanyName");

    private String value;

    EntityTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EntityTypeEnum fromValue(String value) {
      for (EntityTypeEnum b : EntityTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
  private EntityTypeEnum entityType;

  public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
  private Integer fraudOffset;

  public static final String JSON_PROPERTY_FUND_ORIGIN = "fundOrigin";
  private FundOrigin fundOrigin;

  public static final String JSON_PROPERTY_FUND_RECIPIENT = "fundRecipient";
  private FundRecipient fundRecipient;

  /**
   * The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**
   */
  public enum IndustryUsageEnum {
    DELAYEDCHARGE("delayedCharge"),
    
    INSTALLMENT("installment"),
    
    NOSHOW("noShow");

    private String value;

    IndustryUsageEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IndustryUsageEnum fromValue(String value) {
      for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INDUSTRY_USAGE = "industryUsage";
  private IndustryUsageEnum industryUsage;

  public static final String JSON_PROPERTY_INSTALLMENTS = "installments";
  private Installments installments;

  public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
  private List<LineItem> lineItems = null;

  public static final String JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
  private Map<String, String> localizedShopperStatement = null;

  public static final String JSON_PROPERTY_MANDATE = "mandate";
  private Mandate mandate;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  private String merchantOrderReference;

  public static final String JSON_PROPERTY_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
  private MerchantRiskIndicator merchantRiskIndicator;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
  private ThreeDSecureData mpiData;

  public static final String JSON_PROPERTY_ORDER = "order";
  private EncryptedOrderData order;

  public static final String JSON_PROPERTY_ORDER_REFERENCE = "orderReference";
  private String orderReference;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private String origin;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private CheckoutPaymentMethod paymentMethod;

  public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
  private PlatformChargebackLogic platformChargebackLogic;

  public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
  private String recurringExpiry;

  public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
  private String recurringFrequency;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE("CardOnFile"),
    
    SUBSCRIPTION("Subscription"),
    
    UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
  private String redirectFromIssuerMethod;

  public static final String JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
  private String redirectToIssuerMethod;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
  private String returnUrl;

  public static final String JSON_PROPERTY_RISK_DATA = "riskData";
  private RiskData riskData;

  public static final String JSON_PROPERTY_SESSION_VALIDITY = "sessionValidity";
  private String sessionValidity;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
  private String shopperIP;

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   */
  public enum ShopperInteractionEnum {
    ECOMMERCE("Ecommerce"),
    
    CONTAUTH("ContAuth"),
    
    MOTO("Moto"),
    
    POS("POS");

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private ShopperInteractionEnum shopperInteraction;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
  private Name shopperName;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
  private String shopperStatement;

  public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  private String socialSecurityNumber;

  public static final String JSON_PROPERTY_SPLITS = "splits";
  private List<Split> splits = null;

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD = "storePaymentMethod";
  private Boolean storePaymentMethod;

  public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
  private String telephoneNumber;

  public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
  private ThreeDS2RequestFields threeDS2RequestData;

  public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
  @Deprecated
  private Boolean threeDSAuthenticationOnly;

  public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
  private Boolean trustedShopper;

  public PaymentRequest() { 
  }

  public PaymentRequest accountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
    return this;
  }

   /**
   * Get accountInfo
   * @return accountInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AccountInfo getAccountInfo() {
    return accountInfo;
  }


 /**
  * accountInfo
  *
  * @param accountInfo
  */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
  }


  public PaymentRequest additionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
    return this;
  }

   /**
   * Get additionalAmount
   * @return additionalAmount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAdditionalAmount() {
    return additionalAmount;
  }


 /**
  * additionalAmount
  *
  * @param additionalAmount
  */ 
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
  }


  public PaymentRequest additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public PaymentRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

   /**
   * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
   * @return additionalData
  **/
  @ApiModelProperty(value = "This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getAdditionalData() {
    return additionalData;
  }


 /**
  * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
  *
  * @param additionalData
  */ 
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }


  public PaymentRequest amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


 /**
  * amount
  *
  * @param amount
  */ 
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public PaymentRequest applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

   /**
   * Get applicationInfo
   * @return applicationInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }


 /**
  * applicationInfo
  *
  * @param applicationInfo
  */ 
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }


  public PaymentRequest authenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
    return this;
  }

   /**
   * Get authenticationData
   * @return authenticationData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthenticationData getAuthenticationData() {
    return authenticationData;
  }


 /**
  * authenticationData
  *
  * @param authenticationData
  */ 
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
  }


  public PaymentRequest billingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BillingAddress getBillingAddress() {
    return billingAddress;
  }


 /**
  * billingAddress
  *
  * @param billingAddress
  */ 
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
  }


  public PaymentRequest browserInfo(BrowserInfo browserInfo) {
    this.browserInfo = browserInfo;
    return this;
  }

   /**
   * Get browserInfo
   * @return browserInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BROWSER_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BrowserInfo getBrowserInfo() {
    return browserInfo;
  }


 /**
  * browserInfo
  *
  * @param browserInfo
  */ 
  @JsonProperty(JSON_PROPERTY_BROWSER_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrowserInfo(BrowserInfo browserInfo) {
    this.browserInfo = browserInfo;
  }


  public PaymentRequest captureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
    return this;
  }

   /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   * @return captureDelayHours
  **/
  @ApiModelProperty(value = "The delay between the authorisation and scheduled auto-capture, specified in hours.")
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }


 /**
  * The delay between the authorisation and scheduled auto-capture, specified in hours.
  *
  * @param captureDelayHours
  */ 
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }


  public PaymentRequest channel(ChannelEnum channel) {
    this.channel = channel;
    return this;
  }

   /**
   * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * iOS * Android * Web
   * @return channel
  **/
  @ApiModelProperty(value = "The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * iOS * Android * Web")
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChannelEnum getChannel() {
    return channel;
  }


 /**
  * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * iOS * Android * Web
  *
  * @param channel
  */ 
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannel(ChannelEnum channel) {
    this.channel = channel;
  }


  public PaymentRequest checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

   /**
   * Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
   * @return checkoutAttemptId
  **/
  @ApiModelProperty(value = "Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }


 /**
  * Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
  *
  * @param checkoutAttemptId
  */ 
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }


  public PaymentRequest company(Company company) {
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Company getCompany() {
    return company;
  }


 /**
  * company
  *
  * @param company
  */ 
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompany(Company company) {
    this.company = company;
  }


  @Deprecated
  public PaymentRequest conversionId(String conversionId) {
    this.conversionId = conversionId;
    return this;
  }

   /**
   * Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
   * @return conversionId
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")
  @JsonProperty(JSON_PROPERTY_CONVERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConversionId() {
    return conversionId;
  }


 /**
  * Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
  *
  * @param conversionId
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_CONVERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConversionId(String conversionId) {
    this.conversionId = conversionId;
  }


  public PaymentRequest countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   * @return countryCode
  **/
  @ApiModelProperty(value = "The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


 /**
  * The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
  *
  * @param countryCode
  */ 
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PaymentRequest dateOfBirth(OffsetDateTime dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   * @return dateOfBirth
  **/
  @ApiModelProperty(value = "The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDateOfBirth() {
    return dateOfBirth;
  }


 /**
  * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
  *
  * @param dateOfBirth
  */ 
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(OffsetDateTime dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public PaymentRequest dccQuote(ForexQuote dccQuote) {
    this.dccQuote = dccQuote;
    return this;
  }

   /**
   * Get dccQuote
   * @return dccQuote
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DCC_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ForexQuote getDccQuote() {
    return dccQuote;
  }


 /**
  * dccQuote
  *
  * @param dccQuote
  */ 
  @JsonProperty(JSON_PROPERTY_DCC_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDccQuote(ForexQuote dccQuote) {
    this.dccQuote = dccQuote;
  }


  public PaymentRequest deliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
    return this;
  }

   /**
   * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
   * @return deliverAt
  **/
  @ApiModelProperty(value = "The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDeliverAt() {
    return deliverAt;
  }


 /**
  * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
  *
  * @param deliverAt
  */ 
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
  }


  public PaymentRequest deliveryAddress(DeliveryAddress deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

   /**
   * Get deliveryAddress
   * @return deliveryAddress
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DeliveryAddress getDeliveryAddress() {
    return deliveryAddress;
  }


 /**
  * deliveryAddress
  *
  * @param deliveryAddress
  */ 
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }


  @Deprecated
  public PaymentRequest deliveryDate(OffsetDateTime deliveryDate) {
    this.deliveryDate = deliveryDate;
    return this;
  }

   /**
   * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
   * @return deliveryDate
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")
  @JsonProperty(JSON_PROPERTY_DELIVERY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDeliveryDate() {
    return deliveryDate;
  }


 /**
  * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
  *
  * @param deliveryDate
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_DELIVERY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryDate(OffsetDateTime deliveryDate) {
    this.deliveryDate = deliveryDate;
  }


  public PaymentRequest deviceFingerprint(String deviceFingerprint) {
    this.deviceFingerprint = deviceFingerprint;
    return this;
  }

   /**
   * A string containing the shopper&#39;s device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
   * @return deviceFingerprint
  **/
  @ApiModelProperty(value = "A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).")
  @JsonProperty(JSON_PROPERTY_DEVICE_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeviceFingerprint() {
    return deviceFingerprint;
  }


 /**
  * A string containing the shopper&#39;s device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
  *
  * @param deviceFingerprint
  */ 
  @JsonProperty(JSON_PROPERTY_DEVICE_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceFingerprint(String deviceFingerprint) {
    this.deviceFingerprint = deviceFingerprint;
  }


  public PaymentRequest enableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the payment details should be stored for future [one-click payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   * @return enableOneClick
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the shopper will be asked if the payment details should be stored for future [one-click payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).")
  @JsonProperty(JSON_PROPERTY_ENABLE_ONE_CLICK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableOneClick() {
    return enableOneClick;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the payment details should be stored for future [one-click payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
  *
  * @param enableOneClick
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLE_ONE_CLICK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
  }


  public PaymentRequest enablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized for payouts.
   * @return enablePayOut
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be tokenized for payouts.")
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnablePayOut() {
    return enablePayOut;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized for payouts.
  *
  * @param enablePayOut
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
  }


  public PaymentRequest enableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where the shopper is not present, such as subscription or automatic top-up payments.
   * @return enableRecurring
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be stored for [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where the shopper is not present, such as subscription or automatic top-up payments.")
  @JsonProperty(JSON_PROPERTY_ENABLE_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableRecurring() {
    return enableRecurring;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where the shopper is not present, such as subscription or automatic top-up payments.
  *
  * @param enableRecurring
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLE_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
  }


  public PaymentRequest entityType(EntityTypeEnum entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * The type of the entity the payment is processed for.
   * @return entityType
  **/
  @ApiModelProperty(value = "The type of the entity the payment is processed for.")
  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EntityTypeEnum getEntityType() {
    return entityType;
  }


 /**
  * The type of the entity the payment is processed for.
  *
  * @param entityType
  */ 
  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityType(EntityTypeEnum entityType) {
    this.entityType = entityType;
  }


  public PaymentRequest fraudOffset(Integer fraudOffset) {
    this.fraudOffset = fraudOffset;
    return this;
  }

   /**
   * An integer value that is added to the normal fraud score. The value can be either positive or negative.
   * @return fraudOffset
  **/
  @ApiModelProperty(value = "An integer value that is added to the normal fraud score. The value can be either positive or negative.")
  @JsonProperty(JSON_PROPERTY_FRAUD_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFraudOffset() {
    return fraudOffset;
  }


 /**
  * An integer value that is added to the normal fraud score. The value can be either positive or negative.
  *
  * @param fraudOffset
  */ 
  @JsonProperty(JSON_PROPERTY_FRAUD_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudOffset(Integer fraudOffset) {
    this.fraudOffset = fraudOffset;
  }


  public PaymentRequest fundOrigin(FundOrigin fundOrigin) {
    this.fundOrigin = fundOrigin;
    return this;
  }

   /**
   * Get fundOrigin
   * @return fundOrigin
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUND_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FundOrigin getFundOrigin() {
    return fundOrigin;
  }


 /**
  * fundOrigin
  *
  * @param fundOrigin
  */ 
  @JsonProperty(JSON_PROPERTY_FUND_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundOrigin(FundOrigin fundOrigin) {
    this.fundOrigin = fundOrigin;
  }


  public PaymentRequest fundRecipient(FundRecipient fundRecipient) {
    this.fundRecipient = fundRecipient;
    return this;
  }

   /**
   * Get fundRecipient
   * @return fundRecipient
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUND_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FundRecipient getFundRecipient() {
    return fundRecipient;
  }


 /**
  * fundRecipient
  *
  * @param fundRecipient
  */ 
  @JsonProperty(JSON_PROPERTY_FUND_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundRecipient(FundRecipient fundRecipient) {
    this.fundRecipient = fundRecipient;
  }


  public PaymentRequest industryUsage(IndustryUsageEnum industryUsage) {
    this.industryUsage = industryUsage;
    return this;
  }

   /**
   * The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**
   * @return industryUsage
  **/
  @ApiModelProperty(value = "The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**")
  @JsonProperty(JSON_PROPERTY_INDUSTRY_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IndustryUsageEnum getIndustryUsage() {
    return industryUsage;
  }


 /**
  * The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**
  *
  * @param industryUsage
  */ 
  @JsonProperty(JSON_PROPERTY_INDUSTRY_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndustryUsage(IndustryUsageEnum industryUsage) {
    this.industryUsage = industryUsage;
  }


  public PaymentRequest installments(Installments installments) {
    this.installments = installments;
    return this;
  }

   /**
   * Get installments
   * @return installments
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INSTALLMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Installments getInstallments() {
    return installments;
  }


 /**
  * installments
  *
  * @param installments
  */ 
  @JsonProperty(JSON_PROPERTY_INSTALLMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallments(Installments installments) {
    this.installments = installments;
  }


  public PaymentRequest lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  public PaymentRequest addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * Price and product information about the purchased items, to be included on the invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.
   * @return lineItems
  **/
  @ApiModelProperty(value = "Price and product information about the purchased items, to be included on the invoice sent to the shopper. > This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.")
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LineItem> getLineItems() {
    return lineItems;
  }


 /**
  * Price and product information about the purchased items, to be included on the invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.
  *
  * @param lineItems
  */ 
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public PaymentRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
    this.localizedShopperStatement = localizedShopperStatement;
    return this;
  }

  public PaymentRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
    if (this.localizedShopperStatement == null) {
      this.localizedShopperStatement = new HashMap<>();
    }
    this.localizedShopperStatement.put(key, localizedShopperStatementItem);
    return this;
  }

   /**
   * The &#x60;localizedShopperStatement&#x60; field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.
   * @return localizedShopperStatement
  **/
  @ApiModelProperty(value = "The `localizedShopperStatement` field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.")
  @JsonProperty(JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getLocalizedShopperStatement() {
    return localizedShopperStatement;
  }


 /**
  * The &#x60;localizedShopperStatement&#x60; field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.
  *
  * @param localizedShopperStatement
  */ 
  @JsonProperty(JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
    this.localizedShopperStatement = localizedShopperStatement;
  }


  public PaymentRequest mandate(Mandate mandate) {
    this.mandate = mandate;
    return this;
  }

   /**
   * Get mandate
   * @return mandate
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MANDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Mandate getMandate() {
    return mandate;
  }


 /**
  * mandate
  *
  * @param mandate
  */ 
  @JsonProperty(JSON_PROPERTY_MANDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMandate(Mandate mandate) {
    this.mandate = mandate;
  }


  public PaymentRequest mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

   /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   * @return mcc
  **/
  @ApiModelProperty(value = "The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMcc() {
    return mcc;
  }


 /**
  * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
  *
  * @param mcc
  */ 
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public PaymentRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account identifier, with which you want to process the transaction.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account identifier, with which you want to process the transaction.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantAccount() {
    return merchantAccount;
  }


 /**
  * The merchant account identifier, with which you want to process the transaction.
  *
  * @param merchantAccount
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public PaymentRequest merchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

   /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   * @return merchantOrderReference
  **/
  @ApiModelProperty(value = "This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }


 /**
  * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
  *
  * @param merchantOrderReference
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }


  public PaymentRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
    this.merchantRiskIndicator = merchantRiskIndicator;
    return this;
  }

   /**
   * Get merchantRiskIndicator
   * @return merchantRiskIndicator
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MERCHANT_RISK_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MerchantRiskIndicator getMerchantRiskIndicator() {
    return merchantRiskIndicator;
  }


 /**
  * merchantRiskIndicator
  *
  * @param merchantRiskIndicator
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_RISK_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
    this.merchantRiskIndicator = merchantRiskIndicator;
  }


  public PaymentRequest metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public PaymentRequest putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \&quot;177\&quot; error occurs: \&quot;Metadata size exceeds limit\&quot;. * Maximum 20 characters per key. * Maximum 80 characters per value. 
   * @return metadata
  **/
  @ApiModelProperty(value = "Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value. ")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


 /**
  * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \&quot;177\&quot; error occurs: \&quot;Metadata size exceeds limit\&quot;. * Maximum 20 characters per key. * Maximum 80 characters per value. 
  *
  * @param metadata
  */ 
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PaymentRequest mpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
    return this;
  }

   /**
   * Get mpiData
   * @return mpiData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDSecureData getMpiData() {
    return mpiData;
  }


 /**
  * mpiData
  *
  * @param mpiData
  */ 
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
  }


  public PaymentRequest order(EncryptedOrderData order) {
    this.order = order;
    return this;
  }

   /**
   * Get order
   * @return order
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EncryptedOrderData getOrder() {
    return order;
  }


 /**
  * order
  *
  * @param order
  */ 
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(EncryptedOrderData order) {
    this.order = order;
  }


  public PaymentRequest orderReference(String orderReference) {
    this.orderReference = orderReference;
    return this;
  }

   /**
   * When you are doing multiple partial (gift card) payments, this is the &#x60;pspReference&#x60; of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the &#x60;merchantOrderReference&#x60;instead.
   * @return orderReference
  **/
  @ApiModelProperty(value = "When you are doing multiple partial (gift card) payments, this is the `pspReference` of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the `merchantOrderReference`instead.")
  @JsonProperty(JSON_PROPERTY_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderReference() {
    return orderReference;
  }


 /**
  * When you are doing multiple partial (gift card) payments, this is the &#x60;pspReference&#x60; of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the &#x60;merchantOrderReference&#x60;instead.
  *
  * @param orderReference
  */ 
  @JsonProperty(JSON_PROPERTY_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderReference(String orderReference) {
    this.orderReference = orderReference;
  }


  public PaymentRequest origin(String origin) {
    this.origin = origin;
    return this;
  }

   /**
   * Required for the 3D Secure 2 &#x60;channel&#x60; **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.
   * @return origin
  **/
  @ApiModelProperty(value = "Required for the 3D Secure 2 `channel` **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrigin() {
    return origin;
  }


 /**
  * Required for the 3D Secure 2 &#x60;channel&#x60; **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.
  *
  * @param origin
  */ 
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(String origin) {
    this.origin = origin;
  }


  public PaymentRequest paymentMethod(CheckoutPaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Get paymentMethod
   * @return paymentMethod
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CheckoutPaymentMethod getPaymentMethod() {
    return paymentMethod;
  }


 /**
  * paymentMethod
  *
  * @param paymentMethod
  */ 
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(CheckoutPaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public PaymentRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
    return this;
  }

   /**
   * Get platformChargebackLogic
   * @return platformChargebackLogic
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlatformChargebackLogic getPlatformChargebackLogic() {
    return platformChargebackLogic;
  }


 /**
  * platformChargebackLogic
  *
  * @param platformChargebackLogic
  */ 
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
  }


  public PaymentRequest recurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
    return this;
  }

   /**
   * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
   * @return recurringExpiry
  **/
  @ApiModelProperty(value = "Date after which no further authorisations shall be performed. Only for 3D Secure 2.")
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurringExpiry() {
    return recurringExpiry;
  }


 /**
  * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
  *
  * @param recurringExpiry
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
  }


  public PaymentRequest recurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
    return this;
  }

   /**
   * Minimum number of days between authorisations. Only for 3D Secure 2.
   * @return recurringFrequency
  **/
  @ApiModelProperty(value = "Minimum number of days between authorisations. Only for 3D Secure 2.")
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurringFrequency() {
    return recurringFrequency;
  }


 /**
  * Minimum number of days between authorisations. Only for 3D Secure 2.
  *
  * @param recurringFrequency
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
  }


  public PaymentRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

   /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel
  **/
  @ApiModelProperty(value = "Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * `Subscription` – A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }


 /**
  * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
  *
  * @param recurringProcessingModel
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }


  public PaymentRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    return this;
  }

   /**
   * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
   * @return redirectFromIssuerMethod
  **/
  @ApiModelProperty(value = "Specifies the redirect method (GET or POST) when redirecting back from the issuer.")
  @JsonProperty(JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectFromIssuerMethod() {
    return redirectFromIssuerMethod;
  }


 /**
  * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
  *
  * @param redirectFromIssuerMethod
  */ 
  @JsonProperty(JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
  }


  public PaymentRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
    return this;
  }

   /**
   * Specifies the redirect method (GET or POST) when redirecting to the issuer.
   * @return redirectToIssuerMethod
  **/
  @ApiModelProperty(value = "Specifies the redirect method (GET or POST) when redirecting to the issuer.")
  @JsonProperty(JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectToIssuerMethod() {
    return redirectToIssuerMethod;
  }


 /**
  * Specifies the redirect method (GET or POST) when redirecting to the issuer.
  *
  * @param redirectToIssuerMethod
  */ 
  @JsonProperty(JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
  }


  public PaymentRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\&quot;-\&quot;). Maximum length: 80 characters.
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


 /**
  * The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\&quot;-\&quot;). Maximum length: 80 characters.
  *
  * @param reference
  */ 
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public PaymentRequest returnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * The URL to return to in case of a redirection. The format depends on the channel.  * For web, include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: &#x60;my-app://your.package.name&#x60;
   * @return returnUrl
  **/
  @ApiModelProperty(required = true, value = "The URL to return to in case of a redirection. The format depends on the channel.  * For web, include the protocol `http://` or `https://`. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: `https://your-company.com/checkout?shopperOrder=12xy` * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: `my-app://` * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: `my-app://your.package.name`")
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnUrl() {
    return returnUrl;
  }


 /**
  * The URL to return to in case of a redirection. The format depends on the channel.  * For web, include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: &#x60;my-app://your.package.name&#x60;
  *
  * @param returnUrl
  */ 
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }


  public PaymentRequest riskData(RiskData riskData) {
    this.riskData = riskData;
    return this;
  }

   /**
   * Get riskData
   * @return riskData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RiskData getRiskData() {
    return riskData;
  }


 /**
  * riskData
  *
  * @param riskData
  */ 
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskData(RiskData riskData) {
    this.riskData = riskData;
  }


  public PaymentRequest sessionValidity(String sessionValidity) {
    this.sessionValidity = sessionValidity;
    return this;
  }

   /**
   * The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00
   * @return sessionValidity
  **/
  @ApiModelProperty(value = "The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00")
  @JsonProperty(JSON_PROPERTY_SESSION_VALIDITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSessionValidity() {
    return sessionValidity;
  }


 /**
  * The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00
  *
  * @param sessionValidity
  */ 
  @JsonProperty(JSON_PROPERTY_SESSION_VALIDITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionValidity(String sessionValidity) {
    this.sessionValidity = sessionValidity;
  }


  public PaymentRequest shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks. &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperEmail&#x60; for all browser-based and mobile implementations.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperEmail() {
    return shopperEmail;
  }


 /**
  * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks. &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperEmail&#x60; for all browser-based and mobile implementations.
  *
  * @param shopperEmail
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public PaymentRequest shopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
    return this;
  }

   /**
   * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   * @return shopperIP
  **/
  @ApiModelProperty(value = "The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperIP() {
    return shopperIP;
  }


 /**
  * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
  *
  * @param shopperIP
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
  }


  public PaymentRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

   /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   * @return shopperInteraction
  **/
  @ApiModelProperty(value = "Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }


 /**
  * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
  *
  * @param shopperInteraction
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }


  public PaymentRequest shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

   /**
   * The combination of a language code and a country code to specify the language to be used in the payment.
   * @return shopperLocale
  **/
  @ApiModelProperty(value = "The combination of a language code and a country code to specify the language to be used in the payment.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperLocale() {
    return shopperLocale;
  }


 /**
  * The combination of a language code and a country code to specify the language to be used in the payment.
  *
  * @param shopperLocale
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }


  public PaymentRequest shopperName(Name shopperName) {
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Name getShopperName() {
    return shopperName;
  }


 /**
  * shopperName
  *
  * @param shopperName
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public PaymentRequest shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperReference() {
    return shopperReference;
  }


 /**
  * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
  *
  * @param shopperReference
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public PaymentRequest shopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
    return this;
  }

   /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   * @return shopperStatement
  **/
  @ApiModelProperty(value = "The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperStatement() {
    return shopperStatement;
  }


 /**
  * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
  *
  * @param shopperStatement
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }


  public PaymentRequest socialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

   /**
   * The shopper&#39;s social security number.
   * @return socialSecurityNumber
  **/
  @ApiModelProperty(value = "The shopper's social security number.")
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }


 /**
  * The shopper&#39;s social security number.
  *
  * @param socialSecurityNumber
  */ 
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }


  public PaymentRequest splits(List<Split> splits) {
    this.splits = splits;
    return this;
  }

  public PaymentRequest addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

   /**
   * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   * @return splits
  **/
  @ApiModelProperty(value = "An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).")
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Split> getSplits() {
    return splits;
  }


 /**
  * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
  *
  * @param splits
  */ 
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }


  public PaymentRequest store(String store) {
    this.store = store;
    return this;
  }

   /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
   * @return store
  **/
  @ApiModelProperty(value = "Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.")
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStore() {
    return store;
  }


 /**
  * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
  *
  * @param store
  */ 
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }


  public PaymentRequest storePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for future [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   * @return storePaymentMethod
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be stored for future [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).")
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getStorePaymentMethod() {
    return storePaymentMethod;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for future [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
  *
  * @param storePaymentMethod
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStorePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
  }


  public PaymentRequest telephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
    return this;
  }

   /**
   * The shopper&#39;s telephone number.
   * @return telephoneNumber
  **/
  @ApiModelProperty(value = "The shopper's telephone number.")
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTelephoneNumber() {
    return telephoneNumber;
  }


 /**
  * The shopper&#39;s telephone number.
  *
  * @param telephoneNumber
  */ 
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }


  public PaymentRequest threeDS2RequestData(ThreeDS2RequestFields threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
    return this;
  }

   /**
   * Get threeDS2RequestData
   * @return threeDS2RequestData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDS2RequestFields getThreeDS2RequestData() {
    return threeDS2RequestData;
  }


 /**
  * threeDS2RequestData
  *
  * @param threeDS2RequestData
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2RequestData(ThreeDS2RequestFields threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
  }


  @Deprecated
  public PaymentRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    return this;
  }

   /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   * @return threeDSAuthenticationOnly
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getThreeDSAuthenticationOnly() {
    return threeDSAuthenticationOnly;
  }


 /**
  * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
  *
  * @param threeDSAuthenticationOnly
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
  }


  public PaymentRequest trustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
    return this;
  }

   /**
   * Set to true if the payment should be routed to a trusted MID.
   * @return trustedShopper
  **/
  @ApiModelProperty(value = "Set to true if the payment should be routed to a trusted MID.")
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTrustedShopper() {
    return trustedShopper;
  }


 /**
  * Set to true if the payment should be routed to a trusted MID.
  *
  * @param trustedShopper
  */ 
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
  }


  /**
   * Return true if this PaymentRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentRequest paymentRequest = (PaymentRequest) o;
    return Objects.equals(this.accountInfo, paymentRequest.accountInfo) &&
        Objects.equals(this.additionalAmount, paymentRequest.additionalAmount) &&
        Objects.equals(this.additionalData, paymentRequest.additionalData) &&
        Objects.equals(this.amount, paymentRequest.amount) &&
        Objects.equals(this.applicationInfo, paymentRequest.applicationInfo) &&
        Objects.equals(this.authenticationData, paymentRequest.authenticationData) &&
        Objects.equals(this.billingAddress, paymentRequest.billingAddress) &&
        Objects.equals(this.browserInfo, paymentRequest.browserInfo) &&
        Objects.equals(this.captureDelayHours, paymentRequest.captureDelayHours) &&
        Objects.equals(this.channel, paymentRequest.channel) &&
        Objects.equals(this.checkoutAttemptId, paymentRequest.checkoutAttemptId) &&
        Objects.equals(this.company, paymentRequest.company) &&
        Objects.equals(this.conversionId, paymentRequest.conversionId) &&
        Objects.equals(this.countryCode, paymentRequest.countryCode) &&
        Objects.equals(this.dateOfBirth, paymentRequest.dateOfBirth) &&
        Objects.equals(this.dccQuote, paymentRequest.dccQuote) &&
        Objects.equals(this.deliverAt, paymentRequest.deliverAt) &&
        Objects.equals(this.deliveryAddress, paymentRequest.deliveryAddress) &&
        Objects.equals(this.deliveryDate, paymentRequest.deliveryDate) &&
        Objects.equals(this.deviceFingerprint, paymentRequest.deviceFingerprint) &&
        Objects.equals(this.enableOneClick, paymentRequest.enableOneClick) &&
        Objects.equals(this.enablePayOut, paymentRequest.enablePayOut) &&
        Objects.equals(this.enableRecurring, paymentRequest.enableRecurring) &&
        Objects.equals(this.entityType, paymentRequest.entityType) &&
        Objects.equals(this.fraudOffset, paymentRequest.fraudOffset) &&
        Objects.equals(this.fundOrigin, paymentRequest.fundOrigin) &&
        Objects.equals(this.fundRecipient, paymentRequest.fundRecipient) &&
        Objects.equals(this.industryUsage, paymentRequest.industryUsage) &&
        Objects.equals(this.installments, paymentRequest.installments) &&
        Objects.equals(this.lineItems, paymentRequest.lineItems) &&
        Objects.equals(this.localizedShopperStatement, paymentRequest.localizedShopperStatement) &&
        Objects.equals(this.mandate, paymentRequest.mandate) &&
        Objects.equals(this.mcc, paymentRequest.mcc) &&
        Objects.equals(this.merchantAccount, paymentRequest.merchantAccount) &&
        Objects.equals(this.merchantOrderReference, paymentRequest.merchantOrderReference) &&
        Objects.equals(this.merchantRiskIndicator, paymentRequest.merchantRiskIndicator) &&
        Objects.equals(this.metadata, paymentRequest.metadata) &&
        Objects.equals(this.mpiData, paymentRequest.mpiData) &&
        Objects.equals(this.order, paymentRequest.order) &&
        Objects.equals(this.orderReference, paymentRequest.orderReference) &&
        Objects.equals(this.origin, paymentRequest.origin) &&
        Objects.equals(this.paymentMethod, paymentRequest.paymentMethod) &&
        Objects.equals(this.platformChargebackLogic, paymentRequest.platformChargebackLogic) &&
        Objects.equals(this.recurringExpiry, paymentRequest.recurringExpiry) &&
        Objects.equals(this.recurringFrequency, paymentRequest.recurringFrequency) &&
        Objects.equals(this.recurringProcessingModel, paymentRequest.recurringProcessingModel) &&
        Objects.equals(this.redirectFromIssuerMethod, paymentRequest.redirectFromIssuerMethod) &&
        Objects.equals(this.redirectToIssuerMethod, paymentRequest.redirectToIssuerMethod) &&
        Objects.equals(this.reference, paymentRequest.reference) &&
        Objects.equals(this.returnUrl, paymentRequest.returnUrl) &&
        Objects.equals(this.riskData, paymentRequest.riskData) &&
        Objects.equals(this.sessionValidity, paymentRequest.sessionValidity) &&
        Objects.equals(this.shopperEmail, paymentRequest.shopperEmail) &&
        Objects.equals(this.shopperIP, paymentRequest.shopperIP) &&
        Objects.equals(this.shopperInteraction, paymentRequest.shopperInteraction) &&
        Objects.equals(this.shopperLocale, paymentRequest.shopperLocale) &&
        Objects.equals(this.shopperName, paymentRequest.shopperName) &&
        Objects.equals(this.shopperReference, paymentRequest.shopperReference) &&
        Objects.equals(this.shopperStatement, paymentRequest.shopperStatement) &&
        Objects.equals(this.socialSecurityNumber, paymentRequest.socialSecurityNumber) &&
        Objects.equals(this.splits, paymentRequest.splits) &&
        Objects.equals(this.store, paymentRequest.store) &&
        Objects.equals(this.storePaymentMethod, paymentRequest.storePaymentMethod) &&
        Objects.equals(this.telephoneNumber, paymentRequest.telephoneNumber) &&
        Objects.equals(this.threeDS2RequestData, paymentRequest.threeDS2RequestData) &&
        Objects.equals(this.threeDSAuthenticationOnly, paymentRequest.threeDSAuthenticationOnly) &&
        Objects.equals(this.trustedShopper, paymentRequest.trustedShopper);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountInfo, additionalAmount, additionalData, amount, applicationInfo, authenticationData, billingAddress, browserInfo, captureDelayHours, channel, checkoutAttemptId, company, conversionId, countryCode, dateOfBirth, dccQuote, deliverAt, deliveryAddress, deliveryDate, deviceFingerprint, enableOneClick, enablePayOut, enableRecurring, entityType, fraudOffset, fundOrigin, fundRecipient, industryUsage, installments, lineItems, localizedShopperStatement, mandate, mcc, merchantAccount, merchantOrderReference, merchantRiskIndicator, metadata, mpiData, order, orderReference, origin, paymentMethod, platformChargebackLogic, recurringExpiry, recurringFrequency, recurringProcessingModel, redirectFromIssuerMethod, redirectToIssuerMethod, reference, returnUrl, riskData, sessionValidity, shopperEmail, shopperIP, shopperInteraction, shopperLocale, shopperName, shopperReference, shopperStatement, socialSecurityNumber, splits, store, storePaymentMethod, telephoneNumber, threeDS2RequestData, threeDSAuthenticationOnly, trustedShopper);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentRequest {\n");
    sb.append("    accountInfo: ").append(toIndentedString(accountInfo)).append("\n");
    sb.append("    additionalAmount: ").append(toIndentedString(additionalAmount)).append("\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    authenticationData: ").append(toIndentedString(authenticationData)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    browserInfo: ").append(toIndentedString(browserInfo)).append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    conversionId: ").append(toIndentedString(conversionId)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    dccQuote: ").append(toIndentedString(dccQuote)).append("\n");
    sb.append("    deliverAt: ").append(toIndentedString(deliverAt)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    deliveryDate: ").append(toIndentedString(deliveryDate)).append("\n");
    sb.append("    deviceFingerprint: ").append(toIndentedString(deviceFingerprint)).append("\n");
    sb.append("    enableOneClick: ").append(toIndentedString(enableOneClick)).append("\n");
    sb.append("    enablePayOut: ").append(toIndentedString(enablePayOut)).append("\n");
    sb.append("    enableRecurring: ").append(toIndentedString(enableRecurring)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    fraudOffset: ").append(toIndentedString(fraudOffset)).append("\n");
    sb.append("    fundOrigin: ").append(toIndentedString(fundOrigin)).append("\n");
    sb.append("    fundRecipient: ").append(toIndentedString(fundRecipient)).append("\n");
    sb.append("    industryUsage: ").append(toIndentedString(industryUsage)).append("\n");
    sb.append("    installments: ").append(toIndentedString(installments)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    localizedShopperStatement: ").append(toIndentedString(localizedShopperStatement)).append("\n");
    sb.append("    mandate: ").append(toIndentedString(mandate)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ").append(toIndentedString(merchantOrderReference)).append("\n");
    sb.append("    merchantRiskIndicator: ").append(toIndentedString(merchantRiskIndicator)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    mpiData: ").append(toIndentedString(mpiData)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    orderReference: ").append(toIndentedString(orderReference)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    platformChargebackLogic: ").append(toIndentedString(platformChargebackLogic)).append("\n");
    sb.append("    recurringExpiry: ").append(toIndentedString(recurringExpiry)).append("\n");
    sb.append("    recurringFrequency: ").append(toIndentedString(recurringFrequency)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    redirectFromIssuerMethod: ").append(toIndentedString(redirectFromIssuerMethod)).append("\n");
    sb.append("    redirectToIssuerMethod: ").append(toIndentedString(redirectToIssuerMethod)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    riskData: ").append(toIndentedString(riskData)).append("\n");
    sb.append("    sessionValidity: ").append(toIndentedString(sessionValidity)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperIP: ").append(toIndentedString(shopperIP)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storePaymentMethod: ").append(toIndentedString(storePaymentMethod)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    threeDS2RequestData: ").append(toIndentedString(threeDS2RequestData)).append("\n");
    sb.append("    threeDSAuthenticationOnly: ").append(toIndentedString(threeDSAuthenticationOnly)).append("\n");
    sb.append("    trustedShopper: ").append(toIndentedString(trustedShopper)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentRequest
   */
  public static PaymentRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentRequest.class);
  }
/**
  * Convert an instance of PaymentRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

