/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.CheckoutSessionThreeDS2RequestData;
import com.adyen.model.checkout.InstallmentOption;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentLinkResponse
 */
@JsonPropertyOrder({
  PaymentLinkResponse.JSON_PROPERTY_ALLOWED_PAYMENT_METHODS,
  PaymentLinkResponse.JSON_PROPERTY_AMOUNT,
  PaymentLinkResponse.JSON_PROPERTY_APPLICATION_INFO,
  PaymentLinkResponse.JSON_PROPERTY_BILLING_ADDRESS,
  PaymentLinkResponse.JSON_PROPERTY_BLOCKED_PAYMENT_METHODS,
  PaymentLinkResponse.JSON_PROPERTY_CAPTURE_DELAY_HOURS,
  PaymentLinkResponse.JSON_PROPERTY_COUNTRY_CODE,
  PaymentLinkResponse.JSON_PROPERTY_DATE_OF_BIRTH,
  PaymentLinkResponse.JSON_PROPERTY_DELIVER_AT,
  PaymentLinkResponse.JSON_PROPERTY_DELIVERY_ADDRESS,
  PaymentLinkResponse.JSON_PROPERTY_DESCRIPTION,
  PaymentLinkResponse.JSON_PROPERTY_EXPIRES_AT,
  PaymentLinkResponse.JSON_PROPERTY_ID,
  PaymentLinkResponse.JSON_PROPERTY_INSTALLMENT_OPTIONS,
  PaymentLinkResponse.JSON_PROPERTY_LINE_ITEMS,
  PaymentLinkResponse.JSON_PROPERTY_MANUAL_CAPTURE,
  PaymentLinkResponse.JSON_PROPERTY_MCC,
  PaymentLinkResponse.JSON_PROPERTY_MERCHANT_ACCOUNT,
  PaymentLinkResponse.JSON_PROPERTY_MERCHANT_ORDER_REFERENCE,
  PaymentLinkResponse.JSON_PROPERTY_METADATA,
  PaymentLinkResponse.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  PaymentLinkResponse.JSON_PROPERTY_REFERENCE,
  PaymentLinkResponse.JSON_PROPERTY_REQUIRED_SHOPPER_FIELDS,
  PaymentLinkResponse.JSON_PROPERTY_RETURN_URL,
  PaymentLinkResponse.JSON_PROPERTY_REUSABLE,
  PaymentLinkResponse.JSON_PROPERTY_RISK_DATA,
  PaymentLinkResponse.JSON_PROPERTY_SHOPPER_EMAIL,
  PaymentLinkResponse.JSON_PROPERTY_SHOPPER_LOCALE,
  PaymentLinkResponse.JSON_PROPERTY_SHOPPER_NAME,
  PaymentLinkResponse.JSON_PROPERTY_SHOPPER_REFERENCE,
  PaymentLinkResponse.JSON_PROPERTY_SHOPPER_STATEMENT,
  PaymentLinkResponse.JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON,
  PaymentLinkResponse.JSON_PROPERTY_SOCIAL_SECURITY_NUMBER,
  PaymentLinkResponse.JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES,
  PaymentLinkResponse.JSON_PROPERTY_SPLITS,
  PaymentLinkResponse.JSON_PROPERTY_STATUS,
  PaymentLinkResponse.JSON_PROPERTY_STORE,
  PaymentLinkResponse.JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE,
  PaymentLinkResponse.JSON_PROPERTY_TELEPHONE_NUMBER,
  PaymentLinkResponse.JSON_PROPERTY_THEME_ID,
  PaymentLinkResponse.JSON_PROPERTY_THREE_D_S2_REQUEST_DATA,
  PaymentLinkResponse.JSON_PROPERTY_UPDATED_AT,
  PaymentLinkResponse.JSON_PROPERTY_URL
})

public class PaymentLinkResponse {
  public static final String JSON_PROPERTY_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
  private List<String> allowedPaymentMethods = null;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private Address billingAddress;

  public static final String JSON_PROPERTY_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
  private List<String> blockedPaymentMethods = null;

  public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
  private Integer captureDelayHours;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private LocalDate dateOfBirth;

  public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
  private OffsetDateTime deliverAt;

  public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
  private Address deliveryAddress;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INSTALLMENT_OPTIONS = "installmentOptions";
  private Map<String, InstallmentOption> installmentOptions = null;

  public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
  private List<LineItem> lineItems = null;

  public static final String JSON_PROPERTY_MANUAL_CAPTURE = "manualCapture";
  private Boolean manualCapture;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  private String merchantOrderReference;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  /**
   * Defines a recurring payment type. Required when &#x60;storePaymentMethodMode&#x60; is set to **askForConsent** or **enabled**. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE("CardOnFile"),
    
    SUBSCRIPTION("Subscription"),
    
    UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  /**
   * Gets or Sets requiredShopperFields
   */
  public enum RequiredShopperFieldsEnum {
    BILLINGADDRESS("billingAddress"),
    
    DELIVERYADDRESS("deliveryAddress"),
    
    SHOPPEREMAIL("shopperEmail"),
    
    SHOPPERNAME("shopperName"),
    
    TELEPHONENUMBER("telephoneNumber");

    private String value;

    RequiredShopperFieldsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequiredShopperFieldsEnum fromValue(String value) {
      for (RequiredShopperFieldsEnum b : RequiredShopperFieldsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUIRED_SHOPPER_FIELDS = "requiredShopperFields";
  private List<RequiredShopperFieldsEnum> requiredShopperFields = null;

  public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
  private String returnUrl;

  public static final String JSON_PROPERTY_REUSABLE = "reusable";
  private Boolean reusable;

  public static final String JSON_PROPERTY_RISK_DATA = "riskData";
  private RiskData riskData;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
  private Name shopperName;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
  private String shopperStatement;

  public static final String JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON = "showRemovePaymentMethodButton";
  private Boolean showRemovePaymentMethodButton;

  public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  private String socialSecurityNumber;

  public static final String JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
  private Boolean splitCardFundingSources;

  public static final String JSON_PROPERTY_SPLITS = "splits";
  private List<Split> splits = null;

  /**
   * Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.
   */
  public enum StatusEnum {
    ACTIVE("active"),
    
    COMPLETED("completed"),
    
    EXPIRED("expired"),
    
    PAID("paid"),
    
    PAYMENTPENDING("paymentPending");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.   When set to **askForConsent** or **enabled**, you must also include the &#x60;recurringProcessingModel&#x60; parameter.
   */
  public enum StorePaymentMethodModeEnum {
    ASKFORCONSENT("askForConsent"),
    
    DISABLED("disabled"),
    
    ENABLED("enabled");

    private String value;

    StorePaymentMethodModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StorePaymentMethodModeEnum fromValue(String value) {
      for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
  private StorePaymentMethodModeEnum storePaymentMethodMode;

  public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
  private String telephoneNumber;

  public static final String JSON_PROPERTY_THEME_ID = "themeId";
  private String themeId;

  public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
  private CheckoutSessionThreeDS2RequestData threeDS2RequestData;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public PaymentLinkResponse() { 
  }

  public PaymentLinkResponse allowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
    return this;
  }

  public PaymentLinkResponse addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
    if (this.allowedPaymentMethods == null) {
      this.allowedPaymentMethods = new ArrayList<>();
    }
    this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
    return this;
  }

   /**
   * List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
   * @return allowedPaymentMethods
  **/
  @ApiModelProperty(value = "List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")
  @JsonProperty(JSON_PROPERTY_ALLOWED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAllowedPaymentMethods() {
    return allowedPaymentMethods;
  }


 /**
  * List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
  *
  * @param allowedPaymentMethods
  */ 
  @JsonProperty(JSON_PROPERTY_ALLOWED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
  }


  public PaymentLinkResponse amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


 /**
  * amount
  *
  * @param amount
  */ 
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public PaymentLinkResponse applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

   /**
   * Get applicationInfo
   * @return applicationInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }


 /**
  * applicationInfo
  *
  * @param applicationInfo
  */ 
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }


  public PaymentLinkResponse billingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getBillingAddress() {
    return billingAddress;
  }


 /**
  * billingAddress
  *
  * @param billingAddress
  */ 
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }


  public PaymentLinkResponse blockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
    return this;
  }

  public PaymentLinkResponse addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
    if (this.blockedPaymentMethods == null) {
      this.blockedPaymentMethods = new ArrayList<>();
    }
    this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
    return this;
  }

   /**
   * List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
   * @return blockedPaymentMethods
  **/
  @ApiModelProperty(value = "List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")
  @JsonProperty(JSON_PROPERTY_BLOCKED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBlockedPaymentMethods() {
    return blockedPaymentMethods;
  }


 /**
  * List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
  *
  * @param blockedPaymentMethods
  */ 
  @JsonProperty(JSON_PROPERTY_BLOCKED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
  }


  public PaymentLinkResponse captureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
    return this;
  }

   /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   * @return captureDelayHours
  **/
  @ApiModelProperty(value = "The delay between the authorisation and scheduled auto-capture, specified in hours.")
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }


 /**
  * The delay between the authorisation and scheduled auto-capture, specified in hours.
  *
  * @param captureDelayHours
  */ 
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }


  public PaymentLinkResponse countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The shopper&#39;s two-letter country code.
   * @return countryCode
  **/
  @ApiModelProperty(value = "The shopper's two-letter country code.")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


 /**
  * The shopper&#39;s two-letter country code.
  *
  * @param countryCode
  */ 
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PaymentLinkResponse dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   * @return dateOfBirth
  **/
  @ApiModelProperty(value = "The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }


 /**
  * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
  *
  * @param dateOfBirth
  */ 
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public PaymentLinkResponse deliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
    return this;
  }

   /**
   * The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   * @return deliverAt
  **/
  @ApiModelProperty(value = "The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDeliverAt() {
    return deliverAt;
  }


 /**
  * The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
  *
  * @param deliverAt
  */ 
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
  }


  public PaymentLinkResponse deliveryAddress(Address deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

   /**
   * Get deliveryAddress
   * @return deliveryAddress
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getDeliveryAddress() {
    return deliveryAddress;
  }


 /**
  * deliveryAddress
  *
  * @param deliveryAddress
  */ 
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryAddress(Address deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }


  public PaymentLinkResponse description(String description) {
    this.description = description;
    return this;
  }

   /**
   * A short description visible on the payment page. Maximum length: 280 characters.
   * @return description
  **/
  @ApiModelProperty(value = "A short description visible on the payment page. Maximum length: 280 characters.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


 /**
  * A short description visible on the payment page. Maximum length: 280 characters.
  *
  * @param description
  */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public PaymentLinkResponse expiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format with time zone offset: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.
   * @return expiresAt
  **/
  @ApiModelProperty(value = "The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format with time zone offset: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


 /**
  * The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format with time zone offset: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.
  *
  * @param expiresAt
  */ 
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public PaymentLinkResponse id(String id) {
    this.id = id;
    return this;
  }

   /**
   * A unique identifier of the payment link.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "A unique identifier of the payment link.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * A unique identifier of the payment link.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PaymentLinkResponse installmentOptions(Map<String, InstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
    return this;
  }

  public PaymentLinkResponse putInstallmentOptionsItem(String key, InstallmentOption installmentOptionsItem) {
    if (this.installmentOptions == null) {
      this.installmentOptions = new HashMap<>();
    }
    this.installmentOptions.put(key, installmentOptionsItem);
    return this;
  }

   /**
   * A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.
   * @return installmentOptions
  **/
  @ApiModelProperty(value = "A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.")
  @JsonProperty(JSON_PROPERTY_INSTALLMENT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, InstallmentOption> getInstallmentOptions() {
    return installmentOptions;
  }


 /**
  * A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.
  *
  * @param installmentOptions
  */ 
  @JsonProperty(JSON_PROPERTY_INSTALLMENT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallmentOptions(Map<String, InstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
  }


  public PaymentLinkResponse lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  public PaymentLinkResponse addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.
   * @return lineItems
  **/
  @ApiModelProperty(value = "Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.")
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LineItem> getLineItems() {
    return lineItems;
  }


 /**
  * Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.
  *
  * @param lineItems
  */ 
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public PaymentLinkResponse manualCapture(Boolean manualCapture) {
    this.manualCapture = manualCapture;
    return this;
  }

   /**
   * Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).
   * @return manualCapture
  **/
  @ApiModelProperty(value = "Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).")
  @JsonProperty(JSON_PROPERTY_MANUAL_CAPTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getManualCapture() {
    return manualCapture;
  }


 /**
  * Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).
  *
  * @param manualCapture
  */ 
  @JsonProperty(JSON_PROPERTY_MANUAL_CAPTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManualCapture(Boolean manualCapture) {
    this.manualCapture = manualCapture;
  }


  public PaymentLinkResponse mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

   /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   * @return mcc
  **/
  @ApiModelProperty(value = "The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMcc() {
    return mcc;
  }


 /**
  * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
  *
  * @param mcc
  */ 
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public PaymentLinkResponse merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account identifier for which the payment link is created.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account identifier for which the payment link is created.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantAccount() {
    return merchantAccount;
  }


 /**
  * The merchant account identifier for which the payment link is created.
  *
  * @param merchantAccount
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public PaymentLinkResponse merchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

   /**
   * This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.
   * @return merchantOrderReference
  **/
  @ApiModelProperty(value = "This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }


 /**
  * This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.
  *
  * @param merchantOrderReference
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }


  public PaymentLinkResponse metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public PaymentLinkResponse putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \&quot;177\&quot; occurs: \&quot;Metadata size exceeds limit\&quot; * Maximum 20 characters per key. Otherwise, error \&quot;178\&quot; occurs: \&quot;Metadata key size exceeds limit\&quot; * A key cannot have the name &#x60;checkout.linkId&#x60;. Any value that you provide with this key is going to be replaced by the real payment link ID.
   * @return metadata
  **/
  @ApiModelProperty(value = "Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \"177\" occurs: \"Metadata size exceeds limit\" * Maximum 20 characters per key. Otherwise, error \"178\" occurs: \"Metadata key size exceeds limit\" * A key cannot have the name `checkout.linkId`. Any value that you provide with this key is going to be replaced by the real payment link ID.")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


 /**
  * Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \&quot;177\&quot; occurs: \&quot;Metadata size exceeds limit\&quot; * Maximum 20 characters per key. Otherwise, error \&quot;178\&quot; occurs: \&quot;Metadata key size exceeds limit\&quot; * A key cannot have the name &#x60;checkout.linkId&#x60;. Any value that you provide with this key is going to be replaced by the real payment link ID.
  *
  * @param metadata
  */ 
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PaymentLinkResponse recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

   /**
   * Defines a recurring payment type. Required when &#x60;storePaymentMethodMode&#x60; is set to **askForConsent** or **enabled**. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel
  **/
  @ApiModelProperty(value = "Defines a recurring payment type. Required when `storePaymentMethodMode` is set to **askForConsent** or **enabled**. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }


 /**
  * Defines a recurring payment type. Required when &#x60;storePaymentMethodMode&#x60; is set to **askForConsent** or **enabled**. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
  *
  * @param recurringProcessingModel
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }


  public PaymentLinkResponse reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * A reference that is used to uniquely identify the payment in future communications about the payment status.
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "A reference that is used to uniquely identify the payment in future communications about the payment status.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


 /**
  * A reference that is used to uniquely identify the payment in future communications about the payment status.
  *
  * @param reference
  */ 
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public PaymentLinkResponse requiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
    this.requiredShopperFields = requiredShopperFields;
    return this;
  }

  public PaymentLinkResponse addRequiredShopperFieldsItem(RequiredShopperFieldsEnum requiredShopperFieldsItem) {
    if (this.requiredShopperFields == null) {
      this.requiredShopperFields = new ArrayList<>();
    }
    this.requiredShopperFields.add(requiredShopperFieldsItem);
    return this;
  }

   /**
   * List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** – The address where to send the invoice. * **deliveryAddress** – The address where the purchased goods should be delivered. * **shopperEmail** – The shopper&#39;s email address. * **shopperName** – The shopper&#39;s full name. * **telephoneNumber** – The shopper&#39;s phone number. 
   * @return requiredShopperFields
  **/
  @ApiModelProperty(value = "List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** – The address where to send the invoice. * **deliveryAddress** – The address where the purchased goods should be delivered. * **shopperEmail** – The shopper's email address. * **shopperName** – The shopper's full name. * **telephoneNumber** – The shopper's phone number. ")
  @JsonProperty(JSON_PROPERTY_REQUIRED_SHOPPER_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RequiredShopperFieldsEnum> getRequiredShopperFields() {
    return requiredShopperFields;
  }


 /**
  * List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** – The address where to send the invoice. * **deliveryAddress** – The address where the purchased goods should be delivered. * **shopperEmail** – The shopper&#39;s email address. * **shopperName** – The shopper&#39;s full name. * **telephoneNumber** – The shopper&#39;s phone number. 
  *
  * @param requiredShopperFields
  */ 
  @JsonProperty(JSON_PROPERTY_REQUIRED_SHOPPER_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
    this.requiredShopperFields = requiredShopperFields;
  }


  public PaymentLinkResponse returnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.
   * @return returnUrl
  **/
  @ApiModelProperty(value = "Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.")
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnUrl() {
    return returnUrl;
  }


 /**
  * Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.
  *
  * @param returnUrl
  */ 
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }


  public PaymentLinkResponse reusable(Boolean reusable) {
    this.reusable = reusable;
    return this;
  }

   /**
   * Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.
   * @return reusable
  **/
  @ApiModelProperty(value = "Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.")
  @JsonProperty(JSON_PROPERTY_REUSABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReusable() {
    return reusable;
  }


 /**
  * Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.
  *
  * @param reusable
  */ 
  @JsonProperty(JSON_PROPERTY_REUSABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReusable(Boolean reusable) {
    this.reusable = reusable;
  }


  public PaymentLinkResponse riskData(RiskData riskData) {
    this.riskData = riskData;
    return this;
  }

   /**
   * Get riskData
   * @return riskData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RiskData getRiskData() {
    return riskData;
  }


 /**
  * riskData
  *
  * @param riskData
  */ 
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskData(RiskData riskData) {
    this.riskData = riskData;
  }


  public PaymentLinkResponse shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The shopper&#39;s email address.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The shopper's email address.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperEmail() {
    return shopperEmail;
  }


 /**
  * The shopper&#39;s email address.
  *
  * @param shopperEmail
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public PaymentLinkResponse shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

   /**
   * The language to be used in the payment page, specified by a combination of a language and country code. For example, &#x60;en-US&#x60;.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).
   * @return shopperLocale
  **/
  @ApiModelProperty(value = "The language to be used in the payment page, specified by a combination of a language and country code. For example, `en-US`.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).")
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperLocale() {
    return shopperLocale;
  }


 /**
  * The language to be used in the payment page, specified by a combination of a language and country code. For example, &#x60;en-US&#x60;.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).
  *
  * @param shopperLocale
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }


  public PaymentLinkResponse shopperName(Name shopperName) {
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Name getShopperName() {
    return shopperName;
  }


 /**
  * shopperName
  *
  * @param shopperName
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public PaymentLinkResponse shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperReference() {
    return shopperReference;
  }


 /**
  * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
  *
  * @param shopperReference
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public PaymentLinkResponse shopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
    return this;
  }

   /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   * @return shopperStatement
  **/
  @ApiModelProperty(value = "The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperStatement() {
    return shopperStatement;
  }


 /**
  * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
  *
  * @param shopperStatement
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }


  public PaymentLinkResponse showRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
    return this;
  }

   /**
   * Set to **false** to hide the button that lets the shopper remove a stored payment method.
   * @return showRemovePaymentMethodButton
  **/
  @ApiModelProperty(value = "Set to **false** to hide the button that lets the shopper remove a stored payment method.")
  @JsonProperty(JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRemovePaymentMethodButton() {
    return showRemovePaymentMethodButton;
  }


 /**
  * Set to **false** to hide the button that lets the shopper remove a stored payment method.
  *
  * @param showRemovePaymentMethodButton
  */ 
  @JsonProperty(JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
  }


  public PaymentLinkResponse socialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

   /**
   * The shopper&#39;s social security number.
   * @return socialSecurityNumber
  **/
  @ApiModelProperty(value = "The shopper's social security number.")
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }


 /**
  * The shopper&#39;s social security number.
  *
  * @param socialSecurityNumber
  */ 
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }


  public PaymentLinkResponse splitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
    return this;
  }

   /**
   * Boolean value indicating whether the card payment method should be split into separate debit and credit options.
   * @return splitCardFundingSources
  **/
  @ApiModelProperty(value = "Boolean value indicating whether the card payment method should be split into separate debit and credit options.")
  @JsonProperty(JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSplitCardFundingSources() {
    return splitCardFundingSources;
  }


 /**
  * Boolean value indicating whether the card payment method should be split into separate debit and credit options.
  *
  * @param splitCardFundingSources
  */ 
  @JsonProperty(JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
  }


  public PaymentLinkResponse splits(List<Split> splits) {
    this.splits = splits;
    return this;
  }

  public PaymentLinkResponse addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

   /**
   * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   * @return splits
  **/
  @ApiModelProperty(value = "An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).")
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Split> getSplits() {
    return splits;
  }


 /**
  * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
  *
  * @param splits
  */ 
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }


  public PaymentLinkResponse status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


 /**
  * Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.
  *
  * @param status
  */ 
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public PaymentLinkResponse store(String store) {
    this.store = store;
    return this;
  }

   /**
   * The physical store, for which this payment is processed.
   * @return store
  **/
  @ApiModelProperty(value = "The physical store, for which this payment is processed.")
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStore() {
    return store;
  }


 /**
  * The physical store, for which this payment is processed.
  *
  * @param store
  */ 
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }


  public PaymentLinkResponse storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
    return this;
  }

   /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.   When set to **askForConsent** or **enabled**, you must also include the &#x60;recurringProcessingModel&#x60; parameter.
   * @return storePaymentMethodMode
  **/
  @ApiModelProperty(value = "Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.   When set to **askForConsent** or **enabled**, you must also include the `recurringProcessingModel` parameter.")
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
    return storePaymentMethodMode;
  }


 /**
  * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.   When set to **askForConsent** or **enabled**, you must also include the &#x60;recurringProcessingModel&#x60; parameter.
  *
  * @param storePaymentMethodMode
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
  }


  public PaymentLinkResponse telephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
    return this;
  }

   /**
   * The shopper&#39;s telephone number.
   * @return telephoneNumber
  **/
  @ApiModelProperty(value = "The shopper's telephone number.")
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTelephoneNumber() {
    return telephoneNumber;
  }


 /**
  * The shopper&#39;s telephone number.
  *
  * @param telephoneNumber
  */ 
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }


  public PaymentLinkResponse themeId(String themeId) {
    this.themeId = themeId;
    return this;
  }

   /**
   * A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.
   * @return themeId
  **/
  @ApiModelProperty(value = "A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.")
  @JsonProperty(JSON_PROPERTY_THEME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThemeId() {
    return themeId;
  }


 /**
  * A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.
  *
  * @param themeId
  */ 
  @JsonProperty(JSON_PROPERTY_THEME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeId(String themeId) {
    this.themeId = themeId;
  }


  public PaymentLinkResponse threeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
    return this;
  }

   /**
   * Get threeDS2RequestData
   * @return threeDS2RequestData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CheckoutSessionThreeDS2RequestData getThreeDS2RequestData() {
    return threeDS2RequestData;
  }


 /**
  * threeDS2RequestData
  *
  * @param threeDS2RequestData
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
  }


  public PaymentLinkResponse updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   * @return updatedAt
  **/
  @ApiModelProperty(value = "The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


 /**
  * The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
  *
  * @param updatedAt
  */ 
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public PaymentLinkResponse url(String url) {
    this.url = url;
    return this;
  }

   /**
   * The URL at which the shopper can complete the payment.
   * @return url
  **/
  @ApiModelProperty(required = true, value = "The URL at which the shopper can complete the payment.")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


 /**
  * The URL at which the shopper can complete the payment.
  *
  * @param url
  */ 
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }


  /**
   * Return true if this PaymentLinkResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentLinkResponse paymentLinkResponse = (PaymentLinkResponse) o;
    return Objects.equals(this.allowedPaymentMethods, paymentLinkResponse.allowedPaymentMethods) &&
        Objects.equals(this.amount, paymentLinkResponse.amount) &&
        Objects.equals(this.applicationInfo, paymentLinkResponse.applicationInfo) &&
        Objects.equals(this.billingAddress, paymentLinkResponse.billingAddress) &&
        Objects.equals(this.blockedPaymentMethods, paymentLinkResponse.blockedPaymentMethods) &&
        Objects.equals(this.captureDelayHours, paymentLinkResponse.captureDelayHours) &&
        Objects.equals(this.countryCode, paymentLinkResponse.countryCode) &&
        Objects.equals(this.dateOfBirth, paymentLinkResponse.dateOfBirth) &&
        Objects.equals(this.deliverAt, paymentLinkResponse.deliverAt) &&
        Objects.equals(this.deliveryAddress, paymentLinkResponse.deliveryAddress) &&
        Objects.equals(this.description, paymentLinkResponse.description) &&
        Objects.equals(this.expiresAt, paymentLinkResponse.expiresAt) &&
        Objects.equals(this.id, paymentLinkResponse.id) &&
        Objects.equals(this.installmentOptions, paymentLinkResponse.installmentOptions) &&
        Objects.equals(this.lineItems, paymentLinkResponse.lineItems) &&
        Objects.equals(this.manualCapture, paymentLinkResponse.manualCapture) &&
        Objects.equals(this.mcc, paymentLinkResponse.mcc) &&
        Objects.equals(this.merchantAccount, paymentLinkResponse.merchantAccount) &&
        Objects.equals(this.merchantOrderReference, paymentLinkResponse.merchantOrderReference) &&
        Objects.equals(this.metadata, paymentLinkResponse.metadata) &&
        Objects.equals(this.recurringProcessingModel, paymentLinkResponse.recurringProcessingModel) &&
        Objects.equals(this.reference, paymentLinkResponse.reference) &&
        Objects.equals(this.requiredShopperFields, paymentLinkResponse.requiredShopperFields) &&
        Objects.equals(this.returnUrl, paymentLinkResponse.returnUrl) &&
        Objects.equals(this.reusable, paymentLinkResponse.reusable) &&
        Objects.equals(this.riskData, paymentLinkResponse.riskData) &&
        Objects.equals(this.shopperEmail, paymentLinkResponse.shopperEmail) &&
        Objects.equals(this.shopperLocale, paymentLinkResponse.shopperLocale) &&
        Objects.equals(this.shopperName, paymentLinkResponse.shopperName) &&
        Objects.equals(this.shopperReference, paymentLinkResponse.shopperReference) &&
        Objects.equals(this.shopperStatement, paymentLinkResponse.shopperStatement) &&
        Objects.equals(this.showRemovePaymentMethodButton, paymentLinkResponse.showRemovePaymentMethodButton) &&
        Objects.equals(this.socialSecurityNumber, paymentLinkResponse.socialSecurityNumber) &&
        Objects.equals(this.splitCardFundingSources, paymentLinkResponse.splitCardFundingSources) &&
        Objects.equals(this.splits, paymentLinkResponse.splits) &&
        Objects.equals(this.status, paymentLinkResponse.status) &&
        Objects.equals(this.store, paymentLinkResponse.store) &&
        Objects.equals(this.storePaymentMethodMode, paymentLinkResponse.storePaymentMethodMode) &&
        Objects.equals(this.telephoneNumber, paymentLinkResponse.telephoneNumber) &&
        Objects.equals(this.themeId, paymentLinkResponse.themeId) &&
        Objects.equals(this.threeDS2RequestData, paymentLinkResponse.threeDS2RequestData) &&
        Objects.equals(this.updatedAt, paymentLinkResponse.updatedAt) &&
        Objects.equals(this.url, paymentLinkResponse.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowedPaymentMethods, amount, applicationInfo, billingAddress, blockedPaymentMethods, captureDelayHours, countryCode, dateOfBirth, deliverAt, deliveryAddress, description, expiresAt, id, installmentOptions, lineItems, manualCapture, mcc, merchantAccount, merchantOrderReference, metadata, recurringProcessingModel, reference, requiredShopperFields, returnUrl, reusable, riskData, shopperEmail, shopperLocale, shopperName, shopperReference, shopperStatement, showRemovePaymentMethodButton, socialSecurityNumber, splitCardFundingSources, splits, status, store, storePaymentMethodMode, telephoneNumber, themeId, threeDS2RequestData, updatedAt, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentLinkResponse {\n");
    sb.append("    allowedPaymentMethods: ").append(toIndentedString(allowedPaymentMethods)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    blockedPaymentMethods: ").append(toIndentedString(blockedPaymentMethods)).append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    deliverAt: ").append(toIndentedString(deliverAt)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    installmentOptions: ").append(toIndentedString(installmentOptions)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    manualCapture: ").append(toIndentedString(manualCapture)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ").append(toIndentedString(merchantOrderReference)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    requiredShopperFields: ").append(toIndentedString(requiredShopperFields)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    reusable: ").append(toIndentedString(reusable)).append("\n");
    sb.append("    riskData: ").append(toIndentedString(riskData)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    showRemovePaymentMethodButton: ").append(toIndentedString(showRemovePaymentMethodButton)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    splitCardFundingSources: ").append(toIndentedString(splitCardFundingSources)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storePaymentMethodMode: ").append(toIndentedString(storePaymentMethodMode)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    themeId: ").append(toIndentedString(themeId)).append("\n");
    sb.append("    threeDS2RequestData: ").append(toIndentedString(threeDS2RequestData)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentLinkResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentLinkResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentLinkResponse
   */
  public static PaymentLinkResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentLinkResponse.class);
  }
/**
  * Convert an instance of PaymentLinkResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

