/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.BillingAddress;
import com.adyen.model.checkout.CheckoutSessionInstallmentOption;
import com.adyen.model.checkout.CheckoutSessionThreeDS2RequestData;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.DeliveryAddress;
import com.adyen.model.checkout.FundOrigin;
import com.adyen.model.checkout.FundRecipient;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CreateCheckoutSessionResponse
 */
@JsonPropertyOrder({
  CreateCheckoutSessionResponse.JSON_PROPERTY_ACCOUNT_INFO,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ADDITIONAL_AMOUNT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ADDITIONAL_DATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ALLOWED_PAYMENT_METHODS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_AMOUNT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_APPLICATION_INFO,
  CreateCheckoutSessionResponse.JSON_PROPERTY_AUTHENTICATION_DATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_BILLING_ADDRESS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_BLOCKED_PAYMENT_METHODS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_CAPTURE_DELAY_HOURS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_CHANNEL,
  CreateCheckoutSessionResponse.JSON_PROPERTY_COMPANY,
  CreateCheckoutSessionResponse.JSON_PROPERTY_COUNTRY_CODE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_DATE_OF_BIRTH,
  CreateCheckoutSessionResponse.JSON_PROPERTY_DELIVER_AT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_DELIVERY_ADDRESS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ENABLE_ONE_CLICK,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ENABLE_PAY_OUT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ENABLE_RECURRING,
  CreateCheckoutSessionResponse.JSON_PROPERTY_EXPIRES_AT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_FUND_ORIGIN,
  CreateCheckoutSessionResponse.JSON_PROPERTY_FUND_RECIPIENT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_ID,
  CreateCheckoutSessionResponse.JSON_PROPERTY_INSTALLMENT_OPTIONS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_LINE_ITEMS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_MANDATE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_MCC,
  CreateCheckoutSessionResponse.JSON_PROPERTY_MERCHANT_ACCOUNT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_MERCHANT_ORDER_REFERENCE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_METADATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_MODE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_MPI_DATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC,
  CreateCheckoutSessionResponse.JSON_PROPERTY_RECURRING_EXPIRY,
  CreateCheckoutSessionResponse.JSON_PROPERTY_RECURRING_FREQUENCY,
  CreateCheckoutSessionResponse.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  CreateCheckoutSessionResponse.JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD,
  CreateCheckoutSessionResponse.JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD,
  CreateCheckoutSessionResponse.JSON_PROPERTY_REFERENCE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_RETURN_URL,
  CreateCheckoutSessionResponse.JSON_PROPERTY_RISK_DATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SESSION_DATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_EMAIL,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_I_P,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_INTERACTION,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_LOCALE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_NAME,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_REFERENCE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOPPER_STATEMENT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SOCIAL_SECURITY_NUMBER,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES,
  CreateCheckoutSessionResponse.JSON_PROPERTY_SPLITS,
  CreateCheckoutSessionResponse.JSON_PROPERTY_STORE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_STORE_PAYMENT_METHOD,
  CreateCheckoutSessionResponse.JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE,
  CreateCheckoutSessionResponse.JSON_PROPERTY_TELEPHONE_NUMBER,
  CreateCheckoutSessionResponse.JSON_PROPERTY_THEME_ID,
  CreateCheckoutSessionResponse.JSON_PROPERTY_THREE_D_S2_REQUEST_DATA,
  CreateCheckoutSessionResponse.JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY,
  CreateCheckoutSessionResponse.JSON_PROPERTY_TRUSTED_SHOPPER,
  CreateCheckoutSessionResponse.JSON_PROPERTY_URL
})

public class CreateCheckoutSessionResponse {
  public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
  private AccountInfo accountInfo;

  public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
  private Amount additionalAmount;

  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData = null;

  public static final String JSON_PROPERTY_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
  private List<String> allowedPaymentMethods = null;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_AUTHENTICATION_DATA = "authenticationData";
  private AuthenticationData authenticationData;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private BillingAddress billingAddress;

  public static final String JSON_PROPERTY_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
  private List<String> blockedPaymentMethods = null;

  public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
  private Integer captureDelayHours;

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * **iOS** * **Android** * **Web**
   */
  public enum ChannelEnum {
    IOS("iOS"),
    
    ANDROID("Android"),
    
    WEB("Web");

    private String value;

    ChannelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelEnum fromValue(String value) {
      for (ChannelEnum b : ChannelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL = "channel";
  private ChannelEnum channel;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private Company company;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private OffsetDateTime dateOfBirth;

  public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
  private OffsetDateTime deliverAt;

  public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
  private DeliveryAddress deliveryAddress;

  public static final String JSON_PROPERTY_ENABLE_ONE_CLICK = "enableOneClick";
  private Boolean enableOneClick;

  public static final String JSON_PROPERTY_ENABLE_PAY_OUT = "enablePayOut";
  private Boolean enablePayOut;

  public static final String JSON_PROPERTY_ENABLE_RECURRING = "enableRecurring";
  private Boolean enableRecurring;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_FUND_ORIGIN = "fundOrigin";
  private FundOrigin fundOrigin;

  public static final String JSON_PROPERTY_FUND_RECIPIENT = "fundRecipient";
  private FundRecipient fundRecipient;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INSTALLMENT_OPTIONS = "installmentOptions";
  private Map<String, CheckoutSessionInstallmentOption> installmentOptions = null;

  public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
  private List<LineItem> lineItems = null;

  public static final String JSON_PROPERTY_MANDATE = "mandate";
  private Mandate mandate;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  private String merchantOrderReference;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  /**
   * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration
   */
  public enum ModeEnum {
    EMBEDDED("embedded"),
    
    HOSTED("hosted");

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode;

  public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
  private ThreeDSecureData mpiData;

  public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
  private PlatformChargebackLogic platformChargebackLogic;

  public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
  private String recurringExpiry;

  public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
  private String recurringFrequency;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE("CardOnFile"),
    
    SUBSCRIPTION("Subscription"),
    
    UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
  private String redirectFromIssuerMethod;

  public static final String JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
  private String redirectToIssuerMethod;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
  private String returnUrl;

  public static final String JSON_PROPERTY_RISK_DATA = "riskData";
  private RiskData riskData;

  public static final String JSON_PROPERTY_SESSION_DATA = "sessionData";
  private String sessionData;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
  private String shopperIP;

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   */
  public enum ShopperInteractionEnum {
    ECOMMERCE("Ecommerce"),
    
    CONTAUTH("ContAuth"),
    
    MOTO("Moto"),
    
    POS("POS");

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private ShopperInteractionEnum shopperInteraction;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
  private Name shopperName;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
  private String shopperStatement;

  public static final String JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT = "showInstallmentAmount";
  private Boolean showInstallmentAmount;

  public static final String JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON = "showRemovePaymentMethodButton";
  private Boolean showRemovePaymentMethodButton;

  public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  private String socialSecurityNumber;

  public static final String JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
  private Boolean splitCardFundingSources;

  public static final String JSON_PROPERTY_SPLITS = "splits";
  private List<Split> splits = null;

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD = "storePaymentMethod";
  private Boolean storePaymentMethod;

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.
   */
  public enum StorePaymentMethodModeEnum {
    ASKFORCONSENT("askForConsent"),
    
    DISABLED("disabled"),
    
    ENABLED("enabled");

    private String value;

    StorePaymentMethodModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StorePaymentMethodModeEnum fromValue(String value) {
      for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
  private StorePaymentMethodModeEnum storePaymentMethodMode;

  public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
  private String telephoneNumber;

  public static final String JSON_PROPERTY_THEME_ID = "themeId";
  private String themeId;

  public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
  private CheckoutSessionThreeDS2RequestData threeDS2RequestData;

  public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
  @Deprecated
  private Boolean threeDSAuthenticationOnly;

  public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
  private Boolean trustedShopper;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public CreateCheckoutSessionResponse() { 
  }

  public CreateCheckoutSessionResponse accountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
    return this;
  }

   /**
   * Get accountInfo
   * @return accountInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AccountInfo getAccountInfo() {
    return accountInfo;
  }


 /**
  * accountInfo
  *
  * @param accountInfo
  */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
  }


  public CreateCheckoutSessionResponse additionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
    return this;
  }

   /**
   * Get additionalAmount
   * @return additionalAmount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAdditionalAmount() {
    return additionalAmount;
  }


 /**
  * additionalAmount
  *
  * @param additionalAmount
  */ 
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
  }


  public CreateCheckoutSessionResponse additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public CreateCheckoutSessionResponse putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

   /**
   * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
   * @return additionalData
  **/
  @ApiModelProperty(value = "This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getAdditionalData() {
    return additionalData;
  }


 /**
  * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
  *
  * @param additionalData
  */ 
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }


  public CreateCheckoutSessionResponse allowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
    return this;
  }

  public CreateCheckoutSessionResponse addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
    if (this.allowedPaymentMethods == null) {
      this.allowedPaymentMethods = new ArrayList<>();
    }
    this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
    return this;
  }

   /**
   * List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
   * @return allowedPaymentMethods
  **/
  @ApiModelProperty(value = "List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")
  @JsonProperty(JSON_PROPERTY_ALLOWED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAllowedPaymentMethods() {
    return allowedPaymentMethods;
  }


 /**
  * List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
  *
  * @param allowedPaymentMethods
  */ 
  @JsonProperty(JSON_PROPERTY_ALLOWED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
  }


  public CreateCheckoutSessionResponse amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


 /**
  * amount
  *
  * @param amount
  */ 
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public CreateCheckoutSessionResponse applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

   /**
   * Get applicationInfo
   * @return applicationInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }


 /**
  * applicationInfo
  *
  * @param applicationInfo
  */ 
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }


  public CreateCheckoutSessionResponse authenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
    return this;
  }

   /**
   * Get authenticationData
   * @return authenticationData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthenticationData getAuthenticationData() {
    return authenticationData;
  }


 /**
  * authenticationData
  *
  * @param authenticationData
  */ 
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
  }


  public CreateCheckoutSessionResponse billingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BillingAddress getBillingAddress() {
    return billingAddress;
  }


 /**
  * billingAddress
  *
  * @param billingAddress
  */ 
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
  }


  public CreateCheckoutSessionResponse blockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
    return this;
  }

  public CreateCheckoutSessionResponse addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
    if (this.blockedPaymentMethods == null) {
      this.blockedPaymentMethods = new ArrayList<>();
    }
    this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
    return this;
  }

   /**
   * List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
   * @return blockedPaymentMethods
  **/
  @ApiModelProperty(value = "List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")
  @JsonProperty(JSON_PROPERTY_BLOCKED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBlockedPaymentMethods() {
    return blockedPaymentMethods;
  }


 /**
  * List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
  *
  * @param blockedPaymentMethods
  */ 
  @JsonProperty(JSON_PROPERTY_BLOCKED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
  }


  public CreateCheckoutSessionResponse captureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
    return this;
  }

   /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   * @return captureDelayHours
  **/
  @ApiModelProperty(value = "The delay between the authorisation and scheduled auto-capture, specified in hours.")
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }


 /**
  * The delay between the authorisation and scheduled auto-capture, specified in hours.
  *
  * @param captureDelayHours
  */ 
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }


  public CreateCheckoutSessionResponse channel(ChannelEnum channel) {
    this.channel = channel;
    return this;
  }

   /**
   * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * **iOS** * **Android** * **Web**
   * @return channel
  **/
  @ApiModelProperty(value = "The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * **iOS** * **Android** * **Web**")
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChannelEnum getChannel() {
    return channel;
  }


 /**
  * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * **iOS** * **Android** * **Web**
  *
  * @param channel
  */ 
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannel(ChannelEnum channel) {
    this.channel = channel;
  }


  public CreateCheckoutSessionResponse company(Company company) {
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Company getCompany() {
    return company;
  }


 /**
  * company
  *
  * @param company
  */ 
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompany(Company company) {
    this.company = company;
  }


  public CreateCheckoutSessionResponse countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The shopper&#39;s two-letter country code.
   * @return countryCode
  **/
  @ApiModelProperty(value = "The shopper's two-letter country code.")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


 /**
  * The shopper&#39;s two-letter country code.
  *
  * @param countryCode
  */ 
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public CreateCheckoutSessionResponse dateOfBirth(OffsetDateTime dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The shopper&#39;s date of birth in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format.
   * @return dateOfBirth
  **/
  @ApiModelProperty(value = "The shopper's date of birth in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format.")
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDateOfBirth() {
    return dateOfBirth;
  }


 /**
  * The shopper&#39;s date of birth in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format.
  *
  * @param dateOfBirth
  */ 
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(OffsetDateTime dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public CreateCheckoutSessionResponse deliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
    return this;
  }

   /**
   * The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   * @return deliverAt
  **/
  @ApiModelProperty(value = "The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDeliverAt() {
    return deliverAt;
  }


 /**
  * The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
  *
  * @param deliverAt
  */ 
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
  }


  public CreateCheckoutSessionResponse deliveryAddress(DeliveryAddress deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

   /**
   * Get deliveryAddress
   * @return deliveryAddress
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DeliveryAddress getDeliveryAddress() {
    return deliveryAddress;
  }


 /**
  * deliveryAddress
  *
  * @param deliveryAddress
  */ 
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }


  public CreateCheckoutSessionResponse enableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the payment details should be stored for future [one-click payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   * @return enableOneClick
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the shopper will be asked if the payment details should be stored for future [one-click payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).")
  @JsonProperty(JSON_PROPERTY_ENABLE_ONE_CLICK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableOneClick() {
    return enableOneClick;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the payment details should be stored for future [one-click payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
  *
  * @param enableOneClick
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLE_ONE_CLICK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
  }


  public CreateCheckoutSessionResponse enablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized for payouts.
   * @return enablePayOut
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be tokenized for payouts.")
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnablePayOut() {
    return enablePayOut;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized for payouts.
  *
  * @param enablePayOut
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
  }


  public CreateCheckoutSessionResponse enableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where the shopper is not present, such as subscription or automatic top-up payments.
   * @return enableRecurring
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be stored for [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where the shopper is not present, such as subscription or automatic top-up payments.")
  @JsonProperty(JSON_PROPERTY_ENABLE_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableRecurring() {
    return enableRecurring;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where the shopper is not present, such as subscription or automatic top-up payments.
  *
  * @param enableRecurring
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLE_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
  }


  public CreateCheckoutSessionResponse expiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The date the session expires in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified, the expiry date is set to 1 hour after session creation. You cannot set the session expiry to more than 24 hours after session creation.
   * @return expiresAt
  **/
  @ApiModelProperty(required = true, value = "The date the session expires in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified, the expiry date is set to 1 hour after session creation. You cannot set the session expiry to more than 24 hours after session creation.")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


 /**
  * The date the session expires in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified, the expiry date is set to 1 hour after session creation. You cannot set the session expiry to more than 24 hours after session creation.
  *
  * @param expiresAt
  */ 
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public CreateCheckoutSessionResponse fundOrigin(FundOrigin fundOrigin) {
    this.fundOrigin = fundOrigin;
    return this;
  }

   /**
   * Get fundOrigin
   * @return fundOrigin
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUND_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FundOrigin getFundOrigin() {
    return fundOrigin;
  }


 /**
  * fundOrigin
  *
  * @param fundOrigin
  */ 
  @JsonProperty(JSON_PROPERTY_FUND_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundOrigin(FundOrigin fundOrigin) {
    this.fundOrigin = fundOrigin;
  }


  public CreateCheckoutSessionResponse fundRecipient(FundRecipient fundRecipient) {
    this.fundRecipient = fundRecipient;
    return this;
  }

   /**
   * Get fundRecipient
   * @return fundRecipient
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUND_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FundRecipient getFundRecipient() {
    return fundRecipient;
  }


 /**
  * fundRecipient
  *
  * @param fundRecipient
  */ 
  @JsonProperty(JSON_PROPERTY_FUND_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundRecipient(FundRecipient fundRecipient) {
    this.fundRecipient = fundRecipient;
  }


  public CreateCheckoutSessionResponse id(String id) {
    this.id = id;
    return this;
  }

   /**
   * A unique identifier of the session.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "A unique identifier of the session.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * A unique identifier of the session.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public CreateCheckoutSessionResponse installmentOptions(Map<String, CheckoutSessionInstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
    return this;
  }

  public CreateCheckoutSessionResponse putInstallmentOptionsItem(String key, CheckoutSessionInstallmentOption installmentOptionsItem) {
    if (this.installmentOptions == null) {
      this.installmentOptions = new HashMap<>();
    }
    this.installmentOptions.put(key, installmentOptionsItem);
    return this;
  }

   /**
   * A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.
   * @return installmentOptions
  **/
  @ApiModelProperty(value = "A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.")
  @JsonProperty(JSON_PROPERTY_INSTALLMENT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, CheckoutSessionInstallmentOption> getInstallmentOptions() {
    return installmentOptions;
  }


 /**
  * A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.
  *
  * @param installmentOptions
  */ 
  @JsonProperty(JSON_PROPERTY_INSTALLMENT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallmentOptions(Map<String, CheckoutSessionInstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
  }


  public CreateCheckoutSessionResponse lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  public CreateCheckoutSessionResponse addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * Price and product information about the purchased items, to be included on the invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.
   * @return lineItems
  **/
  @ApiModelProperty(value = "Price and product information about the purchased items, to be included on the invoice sent to the shopper. > This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.")
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LineItem> getLineItems() {
    return lineItems;
  }


 /**
  * Price and product information about the purchased items, to be included on the invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.
  *
  * @param lineItems
  */ 
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public CreateCheckoutSessionResponse mandate(Mandate mandate) {
    this.mandate = mandate;
    return this;
  }

   /**
   * Get mandate
   * @return mandate
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MANDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Mandate getMandate() {
    return mandate;
  }


 /**
  * mandate
  *
  * @param mandate
  */ 
  @JsonProperty(JSON_PROPERTY_MANDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMandate(Mandate mandate) {
    this.mandate = mandate;
  }


  public CreateCheckoutSessionResponse mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

   /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   * @return mcc
  **/
  @ApiModelProperty(value = "The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMcc() {
    return mcc;
  }


 /**
  * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
  *
  * @param mcc
  */ 
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public CreateCheckoutSessionResponse merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account identifier, with which you want to process the transaction.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account identifier, with which you want to process the transaction.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantAccount() {
    return merchantAccount;
  }


 /**
  * The merchant account identifier, with which you want to process the transaction.
  *
  * @param merchantAccount
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public CreateCheckoutSessionResponse merchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

   /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   * @return merchantOrderReference
  **/
  @ApiModelProperty(value = "This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }


 /**
  * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
  *
  * @param merchantOrderReference
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }


  public CreateCheckoutSessionResponse metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public CreateCheckoutSessionResponse putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per value. 
   * @return metadata
  **/
  @ApiModelProperty(value = "Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per value. ")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


 /**
  * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per value. 
  *
  * @param metadata
  */ 
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public CreateCheckoutSessionResponse mode(ModeEnum mode) {
    this.mode = mode;
    return this;
  }

   /**
   * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration
   * @return mode
  **/
  @ApiModelProperty(value = "Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration")
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModeEnum getMode() {
    return mode;
  }


 /**
  * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration
  *
  * @param mode
  */ 
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  public CreateCheckoutSessionResponse mpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
    return this;
  }

   /**
   * Get mpiData
   * @return mpiData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDSecureData getMpiData() {
    return mpiData;
  }


 /**
  * mpiData
  *
  * @param mpiData
  */ 
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
  }


  public CreateCheckoutSessionResponse platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
    return this;
  }

   /**
   * Get platformChargebackLogic
   * @return platformChargebackLogic
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlatformChargebackLogic getPlatformChargebackLogic() {
    return platformChargebackLogic;
  }


 /**
  * platformChargebackLogic
  *
  * @param platformChargebackLogic
  */ 
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
  }


  public CreateCheckoutSessionResponse recurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
    return this;
  }

   /**
   * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
   * @return recurringExpiry
  **/
  @ApiModelProperty(value = "Date after which no further authorisations shall be performed. Only for 3D Secure 2.")
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurringExpiry() {
    return recurringExpiry;
  }


 /**
  * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
  *
  * @param recurringExpiry
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
  }


  public CreateCheckoutSessionResponse recurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
    return this;
  }

   /**
   * Minimum number of days between authorisations. Only for 3D Secure 2.
   * @return recurringFrequency
  **/
  @ApiModelProperty(value = "Minimum number of days between authorisations. Only for 3D Secure 2.")
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurringFrequency() {
    return recurringFrequency;
  }


 /**
  * Minimum number of days between authorisations. Only for 3D Secure 2.
  *
  * @param recurringFrequency
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
  }


  public CreateCheckoutSessionResponse recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

   /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel
  **/
  @ApiModelProperty(value = "Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * `Subscription` – A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }


 /**
  * Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
  *
  * @param recurringProcessingModel
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }


  public CreateCheckoutSessionResponse redirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    return this;
  }

   /**
   * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
   * @return redirectFromIssuerMethod
  **/
  @ApiModelProperty(value = "Specifies the redirect method (GET or POST) when redirecting back from the issuer.")
  @JsonProperty(JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectFromIssuerMethod() {
    return redirectFromIssuerMethod;
  }


 /**
  * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
  *
  * @param redirectFromIssuerMethod
  */ 
  @JsonProperty(JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
  }


  public CreateCheckoutSessionResponse redirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
    return this;
  }

   /**
   * Specifies the redirect method (GET or POST) when redirecting to the issuer.
   * @return redirectToIssuerMethod
  **/
  @ApiModelProperty(value = "Specifies the redirect method (GET or POST) when redirecting to the issuer.")
  @JsonProperty(JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectToIssuerMethod() {
    return redirectToIssuerMethod;
  }


 /**
  * Specifies the redirect method (GET or POST) when redirecting to the issuer.
  *
  * @param redirectToIssuerMethod
  */ 
  @JsonProperty(JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
  }


  public CreateCheckoutSessionResponse reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * The reference to uniquely identify a payment.
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "The reference to uniquely identify a payment.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


 /**
  * The reference to uniquely identify a payment.
  *
  * @param reference
  */ 
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public CreateCheckoutSessionResponse returnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * The URL to return to when a redirect payment is completed.
   * @return returnUrl
  **/
  @ApiModelProperty(required = true, value = "The URL to return to when a redirect payment is completed.")
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnUrl() {
    return returnUrl;
  }


 /**
  * The URL to return to when a redirect payment is completed.
  *
  * @param returnUrl
  */ 
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }


  public CreateCheckoutSessionResponse riskData(RiskData riskData) {
    this.riskData = riskData;
    return this;
  }

   /**
   * Get riskData
   * @return riskData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RiskData getRiskData() {
    return riskData;
  }


 /**
  * riskData
  *
  * @param riskData
  */ 
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskData(RiskData riskData) {
    this.riskData = riskData;
  }


  public CreateCheckoutSessionResponse sessionData(String sessionData) {
    this.sessionData = sessionData;
    return this;
  }

   /**
   * The payment session data you need to pass to your front end.
   * @return sessionData
  **/
  @ApiModelProperty(value = "The payment session data you need to pass to your front end.")
  @JsonProperty(JSON_PROPERTY_SESSION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSessionData() {
    return sessionData;
  }


 /**
  * The payment session data you need to pass to your front end.
  *
  * @param sessionData
  */ 
  @JsonProperty(JSON_PROPERTY_SESSION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionData(String sessionData) {
    this.sessionData = sessionData;
  }


  public CreateCheckoutSessionResponse shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The shopper&#39;s email address.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The shopper's email address.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperEmail() {
    return shopperEmail;
  }


 /**
  * The shopper&#39;s email address.
  *
  * @param shopperEmail
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public CreateCheckoutSessionResponse shopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
    return this;
  }

   /**
   * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   * @return shopperIP
  **/
  @ApiModelProperty(value = "The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperIP() {
    return shopperIP;
  }


 /**
  * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
  *
  * @param shopperIP
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
  }


  public CreateCheckoutSessionResponse shopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

   /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   * @return shopperInteraction
  **/
  @ApiModelProperty(value = "Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }


 /**
  * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
  *
  * @param shopperInteraction
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }


  public CreateCheckoutSessionResponse shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

   /**
   * The combination of a language code and a country code to specify the language to be used in the payment.
   * @return shopperLocale
  **/
  @ApiModelProperty(value = "The combination of a language code and a country code to specify the language to be used in the payment.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperLocale() {
    return shopperLocale;
  }


 /**
  * The combination of a language code and a country code to specify the language to be used in the payment.
  *
  * @param shopperLocale
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }


  public CreateCheckoutSessionResponse shopperName(Name shopperName) {
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Name getShopperName() {
    return shopperName;
  }


 /**
  * shopperName
  *
  * @param shopperName
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public CreateCheckoutSessionResponse shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperReference() {
    return shopperReference;
  }


 /**
  * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
  *
  * @param shopperReference
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public CreateCheckoutSessionResponse shopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
    return this;
  }

   /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   * @return shopperStatement
  **/
  @ApiModelProperty(value = "The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperStatement() {
    return shopperStatement;
  }


 /**
  * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
  *
  * @param shopperStatement
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }


  public CreateCheckoutSessionResponse showInstallmentAmount(Boolean showInstallmentAmount) {
    this.showInstallmentAmount = showInstallmentAmount;
    return this;
  }

   /**
   * Set to true to show the payment amount per installment.
   * @return showInstallmentAmount
  **/
  @ApiModelProperty(value = "Set to true to show the payment amount per installment.")
  @JsonProperty(JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowInstallmentAmount() {
    return showInstallmentAmount;
  }


 /**
  * Set to true to show the payment amount per installment.
  *
  * @param showInstallmentAmount
  */ 
  @JsonProperty(JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowInstallmentAmount(Boolean showInstallmentAmount) {
    this.showInstallmentAmount = showInstallmentAmount;
  }


  public CreateCheckoutSessionResponse showRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
    return this;
  }

   /**
   * Set to **true** to show a button that lets the shopper remove a stored payment method.
   * @return showRemovePaymentMethodButton
  **/
  @ApiModelProperty(value = "Set to **true** to show a button that lets the shopper remove a stored payment method.")
  @JsonProperty(JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRemovePaymentMethodButton() {
    return showRemovePaymentMethodButton;
  }


 /**
  * Set to **true** to show a button that lets the shopper remove a stored payment method.
  *
  * @param showRemovePaymentMethodButton
  */ 
  @JsonProperty(JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
  }


  public CreateCheckoutSessionResponse socialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

   /**
   * The shopper&#39;s social security number.
   * @return socialSecurityNumber
  **/
  @ApiModelProperty(value = "The shopper's social security number.")
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }


 /**
  * The shopper&#39;s social security number.
  *
  * @param socialSecurityNumber
  */ 
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }


  public CreateCheckoutSessionResponse splitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
    return this;
  }

   /**
   * Boolean value indicating whether the card payment method should be split into separate debit and credit options.
   * @return splitCardFundingSources
  **/
  @ApiModelProperty(value = "Boolean value indicating whether the card payment method should be split into separate debit and credit options.")
  @JsonProperty(JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSplitCardFundingSources() {
    return splitCardFundingSources;
  }


 /**
  * Boolean value indicating whether the card payment method should be split into separate debit and credit options.
  *
  * @param splitCardFundingSources
  */ 
  @JsonProperty(JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
  }


  public CreateCheckoutSessionResponse splits(List<Split> splits) {
    this.splits = splits;
    return this;
  }

  public CreateCheckoutSessionResponse addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

   /**
   * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   * @return splits
  **/
  @ApiModelProperty(value = "An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).")
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Split> getSplits() {
    return splits;
  }


 /**
  * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
  *
  * @param splits
  */ 
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }


  public CreateCheckoutSessionResponse store(String store) {
    this.store = store;
    return this;
  }

   /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
   * @return store
  **/
  @ApiModelProperty(value = "Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.")
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStore() {
    return store;
  }


 /**
  * Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.
  *
  * @param store
  */ 
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }


  public CreateCheckoutSessionResponse storePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for future [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   * @return storePaymentMethod
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be stored for future [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).")
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getStorePaymentMethod() {
    return storePaymentMethod;
  }


 /**
  * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for future [recurring payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
  *
  * @param storePaymentMethod
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStorePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
  }


  public CreateCheckoutSessionResponse storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
    return this;
  }

   /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.
   * @return storePaymentMethodMode
  **/
  @ApiModelProperty(value = "Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.")
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
    return storePaymentMethodMode;
  }


 /**
  * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.
  *
  * @param storePaymentMethodMode
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
  }


  public CreateCheckoutSessionResponse telephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
    return this;
  }

   /**
   * The shopper&#39;s telephone number.
   * @return telephoneNumber
  **/
  @ApiModelProperty(value = "The shopper's telephone number.")
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTelephoneNumber() {
    return telephoneNumber;
  }


 /**
  * The shopper&#39;s telephone number.
  *
  * @param telephoneNumber
  */ 
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }


  public CreateCheckoutSessionResponse themeId(String themeId) {
    this.themeId = themeId;
    return this;
  }

   /**
   * Sets a custom theme for [Hosted Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout). The value can be any of the **Theme ID** values from your Customer Area.
   * @return themeId
  **/
  @ApiModelProperty(value = "Sets a custom theme for [Hosted Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform=Web&integration=Hosted+Checkout). The value can be any of the **Theme ID** values from your Customer Area.")
  @JsonProperty(JSON_PROPERTY_THEME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThemeId() {
    return themeId;
  }


 /**
  * Sets a custom theme for [Hosted Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout). The value can be any of the **Theme ID** values from your Customer Area.
  *
  * @param themeId
  */ 
  @JsonProperty(JSON_PROPERTY_THEME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeId(String themeId) {
    this.themeId = themeId;
  }


  public CreateCheckoutSessionResponse threeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
    return this;
  }

   /**
   * Get threeDS2RequestData
   * @return threeDS2RequestData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CheckoutSessionThreeDS2RequestData getThreeDS2RequestData() {
    return threeDS2RequestData;
  }


 /**
  * threeDS2RequestData
  *
  * @param threeDS2RequestData
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
  }


  @Deprecated
  public CreateCheckoutSessionResponse threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    return this;
  }

   /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   * @return threeDSAuthenticationOnly
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getThreeDSAuthenticationOnly() {
    return threeDSAuthenticationOnly;
  }


 /**
  * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
  *
  * @param threeDSAuthenticationOnly
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
  }


  public CreateCheckoutSessionResponse trustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
    return this;
  }

   /**
   * Set to true if the payment should be routed to a trusted MID.
   * @return trustedShopper
  **/
  @ApiModelProperty(value = "Set to true if the payment should be routed to a trusted MID.")
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTrustedShopper() {
    return trustedShopper;
  }


 /**
  * Set to true if the payment should be routed to a trusted MID.
  *
  * @param trustedShopper
  */ 
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
  }


  public CreateCheckoutSessionResponse url(String url) {
    this.url = url;
    return this;
  }

   /**
   * The URL for the Hosted Checkout page. Redirect the shopper to this URL so they can make the payment.
   * @return url
  **/
  @ApiModelProperty(value = "The URL for the Hosted Checkout page. Redirect the shopper to this URL so they can make the payment.")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


 /**
  * The URL for the Hosted Checkout page. Redirect the shopper to this URL so they can make the payment.
  *
  * @param url
  */ 
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }


  /**
   * Return true if this CreateCheckoutSessionResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCheckoutSessionResponse createCheckoutSessionResponse = (CreateCheckoutSessionResponse) o;
    return Objects.equals(this.accountInfo, createCheckoutSessionResponse.accountInfo) &&
        Objects.equals(this.additionalAmount, createCheckoutSessionResponse.additionalAmount) &&
        Objects.equals(this.additionalData, createCheckoutSessionResponse.additionalData) &&
        Objects.equals(this.allowedPaymentMethods, createCheckoutSessionResponse.allowedPaymentMethods) &&
        Objects.equals(this.amount, createCheckoutSessionResponse.amount) &&
        Objects.equals(this.applicationInfo, createCheckoutSessionResponse.applicationInfo) &&
        Objects.equals(this.authenticationData, createCheckoutSessionResponse.authenticationData) &&
        Objects.equals(this.billingAddress, createCheckoutSessionResponse.billingAddress) &&
        Objects.equals(this.blockedPaymentMethods, createCheckoutSessionResponse.blockedPaymentMethods) &&
        Objects.equals(this.captureDelayHours, createCheckoutSessionResponse.captureDelayHours) &&
        Objects.equals(this.channel, createCheckoutSessionResponse.channel) &&
        Objects.equals(this.company, createCheckoutSessionResponse.company) &&
        Objects.equals(this.countryCode, createCheckoutSessionResponse.countryCode) &&
        Objects.equals(this.dateOfBirth, createCheckoutSessionResponse.dateOfBirth) &&
        Objects.equals(this.deliverAt, createCheckoutSessionResponse.deliverAt) &&
        Objects.equals(this.deliveryAddress, createCheckoutSessionResponse.deliveryAddress) &&
        Objects.equals(this.enableOneClick, createCheckoutSessionResponse.enableOneClick) &&
        Objects.equals(this.enablePayOut, createCheckoutSessionResponse.enablePayOut) &&
        Objects.equals(this.enableRecurring, createCheckoutSessionResponse.enableRecurring) &&
        Objects.equals(this.expiresAt, createCheckoutSessionResponse.expiresAt) &&
        Objects.equals(this.fundOrigin, createCheckoutSessionResponse.fundOrigin) &&
        Objects.equals(this.fundRecipient, createCheckoutSessionResponse.fundRecipient) &&
        Objects.equals(this.id, createCheckoutSessionResponse.id) &&
        Objects.equals(this.installmentOptions, createCheckoutSessionResponse.installmentOptions) &&
        Objects.equals(this.lineItems, createCheckoutSessionResponse.lineItems) &&
        Objects.equals(this.mandate, createCheckoutSessionResponse.mandate) &&
        Objects.equals(this.mcc, createCheckoutSessionResponse.mcc) &&
        Objects.equals(this.merchantAccount, createCheckoutSessionResponse.merchantAccount) &&
        Objects.equals(this.merchantOrderReference, createCheckoutSessionResponse.merchantOrderReference) &&
        Objects.equals(this.metadata, createCheckoutSessionResponse.metadata) &&
        Objects.equals(this.mode, createCheckoutSessionResponse.mode) &&
        Objects.equals(this.mpiData, createCheckoutSessionResponse.mpiData) &&
        Objects.equals(this.platformChargebackLogic, createCheckoutSessionResponse.platformChargebackLogic) &&
        Objects.equals(this.recurringExpiry, createCheckoutSessionResponse.recurringExpiry) &&
        Objects.equals(this.recurringFrequency, createCheckoutSessionResponse.recurringFrequency) &&
        Objects.equals(this.recurringProcessingModel, createCheckoutSessionResponse.recurringProcessingModel) &&
        Objects.equals(this.redirectFromIssuerMethod, createCheckoutSessionResponse.redirectFromIssuerMethod) &&
        Objects.equals(this.redirectToIssuerMethod, createCheckoutSessionResponse.redirectToIssuerMethod) &&
        Objects.equals(this.reference, createCheckoutSessionResponse.reference) &&
        Objects.equals(this.returnUrl, createCheckoutSessionResponse.returnUrl) &&
        Objects.equals(this.riskData, createCheckoutSessionResponse.riskData) &&
        Objects.equals(this.sessionData, createCheckoutSessionResponse.sessionData) &&
        Objects.equals(this.shopperEmail, createCheckoutSessionResponse.shopperEmail) &&
        Objects.equals(this.shopperIP, createCheckoutSessionResponse.shopperIP) &&
        Objects.equals(this.shopperInteraction, createCheckoutSessionResponse.shopperInteraction) &&
        Objects.equals(this.shopperLocale, createCheckoutSessionResponse.shopperLocale) &&
        Objects.equals(this.shopperName, createCheckoutSessionResponse.shopperName) &&
        Objects.equals(this.shopperReference, createCheckoutSessionResponse.shopperReference) &&
        Objects.equals(this.shopperStatement, createCheckoutSessionResponse.shopperStatement) &&
        Objects.equals(this.showInstallmentAmount, createCheckoutSessionResponse.showInstallmentAmount) &&
        Objects.equals(this.showRemovePaymentMethodButton, createCheckoutSessionResponse.showRemovePaymentMethodButton) &&
        Objects.equals(this.socialSecurityNumber, createCheckoutSessionResponse.socialSecurityNumber) &&
        Objects.equals(this.splitCardFundingSources, createCheckoutSessionResponse.splitCardFundingSources) &&
        Objects.equals(this.splits, createCheckoutSessionResponse.splits) &&
        Objects.equals(this.store, createCheckoutSessionResponse.store) &&
        Objects.equals(this.storePaymentMethod, createCheckoutSessionResponse.storePaymentMethod) &&
        Objects.equals(this.storePaymentMethodMode, createCheckoutSessionResponse.storePaymentMethodMode) &&
        Objects.equals(this.telephoneNumber, createCheckoutSessionResponse.telephoneNumber) &&
        Objects.equals(this.themeId, createCheckoutSessionResponse.themeId) &&
        Objects.equals(this.threeDS2RequestData, createCheckoutSessionResponse.threeDS2RequestData) &&
        Objects.equals(this.threeDSAuthenticationOnly, createCheckoutSessionResponse.threeDSAuthenticationOnly) &&
        Objects.equals(this.trustedShopper, createCheckoutSessionResponse.trustedShopper) &&
        Objects.equals(this.url, createCheckoutSessionResponse.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountInfo, additionalAmount, additionalData, allowedPaymentMethods, amount, applicationInfo, authenticationData, billingAddress, blockedPaymentMethods, captureDelayHours, channel, company, countryCode, dateOfBirth, deliverAt, deliveryAddress, enableOneClick, enablePayOut, enableRecurring, expiresAt, fundOrigin, fundRecipient, id, installmentOptions, lineItems, mandate, mcc, merchantAccount, merchantOrderReference, metadata, mode, mpiData, platformChargebackLogic, recurringExpiry, recurringFrequency, recurringProcessingModel, redirectFromIssuerMethod, redirectToIssuerMethod, reference, returnUrl, riskData, sessionData, shopperEmail, shopperIP, shopperInteraction, shopperLocale, shopperName, shopperReference, shopperStatement, showInstallmentAmount, showRemovePaymentMethodButton, socialSecurityNumber, splitCardFundingSources, splits, store, storePaymentMethod, storePaymentMethodMode, telephoneNumber, themeId, threeDS2RequestData, threeDSAuthenticationOnly, trustedShopper, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCheckoutSessionResponse {\n");
    sb.append("    accountInfo: ").append(toIndentedString(accountInfo)).append("\n");
    sb.append("    additionalAmount: ").append(toIndentedString(additionalAmount)).append("\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    allowedPaymentMethods: ").append(toIndentedString(allowedPaymentMethods)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    authenticationData: ").append(toIndentedString(authenticationData)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    blockedPaymentMethods: ").append(toIndentedString(blockedPaymentMethods)).append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    deliverAt: ").append(toIndentedString(deliverAt)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    enableOneClick: ").append(toIndentedString(enableOneClick)).append("\n");
    sb.append("    enablePayOut: ").append(toIndentedString(enablePayOut)).append("\n");
    sb.append("    enableRecurring: ").append(toIndentedString(enableRecurring)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    fundOrigin: ").append(toIndentedString(fundOrigin)).append("\n");
    sb.append("    fundRecipient: ").append(toIndentedString(fundRecipient)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    installmentOptions: ").append(toIndentedString(installmentOptions)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    mandate: ").append(toIndentedString(mandate)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ").append(toIndentedString(merchantOrderReference)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    mpiData: ").append(toIndentedString(mpiData)).append("\n");
    sb.append("    platformChargebackLogic: ").append(toIndentedString(platformChargebackLogic)).append("\n");
    sb.append("    recurringExpiry: ").append(toIndentedString(recurringExpiry)).append("\n");
    sb.append("    recurringFrequency: ").append(toIndentedString(recurringFrequency)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    redirectFromIssuerMethod: ").append(toIndentedString(redirectFromIssuerMethod)).append("\n");
    sb.append("    redirectToIssuerMethod: ").append(toIndentedString(redirectToIssuerMethod)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    riskData: ").append(toIndentedString(riskData)).append("\n");
    sb.append("    sessionData: ").append(toIndentedString(sessionData)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperIP: ").append(toIndentedString(shopperIP)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    showInstallmentAmount: ").append(toIndentedString(showInstallmentAmount)).append("\n");
    sb.append("    showRemovePaymentMethodButton: ").append(toIndentedString(showRemovePaymentMethodButton)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    splitCardFundingSources: ").append(toIndentedString(splitCardFundingSources)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storePaymentMethod: ").append(toIndentedString(storePaymentMethod)).append("\n");
    sb.append("    storePaymentMethodMode: ").append(toIndentedString(storePaymentMethodMode)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    themeId: ").append(toIndentedString(themeId)).append("\n");
    sb.append("    threeDS2RequestData: ").append(toIndentedString(threeDS2RequestData)).append("\n");
    sb.append("    threeDSAuthenticationOnly: ").append(toIndentedString(threeDSAuthenticationOnly)).append("\n");
    sb.append("    trustedShopper: ").append(toIndentedString(trustedShopper)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CreateCheckoutSessionResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CreateCheckoutSessionResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to CreateCheckoutSessionResponse
   */
  public static CreateCheckoutSessionResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CreateCheckoutSessionResponse.class);
  }
/**
  * Convert an instance of CreateCheckoutSessionResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

