/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"appId", "checkoutAttemptId", "recurringDetailReference", "shopperNotificationReference", "storedPaymentMethodId", "type"})
public class UpiIntentDetails {
    public static final String JSON_PROPERTY_APP_ID = "appId";
    private String appId;
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @Deprecated
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_NOTIFICATION_REFERENCE = "shopperNotificationReference";
    private String shopperNotificationReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public UpiIntentDetails appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(value="TPAP (Third Party Application) Id that is being used to make the UPI payment")
    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppId() {
        return this.appId;
    }

    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public UpiIntentDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    @Deprecated
    public UpiIntentDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public UpiIntentDetails shopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
        return this;
    }

    @ApiModelProperty(value="The `shopperNotificationReference` returned in the response when you requested to notify the shopper. Used for recurring payment only.")
    @JsonProperty(value="shopperNotificationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperNotificationReference() {
        return this.shopperNotificationReference;
    }

    @JsonProperty(value="shopperNotificationReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
    }

    public UpiIntentDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public UpiIntentDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**upi_intent**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpiIntentDetails upiIntentDetails = (UpiIntentDetails)o;
        return Objects.equals(this.appId, upiIntentDetails.appId) && Objects.equals(this.checkoutAttemptId, upiIntentDetails.checkoutAttemptId) && Objects.equals(this.recurringDetailReference, upiIntentDetails.recurringDetailReference) && Objects.equals(this.shopperNotificationReference, upiIntentDetails.shopperNotificationReference) && Objects.equals(this.storedPaymentMethodId, upiIntentDetails.storedPaymentMethodId) && Objects.equals((Object)this.type, (Object)upiIntentDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appId, this.checkoutAttemptId, this.recurringDetailReference, this.shopperNotificationReference, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpiIntentDetails {\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperNotificationReference: ").append(this.toIndentedString(this.shopperNotificationReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpiIntentDetails fromJson(String jsonString) throws JsonProcessingException {
        return (UpiIntentDetails)JSON.getMapper().readValue(jsonString, UpiIntentDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        UPI_INTENT("upi_intent");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

