/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"formFactor", "iban", "type"})
public class IbanAccountIdentification {
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private String formFactor;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public IbanAccountIdentification formFactor(String formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(value="The form factor of the account.  Possible values: **physical**, **virtual**. Default value: **physical**.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(String formFactor) {
        this.formFactor = formFactor;
    }

    public IbanAccountIdentification iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(required=true, value="The international bank account number as defined in the [ISO-13616](https://www.iso.org/standard/81090.html) standard.")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIban(String iban) {
        this.iban = iban;
    }

    public IbanAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**iban**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IbanAccountIdentification ibanAccountIdentification = (IbanAccountIdentification)o;
        return Objects.equals(this.formFactor, ibanAccountIdentification.formFactor) && Objects.equals(this.iban, ibanAccountIdentification.iban) && Objects.equals((Object)this.type, (Object)ibanAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formFactor, this.iban, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IbanAccountIdentification {\n");
        sb.append("    formFactor: ").append(this.toIndentedString(this.formFactor)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static IbanAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (IbanAccountIdentification)JSON.getMapper().readValue(jsonString, IbanAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        IBAN("iban");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

