/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.MigratedAccounts;
import com.adyen.model.marketpayaccount.MigratedShareholders;
import com.adyen.model.marketpayaccount.MigratedStores;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderId", "balancePlatform", "migrated", "migratedAccounts", "migratedShareholders", "migratedStores", "migrationDate"})
public class MigrationData {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
    private String accountHolderId;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_MIGRATED = "migrated";
    private Boolean migrated;
    public static final String JSON_PROPERTY_MIGRATED_ACCOUNTS = "migratedAccounts";
    private List<MigratedAccounts> migratedAccounts = null;
    public static final String JSON_PROPERTY_MIGRATED_SHAREHOLDERS = "migratedShareholders";
    private List<MigratedShareholders> migratedShareholders = null;
    public static final String JSON_PROPERTY_MIGRATED_STORES = "migratedStores";
    private List<MigratedStores> migratedStores = null;
    public static final String JSON_PROPERTY_MIGRATION_DATE = "migrationDate";
    private OffsetDateTime migrationDate;

    public MigrationData accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the account holder in the balance platform.")
    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public MigrationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platfrom to which the account holder was migrated.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public MigrationData migrated(Boolean migrated) {
        this.migrated = migrated;
        return this;
    }

    @ApiModelProperty(value="Set to **true** if the account holder has been migrated.")
    @JsonProperty(value="migrated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMigrated() {
        return this.migrated;
    }

    @JsonProperty(value="migrated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigrated(Boolean migrated) {
        this.migrated = migrated;
    }

    public MigrationData migratedAccounts(List<MigratedAccounts> migratedAccounts) {
        this.migratedAccounts = migratedAccounts;
        return this;
    }

    public MigrationData addMigratedAccountsItem(MigratedAccounts migratedAccountsItem) {
        if (this.migratedAccounts == null) {
            this.migratedAccounts = new ArrayList<MigratedAccounts>();
        }
        this.migratedAccounts.add(migratedAccountsItem);
        return this;
    }

    @ApiModelProperty(value="Contains the mapping of virtual account codes (classic integration) to the balance account codes (balance platform) associated with the migrated account holder.")
    @JsonProperty(value="migratedAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MigratedAccounts> getMigratedAccounts() {
        return this.migratedAccounts;
    }

    @JsonProperty(value="migratedAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedAccounts(List<MigratedAccounts> migratedAccounts) {
        this.migratedAccounts = migratedAccounts;
    }

    public MigrationData migratedShareholders(List<MigratedShareholders> migratedShareholders) {
        this.migratedShareholders = migratedShareholders;
        return this;
    }

    public MigrationData addMigratedShareholdersItem(MigratedShareholders migratedShareholdersItem) {
        if (this.migratedShareholders == null) {
            this.migratedShareholders = new ArrayList<MigratedShareholders>();
        }
        this.migratedShareholders.add(migratedShareholdersItem);
        return this;
    }

    @ApiModelProperty(value="Contains the mapping of shareholders associated with the migrated legal entities.")
    @JsonProperty(value="migratedShareholders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MigratedShareholders> getMigratedShareholders() {
        return this.migratedShareholders;
    }

    @JsonProperty(value="migratedShareholders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedShareholders(List<MigratedShareholders> migratedShareholders) {
        this.migratedShareholders = migratedShareholders;
    }

    public MigrationData migratedStores(List<MigratedStores> migratedStores) {
        this.migratedStores = migratedStores;
        return this;
    }

    public MigrationData addMigratedStoresItem(MigratedStores migratedStoresItem) {
        if (this.migratedStores == null) {
            this.migratedStores = new ArrayList<MigratedStores>();
        }
        this.migratedStores.add(migratedStoresItem);
        return this;
    }

    @ApiModelProperty(value="Contains the mapping of business lines and stores associated with the migrated account holder.")
    @JsonProperty(value="migratedStores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MigratedStores> getMigratedStores() {
        return this.migratedStores;
    }

    @JsonProperty(value="migratedStores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedStores(List<MigratedStores> migratedStores) {
        this.migratedStores = migratedStores;
    }

    public MigrationData migrationDate(OffsetDateTime migrationDate) {
        this.migrationDate = migrationDate;
        return this;
    }

    @ApiModelProperty(value="The date when account holder was migrated.")
    @JsonProperty(value="migrationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getMigrationDate() {
        return this.migrationDate;
    }

    @JsonProperty(value="migrationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigrationDate(OffsetDateTime migrationDate) {
        this.migrationDate = migrationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationData migrationData = (MigrationData)o;
        return Objects.equals(this.accountHolderId, migrationData.accountHolderId) && Objects.equals(this.balancePlatform, migrationData.balancePlatform) && Objects.equals(this.migrated, migrationData.migrated) && Objects.equals(this.migratedAccounts, migrationData.migratedAccounts) && Objects.equals(this.migratedShareholders, migrationData.migratedShareholders) && Objects.equals(this.migratedStores, migrationData.migratedStores) && Objects.equals(this.migrationDate, migrationData.migrationDate);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderId, this.balancePlatform, this.migrated, this.migratedAccounts, this.migratedShareholders, this.migratedStores, this.migrationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationData {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    migrated: ").append(this.toIndentedString(this.migrated)).append("\n");
        sb.append("    migratedAccounts: ").append(this.toIndentedString(this.migratedAccounts)).append("\n");
        sb.append("    migratedShareholders: ").append(this.toIndentedString(this.migratedShareholders)).append("\n");
        sb.append("    migratedStores: ").append(this.toIndentedString(this.migratedStores)).append("\n");
        sb.append("    migrationDate: ").append(this.toIndentedString(this.migrationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MigrationData fromJson(String jsonString) throws JsonProcessingException {
        return (MigrationData)JSON.getMapper().readValue(jsonString, MigrationData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

