/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.AmountAdjustment;
import com.adyen.model.transferwebhooks.BalanceMutation;
import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.Modification;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "amountAdjustments", "bookingDate", "estimatedArrivalTime", "id", "modification", "mutations", "originalAmount", "reason", "status", "transactionId", "type", "updateDate", "valueDate"})
public class TransferEvent {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_AMOUNT_ADJUSTMENTS = "amountAdjustments";
    private List<AmountAdjustment> amountAdjustments = null;
    public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
    private OffsetDateTime bookingDate;
    public static final String JSON_PROPERTY_ESTIMATED_ARRIVAL_TIME = "estimatedArrivalTime";
    private OffsetDateTime estimatedArrivalTime;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MODIFICATION = "modification";
    private Modification modification;
    public static final String JSON_PROPERTY_MUTATIONS = "mutations";
    private List<BalanceMutation> mutations = null;
    public static final String JSON_PROPERTY_ORIGINAL_AMOUNT = "originalAmount";
    private Amount originalAmount;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TRANSACTION_ID = "transactionId";
    private String transactionId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UPDATE_DATE = "updateDate";
    private OffsetDateTime updateDate;
    public static final String JSON_PROPERTY_VALUE_DATE = "valueDate";
    private OffsetDateTime valueDate;

    public TransferEvent amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferEvent amountAdjustments(List<AmountAdjustment> amountAdjustments) {
        this.amountAdjustments = amountAdjustments;
        return this;
    }

    public TransferEvent addAmountAdjustmentsItem(AmountAdjustment amountAdjustmentsItem) {
        if (this.amountAdjustments == null) {
            this.amountAdjustments = new ArrayList<AmountAdjustment>();
        }
        this.amountAdjustments.add(amountAdjustmentsItem);
        return this;
    }

    @ApiModelProperty(value="The amount adjustments in this transfer.")
    @JsonProperty(value="amountAdjustments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AmountAdjustment> getAmountAdjustments() {
        return this.amountAdjustments;
    }

    @JsonProperty(value="amountAdjustments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountAdjustments(List<AmountAdjustment> amountAdjustments) {
        this.amountAdjustments = amountAdjustments;
    }

    public TransferEvent bookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(value="The date when the transfer request was sent.")
    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getBookingDate() {
        return this.bookingDate;
    }

    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
    }

    public TransferEvent estimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
        return this;
    }

    @ApiModelProperty(value="The estimated time the beneficiary should have access to the funds.")
    @JsonProperty(value="estimatedArrivalTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEstimatedArrivalTime() {
        return this.estimatedArrivalTime;
    }

    @JsonProperty(value="estimatedArrivalTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
    }

    public TransferEvent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the transfer event.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TransferEvent modification(Modification modification) {
        this.modification = modification;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="modification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Modification getModification() {
        return this.modification;
    }

    @JsonProperty(value="modification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModification(Modification modification) {
        this.modification = modification;
    }

    public TransferEvent mutations(List<BalanceMutation> mutations) {
        this.mutations = mutations;
        return this;
    }

    public TransferEvent addMutationsItem(BalanceMutation mutationsItem) {
        if (this.mutations == null) {
            this.mutations = new ArrayList<BalanceMutation>();
        }
        this.mutations.add(mutationsItem);
        return this;
    }

    @ApiModelProperty(value="The list of the balance mutation per event.")
    @JsonProperty(value="mutations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BalanceMutation> getMutations() {
        return this.mutations;
    }

    @JsonProperty(value="mutations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMutations(List<BalanceMutation> mutations) {
        this.mutations = mutations;
    }

    public TransferEvent originalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="originalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    @JsonProperty(value="originalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
    }

    public TransferEvent reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the transfer status.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferEvent status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the transfer event.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferEvent transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The id of the transaction that is related to this accounting event. Only sent for events of type **accounting** where the balance changes.")
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransferEvent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the transfer event. Possible values: **accounting**, **tracking**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TransferEvent updateDate(OffsetDateTime updateDate) {
        this.updateDate = updateDate;
        return this;
    }

    @ApiModelProperty(value="The date when the tracking status was updated.")
    @JsonProperty(value="updateDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdateDate() {
        return this.updateDate;
    }

    @JsonProperty(value="updateDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdateDate(OffsetDateTime updateDate) {
        this.updateDate = updateDate;
    }

    public TransferEvent valueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(value="A future date, when the funds are expected to be deducted from or credited to the balance account.")
    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEvent transferEvent = (TransferEvent)o;
        return Objects.equals(this.amount, transferEvent.amount) && Objects.equals(this.amountAdjustments, transferEvent.amountAdjustments) && Objects.equals(this.bookingDate, transferEvent.bookingDate) && Objects.equals(this.estimatedArrivalTime, transferEvent.estimatedArrivalTime) && Objects.equals(this.id, transferEvent.id) && Objects.equals(this.modification, transferEvent.modification) && Objects.equals(this.mutations, transferEvent.mutations) && Objects.equals(this.originalAmount, transferEvent.originalAmount) && Objects.equals((Object)this.reason, (Object)transferEvent.reason) && Objects.equals((Object)this.status, (Object)transferEvent.status) && Objects.equals(this.transactionId, transferEvent.transactionId) && Objects.equals((Object)this.type, (Object)transferEvent.type) && Objects.equals(this.updateDate, transferEvent.updateDate) && Objects.equals(this.valueDate, transferEvent.valueDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountAdjustments, this.bookingDate, this.estimatedArrivalTime, this.id, this.modification, this.mutations, this.originalAmount, this.reason, this.status, this.transactionId, this.type, this.updateDate, this.valueDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEvent {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountAdjustments: ").append(this.toIndentedString(this.amountAdjustments)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    estimatedArrivalTime: ").append(this.toIndentedString(this.estimatedArrivalTime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modification: ").append(this.toIndentedString(this.modification)).append("\n");
        sb.append("    mutations: ").append(this.toIndentedString(this.mutations)).append("\n");
        sb.append("    originalAmount: ").append(this.toIndentedString(this.originalAmount)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updateDate: ").append(this.toIndentedString(this.updateDate)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferEvent fromJson(String jsonString) throws JsonProcessingException {
        return (TransferEvent)JSON.getMapper().readValue(jsonString, TransferEvent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ACCOUNTING("accounting"),
        TRACKING("tracking");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CAPTUREDEXTERNALLY("capturedExternally"),
        CHARGEBACK("chargeback"),
        CHARGEBACKEXTERNALLY("chargebackExternally"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUNDEDEXTERNALLY("refundedExternally"),
        REFUSED("refused"),
        REJECTED("rejected"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        BALANCEACCOUNTTEMPORARILYBLOCKEDBYTRANSACTIONRULE("balanceAccountTemporarilyBlockedByTransactionRule"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        DECLINEDBYTRANSACTIONRULE("declinedByTransactionRule"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        SCAFAILED("scaFailed"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

