/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"cardNumber", "expiryDate", "issuerCountry", "issuerState", "nationalIdExempt", "number", "type"})
public class IdentificationData {
    public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
    private String cardNumber;
    public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
    private String expiryDate;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    @Deprecated
    private String issuerCountry;
    public static final String JSON_PROPERTY_ISSUER_STATE = "issuerState";
    private String issuerState;
    public static final String JSON_PROPERTY_NATIONAL_ID_EXEMPT = "nationalIdExempt";
    private Boolean nationalIdExempt;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public IdentificationData cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @ApiModelProperty(value="The card number of the document that was issued (AU only).")
    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardNumber() {
        return this.cardNumber;
    }

    @JsonProperty(value="cardNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public IdentificationData expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @ApiModelProperty(value="The expiry date of the document, in YYYY-MM-DD format.")
    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryDate() {
        return this.expiryDate;
    }

    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Deprecated
    public IdentificationData issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the document was issued. For example, **US**.")
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @Deprecated
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public IdentificationData issuerState(String issuerState) {
        this.issuerState = issuerState;
        return this;
    }

    @ApiModelProperty(value="The state or province where the document was issued (AU only).")
    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerState() {
        return this.issuerState;
    }

    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerState(String issuerState) {
        this.issuerState = issuerState;
    }

    public IdentificationData nationalIdExempt(Boolean nationalIdExempt) {
        this.nationalIdExempt = nationalIdExempt;
        return this;
    }

    @ApiModelProperty(value="Applies only to individuals in the US. Set to **true** if the individual does not have an SSN. To verify their identity, Adyen will require them to upload an ID document.")
    @JsonProperty(value="nationalIdExempt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNationalIdExempt() {
        return this.nationalIdExempt;
    }

    @JsonProperty(value="nationalIdExempt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationalIdExempt(Boolean nationalIdExempt) {
        this.nationalIdExempt = nationalIdExempt;
    }

    public IdentificationData number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The number in the document.")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    public IdentificationData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of identity data. For **individual**, the `type` value is **nationalIdNumber**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentificationData identificationData = (IdentificationData)o;
        return Objects.equals(this.cardNumber, identificationData.cardNumber) && Objects.equals(this.expiryDate, identificationData.expiryDate) && Objects.equals(this.issuerCountry, identificationData.issuerCountry) && Objects.equals(this.issuerState, identificationData.issuerState) && Objects.equals(this.nationalIdExempt, identificationData.nationalIdExempt) && Objects.equals(this.number, identificationData.number) && Objects.equals((Object)this.type, (Object)identificationData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumber, this.expiryDate, this.issuerCountry, this.issuerState, this.nationalIdExempt, this.number, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentificationData {\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    issuerState: ").append(this.toIndentedString(this.issuerState)).append("\n");
        sb.append("    nationalIdExempt: ").append(this.toIndentedString(this.nationalIdExempt)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static IdentificationData fromJson(String jsonString) throws JsonProcessingException {
        return (IdentificationData)JSON.getMapper().readValue(jsonString, IdentificationData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        NATIONALIDNUMBER("nationalIdNumber");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

